#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
	if [[ ! -d /opt/oss/${tenant_name}/apps/BgpService ]]
    then
        echo "BgpService is not installed."
        exit 0
	fi
	
    # 更新bgp peer的tcp保活使能字段
	. /opt/oss/manager/agent/bin/engr_profile.sh
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/bgp_peer_update_tcphold.py
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "Update bgp peer's tcphold successfully."
    else
        echo "Update bgp peer's tcphold failed."
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1