#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
log_dir=$(sh ${EXEC_HOME}/../get_log_dir.sh)
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" | tee -a ${log_file}


function copy_to_othernode()
{
    ip=$1
    retry_times=5
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start copy file"
    for((i=1;i<=${retry_times};i++))
    do
        if [[ $ip =~ ':' ]]
        then 
            scp -r /home/ossadm/upgrade_portmirror ossadm@[$ip]:/home/ossadm
        else
            scp -r /home/ossadm/upgrade_portmirror ossadm@$ip:/home/ossadm
        fi
        result1=$?
        if [[ ${result1} == "0" ]]
        then
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "success copy file"
            break
        else
            echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "failed copy file, retry_times: ${i}"
            if [[ ${i} -eq ${retry_times} ]]
            then
                exit 1
            fi
            sleep 10
        fi
    done
}

function restart_app()
{
    app_name=$1
    nodeips=$2
    for ip in $(echo ${nodeips} | sed 's/,/ /g')
    do            
    {            
    ssh -o ServerAliveInterval=60 ossadm@${ip} <<EOF
    rm -rf /home/ossadm/upgrade_portmirror
    /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app $1
    exit 
EOF
    }&
    sleep 5
    done        
    wait
    
}

function main()
{      
    #安装端口镜像（1,2,3节点都要装，1，第2、3个节点copy或者scp）
    plugin_dir=/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online
    flag_dir=${plugin_dir}/service/scripts/flag_dir
    if [ -f ${flag_dir}/portmirror_installed.txt ];then
        #第一个节点
        echo "Start upgrade port mirror plugin."
        if [ -d /opt/pub/software/repository/Services/Common/PortmirrorPlugin ];then
            echo "Start first node install. "
            rm -rf /home/ossadm/upgrade_portmirror
            rm -rf ${EXEC_HOME}/startportmirrorsuccessful.txt
            rm -rf ${EXEC_HOME}/installportmirrorfailed_*.txt
            rm -rf ${temporary_dir}/installportmirrorfailed_*.txt
            ls -rt /opt/pub/software/repository/Services/Common/PortmirrorPlugin | grep PortmirrorPlugin-.*.zip | grep -v pub | grep -v .cms | grep -v .crl > $EXEC_HOME/portmirrorpkg.list
            lastpkg=`awk 'END {print}' $EXEC_HOME/portmirrorpkg.list`
            mkdir -p /home/ossadm/upgrade_portmirror
            cp /opt/pub/software/repository/Services/Common/PortmirrorPlugin/${lastpkg} /home/ossadm/upgrade_portmirror
            cp  ${EXEC_HOME}/upgrade_sudo_pkg.tar /home/ossadm/upgrade_portmirror
            if [ ! -f /home/ossadm/upgrade_portmirror/upgrade_sudo_pkg.tar ];then
                echo "Get port mirror sudo script pkg failed"
                exit 1
            fi
            ls /home/ossadm/upgrade_portmirror | grep PortmirrorPlugin
            if [ $? != 0 ];then
                echo "Get port mirror pkg failed"
                exit 1
            fi
            #第二个第三个节点从第一个节点scp
            cd $EXEC_HOME/../pyscripts
            node1_maintenance_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import get_ip_by_num;print(get_ip_by_num.get_ip('0'))"`
            node2_maintenance_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import get_ip_by_num;print(get_ip_by_num.get_ip('1'))"`
            if [[ ${node2_maintenance_ip} != "" ]];then
                ssh -o ServerAliveInterval=60 ossadm@${node2_maintenance_ip} <<EOF
                rm -rf /home/ossadm/upgrade_portmirror
                rm -rf ${temporary_dir}/installportmirrorfailed_*.txt
EOF
                copy_to_othernode ${node2_maintenance_ip}
                result1=$?
                if [[ ${result1} != "0" ]]
                then
                    echo "scp port mirror pkg to ${node2_maintenance_ip} failed"
                    exit 1
                fi
            fi
            node3_maintenance_ip=`. /opt/oss/manager/agent/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "import get_ip_by_num;print(get_ip_by_num.get_ip('2'))"`
            if [[ ${node3_maintenance_ip} != "" ]];then
                ssh -o ServerAliveInterval=60 ossadm@${node3_maintenance_ip} <<EOF
                rm -rf /home/ossadm/upgrade_portmirror
                rm -rf ${temporary_dir}/installportmirrorfailed_*.txt
EOF
                copy_to_othernode ${node3_maintenance_ip}  
                result1=$?
                if [[ ${result1} != "0" ]]
                then
                    echo "scp port mirror pkg to ${node3_maintenance_ip} failed"
                    exit 1
                fi   
            fi
            #首节点特有的处理,调用接口刷权限点
            . /opt/oss/manager/bin/engr_profile.sh
            export SSL_ROOT=/opt/oss/manager/etc/ssl
            ${PYTHONHOME}/bin/python portmirror_i18n.py
            ${PYTHONHOME}/bin/python portmirror_permissions.py
            ${PYTHONHOME}/bin/python portmirror_permissions_user_add.py
            #安装前获取微服务进程号
            node1dcnoampid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOAMService" | grep ${node1_maintenance_ip} | awk -F " "  '{print $7}' `
            node1dcnservicepid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService" | grep ${node1_maintenance_ip} | awk -F " "  '{print $7}' `
            node1dcnopenempid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOpenEMService" | grep ${node1_maintenance_ip} | awk -F " "  '{print $7}' `
            if [[ ${node2_maintenance_ip} != "" ]];then
                node2dcnoampid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOAMService" | grep ${node2_maintenance_ip} | awk -F " "  '{print $7}' `
                node2dcnservicepid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService" | grep ${node2_maintenance_ip} | awk -F " "  '{print $7}' `
                node2dcnopenempid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOpenEMService" | grep ${node2_maintenance_ip} | awk -F " "  '{print $7}' `
            fi
            if [[ ${node3_maintenance_ip} != "" ]];then
                node3dcnoampid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOAMService" | grep ${node3_maintenance_ip} | awk -F " "  '{print $7}' `
                node3dcnservicepid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService" | grep ${node3_maintenance_ip} | awk -F " "  '{print $7}' `
                node3dcnopenempid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOpenEMService" | grep ${node3_maintenance_ip} | awk -F " "  '{print $7}' `
            fi

            #安装端口镜像           
            nodeips=${node1_maintenance_ip},${node2_maintenance_ip},${node3_maintenance_ip}
            for ip in $(echo ${nodeips} | sed 's/,/ /g')
            do            
            {            
            ssh -o ServerAliveInterval=30 ossadm@${ip} <<EOF
            if [ -f ${temporary_dir}/installportmirrorfailed_${ip}.txt ];then
                rm -rf ${temporary_dir}/installportmirrorfailed_${ip}.txt
            fi
            rm -rf ${EXEC_HOME}/installportmirrorfailed_${ip}.txt
            unzip -oq /home/ossadm/upgrade_portmirror/PortmirrorPlugin-*.zip  -d /home/ossadm/upgrade_portmirror
            sudo $SUPER_ROOT/execute.sh /home/ossadm/upgrade_portmirror/upgrade_sudo_pkg.tar /${EXEC_HOME}/upgrade_portmirror port_mirror_install.sh ${ip}
            exit 
EOF
            }&
            sleep 5
            done        
            wait

            for ip in $(echo ${nodeips} | sed 's/,/ /g')
            do
                scp ossadm@\[$ip\]:${temporary_dir}/installportmirrorfailed_${ip}.txt ${EXEC_HOME} >/dev/null 2>&1
            done

            if [[ -f ${EXEC_HOME}/installportmirrorfailed_${node1_maintenance_ip}.txt || -f ${EXEC_HOME}/installportmirrorfailed_${node2_maintenance_ip}.txt || -f ${EXEC_HOME}/installportmirrorfailed_${node3_maintenance_ip}.txt  ]];then
                echo "Install portmirrror failed"
                exit 1
            else
                echo "Install portmirrror successful"
            fi

            #安装完包，启动微服务
            restart_app DCNOAMService ${nodeips}
            restart_app DCNService ${nodeips}
            sleep 60s
            restart_app DCNOpenEMService ${nodeips}
                
            #检查启动状态
            appstatus_count=0
            while true
            do
                newnode1dcnoampid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOAMService" | grep ${node1_maintenance_ip} | awk -F " "  '{print $7}' `
                newnode1dcnservicepid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService" | grep ${node1_maintenance_ip} | awk -F " "  '{print $7}' `
                newnode1dcnopenempid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOpenEMService" | grep ${node1_maintenance_ip} | awk -F " "  '{print $7}' `
                if [[ ${node2_maintenance_ip} != "" ]];then
                    newnode2dcnoampid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOAMService" | grep ${node2_maintenance_ip} | awk -F " "  '{print $7}' `
                    newnode2dcnservicepid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService" | grep ${node2_maintenance_ip} | awk -F " "  '{print $7}' `
                    newnode2dcnopenempid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOpenEMService" | grep ${node2_maintenance_ip} | awk -F " "  '{print $7}' `
                fi
                if [[ ${node3_maintenance_ip} != "" ]];then
                    newnode3dcnoampid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOAMService" | grep ${node3_maintenance_ip} | awk -F " "  '{print $7}' `
                    newnode3dcnservicepid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNService" | grep ${node3_maintenance_ip} | awk -F " "  '{print $7}' `
                    newnode3dcnopenempid=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global -app "DCNOpenEMService" | grep ${node3_maintenance_ip} | awk -F " "  '{print $7}' `
                fi
                   
                if [[ ${newnode1dcnoampid} != ${node1dcnoampid} && ${newnode1dcnservicepid} != ${node1dcnservicepid} && ${newnode1dcnopenempid} != ${node1dcnopenempid} ]]
                then
                    if [[ ${node2_maintenance_ip} != "" ]]
                    then
                        if [[ ${newnode2dcnoampid} != ${node2dcnoampid} && ${newnode3dcnoampid} != ${node3dcnoampid}  && ${newnode2dcnservicepid} != ${node2dcnservicepid}  && ${newnode3dcnservicepid} != ${node3dcnservicepid}  && ${newnode2dcnopenempid} != ${node2dcnopenempid} && ${newnode3dcnopenempid} != ${node3dcnopenempid} ]]
                        then
                            echo "The ${node1_maintenance_ip} node oam old pid is ${node1dcnoampid}, new pid is ${newnode1dcnoampid} "
                            echo "The ${node1_maintenance_ip} node dcnservice old pid is ${node1dcnservicepid}, new pid is ${newnode1dcnservicepid} "
                            echo "The ${node1_maintenance_ip} node dcnoenem old pid is ${node1dcnopenempid}, new pid is ${newnode1dcnopenempid} "
                            echo "The ${node2_maintenance_ip} node oam old pid is ${node2dcnoampid}, new pid is ${newnode2dcnoampid} "
                            echo "The ${node2_maintenance_ip} node dcnservice old pid is ${node2dcnservicepid}, new pid is ${newnode2dcnservicepid} "
                            echo "The ${node2_maintenance_ip} node dcnoenem old pid is ${node2dcnopenempid}, new pid is ${newnode2dcnopenempid} "
                            echo "The ${node3_maintenance_ip} node oam old pid is ${node3dcnoampid}, new pid is ${newnode3dcnoampid} "
                            echo "The ${node3_maintenance_ip} node dcnservice old pid is ${node3dcnservicepid}, new pid is ${newnode3dcnservicepid} "
                            echo "The ${node3_maintenance_ip} node dcnoenem old pid is ${node3dcnopenempid}, new pid is ${newnode3dcnopenempid} "
                            touch ${EXEC_HOME}/startportmirrorsuccessful.txt
                            echo "----------[SUCCESS] Install port mirror successful----------"
                            break                            
                        fi
                    else
                        echo "The ${node1_maintenance_ip} node oam old pid is ${node1dcnoampid}, new pid is ${newnode1dcnoampid} "
                        echo "The ${node1_maintenance_ip} node dcnservice old pid is ${node1dcnservicepid}, new pid is ${newnode1dcnservicepid} "
                        echo "The ${node1_maintenance_ip} node dcnoenem old pid is ${node1dcnopenempid}, new pid is ${newnode1dcnopenempid} "
                        touch ${EXEC_HOME}/startportmirrorsuccessful.txt
                        echo "----------[SUCCESS] Install port mirror successful----------"
                        break
                    fi
                fi
                if [ "${appstatus_count}" == 60 ]
                then
                    echo "10 minutes later, the port mirror service process is still not up.">&2
                    touch ${EXEC_HOME}/startportmirrorfailed.txt
                    exit 1
                fi   
                count=$(expr $appstatus_count + 1)
                echo "Apps starting, please wait."
                sleep 10s
            done
            if [[ -f ${EXEC_HOME}/startportmirrorsuccessful.txt ]]
            then
                rm -rf ${EXEC_HOME}/startportmirrorsuccessful.txt
                echo "Install port mirror Successful."
                exit 0
            else
                echo "Install port mirror failed."
                exit 1
            fi
        else
            echo "PortmirrorPlugin package is not exist."
            exit 1
        fi
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "do not need install port_mirror, skip."
        exit 0
    fi
}

main $@ >> ${log_file} 2>&1