#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
IPS=${4}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
temporary_path=${temporary_dir}/check_result

echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){
    # 检查数据库目录及NAE日志
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            [[ ! -d ${temporary_path} ]] && mkdir -p ${temporary_path}
            rm -rf ${temporary_path}/check_*.txt
            if [ -d "/opt/gauss/data" ]
            then
                sudo -u dbuser find /opt/gauss/data -maxdepth 1 -type f ! -name '.' > ${temporary_path}/check_gauss_data-${ip}.txt
                sudo -u dbuser find /opt/gauss/ ! -user dbuser > ${temporary_path}/check_gauss_dbuser-${ip}.txt
            fi
            if [ -d "/opt/zenith/data" ]
            then
                sudo -u dbuser find /opt/zenith/data -maxdepth 1 -type f ! -name '.' > ${temporary_path}/check_zenith_data-${ip}.txt
                sudo -u dbuser find /opt/zenith/ ! -user dbuser ! \( -path "*logicrep*" \) > ${temporary_path}/check_zenith_dbuser-${ip}.txt
            fi

            sudo -u ossuser rm -rf /opt/oss/log/*/NAEService/naeservice-*/tomcatlog/catalina.out
            find /opt/oss/log/*/NAEService/ -type f -size +1G > ${temporary_path}/check_nae_log-${ip}.txt
            
            # 规避管理面扫描包出现临时带uuid的非ossadm权限的文件，增加重试
            for((i=1;i<=5;i++))
            do
                find /opt/pub/software ! -user ossadm > ${temporary_path}/check_omp_file-${ip}.txt
                not_ossadm_file=`cat ${temporary_path}/check_omp_file-${ip}.txt | wc -l`
                if [[ \${not_ossadm_file} -gt 0 ]]
                then
                    sleep 10
                else
                   break
                fi
            done
      
            find /opt/oss/manager ! -user ossadm ! \( -path "*zenith*" -o -path "*mccommon*" -o -path "*cxx3rdlib*" \) >> ${temporary_path}/check_omp_file-${ip}.txt

            find /opt/oss/log/manager/*/ ! -user ossadm >> ${temporary_path}/check_omp_file-${ip}.txt

            find /opt/oss/rtsp ! -user ossadm >> ${temporary_path}/check_omp_file-${ip}.txt

            if [ -d "/opt/oss/backuptmp" ]
            then
                # \$符号前面有反斜杠，变量不会提前计算。否则EOF中的变量都会提前计算出来
                if [[ \$(stat -c %U:%G /opt/oss/backuptmp) != "ossadm:ossgroup" ]] || [[ \$(stat -c %a /opt/oss/backuptmp) != "750" ]]
                then
                    echo "/opt/oss/backuptmp \$(stat -c %U:%G /opt/oss/backuptmp) \$(stat -c %a /opt/oss/backuptmp)" >> ${temporary_path}/check_omp_file-${ip}.txt
                fi
            fi

            if [ -d "/opt/backuptmp" ]
            then
                if [[ \$(stat -c %U:%G /opt/backuptmp) != "root:root" ]]
                then
                    echo "/opt/backuptmp \$(stat -c %U:%G /opt/backuptmp)" > ${temporary_path}/check_root-${ip}.txt
                fi
                if [[ \$(stat -c %U:%G /opt) != "root:root" ]]
                then
                    echo "/opt" \$(stat -c %U:%G /opt) >> ${temporary_path}/check_root-${ip}.txt
                fi
            fi

            if [ $(stat -c %U:%G /root) != "root:root" ]
            then
                echo "/root $(stat -c %U:%G /root)" >> ${temporary_path}/check_root-${ip}.txt
            fi

            if [ $(stat -c %U:%G /tmp) != "root:root" ]
            then
                echo "/tmp $(stat -c %U:%G /root)" >> ${temporary_path}/check_root-${ip}.txt
            fi

            if [ $(stat -c %U:%G /home/ossadm/.ssh) != "ossadm:ossgroup" ] || [ $(stat -c %a /home/ossadm/.ssh) != "700" ]
            then
                echo "/home/ossadm/.ssh $(stat -c %U:%G /home/ossadm/.ssh) $(stat -c %a /home/ossadm/.ssh)" > ${temporary_path}/check_ossadm-${ip}.txt
            fi

            if  [ $(stat -c %U:%G /home/ossadm) != "ossadm:ossgroup" ] || [ $(stat -c %a /home/ossadm) != "750" ]
            then
                echo "/home/ossadm $(stat -c %U:%G /home/ossadm) $(stat -c %a /home/ossadm)" >> ${temporary_path}/check_ossadm-${ip}.txt
            fi
        exit
EOF
    done

}

main $@ >> ${log_file} 2>&1