#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
temporary_path=${temporary_dir}/check_result
echo ------------------------------------------------------------------------------------  >> ${log_file}
if [[ $(echo "$EXEC_HOME"  | grep -E "\s+") ]]
then
    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "The path contains spaces: ${EXEC_HOME}" >> ${log_file}
    exit 1
fi
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

[[ ! -d ${temporary_path} ]] && mkdir -p ${temporary_path}
result_name=${temporary_path}/check_db_sync_status.txt
if [[ -f ${temporary_path}/check_db_sync_status.txt ]]
then
    rm -rf ${result_name}
fi

function check_db_sync_status() {
    local db_type=${1}
    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type ${db_type} | grep DELAY >> ${result_name}
}

function main(){
    # 检查数据库同步状态，数据库同步状态异常或者延迟会导致数据库升级失败
    # 获取源版本和目标版本
    versions=$(sh ${EXEC_HOME}/../one_hop_post_upgrade/get_version.sh ${upgrade_path})
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo "get src_version or des_version successfully."
    else
        echo "get src_version or des_version failed."
        exit 1
    fi
    versions_array=(${versions//,/ })
    src_version=${versions_array[0]}
    des_version=${versions_array[1]}
    echo "src_version: ${src_version}, des_version: ${des_version}"

    if [[ ${src_version} == "R19C00" ]]
    then
        check_db_sync_status gauss
    elif [[ ${src_version} == "R19C10" ]]
    then
        check_db_sync_status gauss
        check_db_sync_status zenith
    else
        check_db_sync_status zenith
    fi


}

main >> ${log_file} 2>&1