#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
log_dir=`sh ${EXEC_HOME}/../get_log_dir.sh`
log_file=${log_dir}/${self_name}.log
IP=${1}
PORT=${2}
DB_NAME=${3}
PASSWORD=${4}
DB_TYPE=${5}
SQL_PATH=${6}
SQL_NAME=${7}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 日志也记录一份
    if [[ -f ${log_dir}/${SQL_NAME} ]]
    then
        rm -rf ${log_dir}/${SQL_NAME}
    fi
    cp -rf ${SQL_PATH} ${log_dir}/${SQL_NAME}

    if [[ ${DB_TYPE} == "zenith" ]]
    then
        sudo -s -u dbuser<<EOF
        source /home/dbuser/.bashrc
        /opt/zenith/app/bin/zsql ${DB_NAME}/${PASSWORD}@${IP}:${PORT} -f ${SQL_PATH}
EOF
    else
        sudo -s -u dbuser<<EOF
        source /home/dbuser/appgsdb.bashrc
        cd /home/dbuser/
        gsql -d ${DB_NAME} -p ${PORT} -U ossdbuser -h ${IP} -W ${PASSWORD}  < ${SQL_PATH}
EOF
    fi

}

main $@ >> ${log_file} 2>&1