#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
IPS=${4}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start delete_os_online_flag"
    IPS_array=(${IPS//,/ })
    for ip_port in ${IPS_array[@]}
    do
        ip_port_array=(${ip_port//:9094/ })
        ip=${ip_port_array[0]}
        ssh ossadm@${ip} << EOF
            [[ -d ${temporary_dir}/os_upgrade_online_result ]] && rm -rf ${temporary_dir}/os_upgrade_online_result
            [[ -d ${temporary_dir}/os_rollback_online_result ]] && rm -rf ${temporary_dir}/os_rollback_online_result
            rm -rf ${temporary_dir}/os_online_upgrade_result_*.txt
            rm -rf ${temporary_dir}/os_online_rollback_result_*.txt
        exit
EOF
    done
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "end delete_os_online_flag"
}

main $@ >> ${log_file} 2>&1