#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 备份service目录给容灾场景备站点同步脚本
    scripts_path="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online"
    if [ -d "/opt/upgrade/service" ]
    then
        rm -rf /opt/upgrade/service
    fi
    mkdir -p /opt/upgrade/service/scripts
    if [ -d ${scripts_path}/service ]
    then
        cp -r ${scripts_path}/service/extend /opt/upgrade/service
        cp -r ${scripts_path}/service/scripts/pyscripts /opt/upgrade/service/scripts
        cp -r ${scripts_path}/service/scripts/get_log_dir.sh /opt/upgrade/service/scripts
        cp -r ${scripts_path}/service/scripts/get_temporary_dir.sh /opt/upgrade/service/scripts
        if [[ -d ${scripts_path}/service/scripts/flag_dir ]]
        then
            cp -r ${scripts_path}/service/scripts/flag_dir /opt/upgrade/service/scripts
        fi
    fi
}

main $@ >> ${log_file} 2>&1