#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main(){

    repo_bak_dir=/opt/oss/upgrade_dir_for_ossuser/repo_bak
    HOFSOsdFileAgent=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "hofsosdfileagent-2-0" | awk '{print $6}')
    if [ "$HOFSOsdFileAgent" == "" ]
    then
        echo "backup repo package on the first node" >> ${log_file}
        sudo -u ossuser /opt/oss/*/apps/HOFSOsdFileAgent/bin/hfscmd update repo
        sudo -u ossuser rm -rf ${repo_bak_dir}
        sudo -u ossuser mkdir ${repo_bak_dir}
        if [[ -d /opt/backup/hfs/repo/repo/ ]]
        then
            echo "dir /opt/backup/hfs/repo/repo/ exists, start copy"
            sudo -u ossuser cp -rp /opt/backup/hfs/repo/repo/* ${repo_bak_dir}
        else
            echo "dir /opt/backup/hfs/repo/repo/ not exists, skip"
        fi
    else
        echo "backup repo package on the third node" >> ${log_file}
        ssh ossadm@"$HOFSOsdFileAgent" << remotessh
            sudo -u ossuser /opt/oss/*/apps/HOFSOsdFileAgent/bin/hfscmd update repo
            sudo -u ossuser rm -rf ${repo_bak_dir}
            sudo -u ossuser mkdir ${repo_bak_dir}
            if [[ -d /opt/backup/hfs/repo/repo/ ]]
            then
                echo "dir /opt/backup/hfs/repo/repo/ exists, start copy"
                sudo -u ossuser cp -rp /opt/backup/hfs/repo/repo/* ${repo_bak_dir}
            else
                echo "dir /opt/backup/hfs/repo/repo/ not exists, skip"
            fi
remotessh
    fi
}

main $@ >> ${log_file} 2>&1