#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    if [[ -f /opt/upgrade/app_names.txt ]]
    then
        rm -rf /opt/upgrade/app_names.txt
    fi

    app_names=`. /opt/oss/manager/bin/engr_profile.sh;ipmc_adm -cmd statusapp  | awk '(NR>1){print $3}'`
    src_version=$(. /opt/oss/manager/bin/engr_profile.sh;${PYTHONHOME}/bin/python -c "print('${upgrade_path}'.split('-')[0])")
    if [[ $(echo ${src_version} | grep "V300R019") ]] || [[ $(echo ${src_version} | grep "V100R019") ]]
        then
        HFS_service_name="HFSStorageService"
        # 判断是否包含HFSStorageService
        if [[ "$app_names" == *"$HFS_service_name"* ]]
            then
                app_names="$app_names HOFSService"
        fi
        if [[ "$app_names" == *"OMPubService"* ]]
            then
                app_names="$app_names OMPubServiceLogLicense"
        fi
        app_names="$app_names SnbCertMgmt"
        app_names="$app_names SnmpAgentNBService"
        if [[ $(echo ${src_version} | grep "V300R019C10") ]] || [[ $(echo ${src_version} | grep "V100R019C10") ]]
        then
            app_names="$app_names RepoMgrService"
        fi
    fi
    echo $app_names > /opt/upgrade/app_names.txt

}
main $@ >> ${log_file} 2>&1