#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main(){
    # 北向锁定
    . /opt/oss/manager/bin/engr_profile.sh
    export SSL_ROOT=/opt/oss/manager/etc/ssl
    ${PYTHONHOME}/bin/python ${EXEC_HOME}/../pyscripts/lock_north.py
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "Exec lock north successfully." >> ${log_file}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "Exec lock north failed." >> ${log_file}
        exit 1
    fi
}

main $@ >> ${log_file} 2>&1