#!/bin/bash

EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
operate=${4}
temporary_dir=$(sh ${EXEC_HOME}/../get_temporary_dir.sh)
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}


function main()
{
    # 删除zenith软件目录下的sql文件
    if [ "${operate}" == "stop" ];then
        sudo -u dbuser rm -rf /opt/zenith/app/sql/initdb_customized.sql
    fi

    . /opt/oss/manager/bin/engr_profile.sh
    # 停止全部业务实例的系统定制任务
    for instance_name_ip in $(sudo -u dbuser ls /opt/zenith/data)
    do
    	instance_name_array=(${instance_name_ip//-/ })
    	instance_name=${instance_name_array[0]}
    	echo ${instance_name} >> ${log_file}
    	if [ ${instance_name} == "managedbsvr" ]
    	then
    		continue
    	fi

        retry_times=8
        sleep_time=60
        MACHINE_IP=""
        port=""
        adminPP=""
        for((i=1;i<=${retry_times};i++))
        do
            has_instance=$(/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance | grep -iE ${instance_name})
            if [[ -z ${has_instance} ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "instance_name ${instance_name} dose not exists, retry_times: ${i}"
                sleep ${sleep_time}
                continue
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "instance_name ${instance_name} exists"
            fi

            #获取数据库ip,port
            cd ${EXEC_HOME}/../pyscripts/utils/
            ip_port_info=$(${PYTHONHOME}/bin/python -c "import common_method;_ip, port, _=common_method.CommonMethod().get_db_ip_and_port('${instance_name}', 'zenith');print('%s,%s' % (_ip, port))")
    	    ip_port_result_code=$?
            if [[ "${ip_port_result_code}" == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get ip_port_info successfully."
                result_array_ip_port=(${ip_port_info//,/ })
                MACHINE_IP=${result_array_ip_port[0]}
                port=${result_array_ip_port[1]}
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get ip_port_info failed."
                MACHINE_IP=""
                port=""
            fi

            cd ${EXEC_HOME}
    	    db_info=$(${PYTHONHOME}/bin/python -c "import sys;sys.path.append('${EXEC_HOME}/../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main_sys('${instance_name}', 'zenith'))" 2>&1)
            db_info_result=$?
            if [[ "${db_info_result}" == "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
                result_array=(${db_info//,/ })
                adminPP=${result_array[1]}
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
                adminPP=""
            fi

            if [[ -z ${MACHINE_IP} ]] || [[ -z ${port} ]] || [[ -z ${adminPP} ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "ip or port or adminPP is empty, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                   echo echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "${operate}_db_sys_task failed."
                   exit 1
                fi
                sleep ${sleep_time}
                continue
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get ip and port and adminPP success"
            fi

            # sys用户只能在主数据库所在的节点登录，需要先将sql文件scp到主节点，再ssh过去执行sql文件
            ssh -o StrictHostKeyChecking=no ossadm@${MACHINE_IP} << EOF
            [[ -f ${temporary_dir}/${operate}_db_sys_task.sql ]] && rm -rf ${temporary_dir}/${operate}_db_sys_task.sql
            [[ ! -d ${temporary_dir} ]] && mkdir -p ${temporary_dir}
            exit
EOF
            scp ${EXEC_HOME}/${operate}_db_sys_task.sql ossadm@[$MACHINE_IP]:${temporary_dir}
            if [[ $? != "0" ]]
            then
                echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "scp file is failed, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                   echo echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${operate}_db_sys_task failed."
                   exit 1
                fi
                sleep ${sleep_time}
                continue
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "scp file is success"
            fi

            ssh -o StrictHostKeyChecking=no ossadm@${MACHINE_IP} sudo -s -u dbuser<<EOF
            source /home/dbuser/.bashrc
            /opt/zenith/app/bin/zsql sys/${adminPP}@${MACHINE_IP}:${port} -f ${temporary_dir}/${operate}_db_sys_task.sql
EOF
            result=$?
            if [[ "${result}" == "0" ]]
            then
                echo "${operate}_db_sys_task successfully."
                break
            else
                echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${operate}_db_sys_task, retry_times: ${i}"
                if [[ ${i} -eq ${retry_times} ]]
                then
                   echo echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "${operate}_db_sys_task failed."
                   exit 1
                fi
                sleep ${sleep_time}
                continue
            fi
        done
    done
}

main $@ >> ${log_file} 2>&1
