#!/bin/bash
EXEC_HOME=$(cd "$(dirname "$0")"; pwd)
self_name="${0##*/}"
upgrade_path=${1}
tenant_name=${2}
log_file=${3}
echo ------------------------------------------------------------------------------------  >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "start execute [${self_name}]" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "log_file name is ${log_file}" >> ${log_file}
echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "params is $@" >> ${log_file}

function main()
{
    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant ${tenant_name}|grep gauss |grep Master|awk '{print $3 "\t" $6}' > ${EXEC_HOME}/../gaussinsts_master.txt
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "store gauss information master successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "store gauss information master failed."
        exit 1
    fi

    /opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -tenant ${tenant_name}|grep gauss |grep Slave|awk '{print $3 "\t" $6}' > ${EXEC_HOME}/../gaussinsts_slave.txt
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "store gauss information slave successfully."
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "store gauss information slave failed."
        exit 1
    fi
}
main $@ >> ${log_file} 2>&1