#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
script_name=`basename $0`
temporary_dir=$(sh ${CURRENT_PATH}/../../get_temporary_dir.sh)

basesm=`/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep -w "SecoManagerService"`
if [ "${basesm}X" = "X" ]; then
    echo "secomanager is not installed, skip convert aaa id."
    echo 0 > $CURRENT_PATH/post_upgrade_secomanagerservice.result
    exit 0
fi

print_log()
{
    local content=$*
    log_filename="$CURRENT_PATH/update_nw.log"
    echo $log_filename
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi


}

instance_name=dcnnwcommondb
#运行函数：获取数据库ip,port, admin password
get_dbip_port $instance_name

export MIGRATE_DATA_DIR=/opt/oss/tmp_data
AAA_ID_CONVERT_SQL_FILE="${temporary_dir}/secomanagerservice_aaa_id_convert"

if [ -f "$AAA_ID_CONVERT_SQL_FILE" ]; then
    rm -rf $AAA_ID_CONVERT_SQL_FILE*
    echo "clean $AAA_ID_CONVERT_SQL_FILE before convert_aaa_id."
fi
if [ -f "$CURRENT_PATH/post_upgrade_secomanagerservice.result" ]; then
    rm -rf $CURRENT_PATH/post_upgrade_secomanagerservice.result
    echo "clean post_upgrade_secomanagerservice.result before convert_aaa_id."
fi
echo "the row number of the file user_id_map is: `wc -l $MIGRATE_DATA_DIR/share/id_map/user_id_map.properties`"

OLD_IFS="$IFS"
while read line
do
    IFS="="
    arr=($line)
    old_id=${arr[0]}
    new_id=${arr[1]}
    # 表1：tenant and user relation table
    echo "update TAB_SECM_USER_TENANT_RELATION set user_id = '$new_id' where user_id = '$old_id';" >> $AAA_ID_CONVERT_SQL_FILE
    # 表2：show column config table
    echo "update TAB_SECM_COMMON_COLUMNCONFIG_DATA set user_id = '$new_id' where user_id = '$old_id';" >> $AAA_ID_CONVERT_SQL_FILE
    # 表3：firewall security policy table
    echo "update TAB_SECM_SECURITY_POLICY set create_user_id = '$new_id' where create_user_id = '$old_id';" >> $AAA_ID_CONVERT_SQL_FILE
    echo "update TAB_SECM_SECURITY_POLICY set update_user_id = '$new_id' where update_user_id = '$old_id';" >> $AAA_ID_CONVERT_SQL_FILE
    # 表4：comprehensive audit task table
    echo "update TAB_SECM_AUDIT_TASK set create_user_id = '$new_id' where create_user_id = '$old_id';" >> $AAA_ID_CONVERT_SQL_FILE
done < $MIGRATE_DATA_DIR/share/id_map/user_id_map.properties
IFS="$OLD_IFS"

if [ -f $CURRENT_PATH/../../pyscripts/get_zenith_db_info.py ]
then
    get_dbinfo_script=$CURRENT_PATH/../../pyscripts/get_zenith_db_info.py
else
    get_dbinfo_script=$CURRENT_PATH/../../pyscripts/get_zenith_db_info.pyc
fi

echo "[`date`] secomanagerservice convert_aaa_id start ..."

# get_db_info
db_info_str=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CURRENT_PATH}/../../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('dcnnwcommondb', 'secmpersistentdb', 'zenith'))" 2>&1`
result=$?
if [[ "${result}" == "0" ]]
then
    echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
    result_array=(${db_info_str//,/ })
    adminPP=${result_array[2]}
else
    echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
    exit 1
fi

split -l 500 $AAA_ID_CONVERT_SQL_FILE $AAA_ID_CONVERT_SQL_FILE -d
rm -rf $AAA_ID_CONVERT_SQL_FILE

for file in $(ls ${AAA_ID_CONVERT_SQL_FILE}*);do
    sudo -s -u dbuser<<EOF
    source /home/dbuser/.bashrc
    /opt/zenith/app/bin/zsql secmpersistentdb/${adminPP}@${MACHINE_IP}:${port} -f $file
EOF
done

echo "[`date`] secomanager custom sql start..."
sudo -s -u dbuser<<EOF
source /home/dbuser/.bashrc
/opt/zenith/app/bin/zsql secmpersistentdb/${adminPP}@${MACHINE_IP}:${port} -f $CURRENT_PATH/custom_db.sql
EOF
echo "[`date`] secomanager custom sql end."

echo "[`date`] secomanagerservice convert_aaa_id successful."
echo 0 > $CURRENT_PATH/post_upgrade_secomanagerservice.result
