#!/bin/bash

CUR_PATH=$(cd "$(dirname "$0")"; pwd)
script_name=`basename $0`

print_log()
{
    local content=$*
    log_filename="$CUR_PATH/update_faultservice.log"
    echo $log_filename 
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "Log: $CURTIME $$ $script_name : $content" | tee -a $log_filename
}

#获取数据库信息（query database)
get_dbip_port() {
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Master`

    if [ -z "$dbinfo" ]
    then
        print_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
        db_type=`echo $dbinfo|awk '{print $9}'`
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E "$1"|grep Slave|awk '{print $3}'`
        db_type=`echo $dbinfo|awk '{print $9}'`
    fi

    
}

#获取get_db_pass.py, 如果成功找到，放在exec_file变量里面

main(){

    service_name=FaultService
    instance_name=dcnnwcommondb
    instance_db_name="dcnfaultpersistentdb"
    #查询是否存在微服务器
    if [ `/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep $service_name | wc -l` -le 0 ]
    then
      print_log "$LINENO $instance_db_name "$service_name"does not exist"
      exit 0
    fi
    #运行函数：获取数据库ip,port, admin password
    get_dbip_port $instance_name
    # get_db_info
    db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${instance_name}', '${instance_db_name}', 'zenith'))" 2>&1`
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
        result_array=(${db_info//,/ })
        adminPP=${result_array[2]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
        exit 1
    fi

    if [ -z "$adminPP" ]
    then
        print_log "$LINENO $instance_db_name acquire DB passwd failed,exit"
        exit 1
    else
        print_log "$LINENO $instance_db_name acquire DB passwd success "
    fi
    sql_result=`sudo -s -u dbuser<<EOF
    source /home/dbuser/.bashrc
    /opt/zenith/app/bin/zsql ${instance_db_name}/${adminPP}@${MACHINE_IP}:${port} -f $CUR_PATH/fetch_data.sql
EOF`
    str='0 rows fetched'
    if [[ $sql_result =~ $str ]]
    then
        echo "dcnfaultpersistentdb does not have values"
        exit 0
    else
        systemId=`echo $sql_result | sed -E 's/.*id_(.{1,})_id.*/\1/'`
        systemName=`echo $sql_result | sed -r 's/.*systemName_(.{1,})_systemName.*/\1/'`
        userName=`echo $sql_result | sed -r 's/.*userName_(.{1,})_userName.*/\1/'`
        userPwd=`echo $sql_result | sed -r 's/.*userPwd_(.{1,})_userPwd.*/\1/'`
        ip=`echo $sql_result | sed -r 's/.*ip_(.{1,})_ip.*/\1/'`
        port=`echo $sql_result | sed -r 's/.*port_(.{1,})_port.*/\1/'`
        uiPort=`echo $sql_result | sed -r 's/.*uiPort_(.{1,})_uiPort.*/\1/'`
        description=`echo $sql_result | sed -r 's/.*desc_(.{0,})_desc.*/\1/'`
        . /opt/oss/manager/agent/bin/engr_profile.sh; python $CUR_PATH/send_ir.py $systemId $systemName $userName $userPwd $ip $port $uiPort "$description"
        result=$?
        if [[ "${result}" == "0" ]]
        then
            echo "send_ir.py successfully."
            exit 0
        else
            echo "send_ir.py failed."
            exit 1
        fi
    fi
}
main
