--3.3.10.100.090_BEGIN
--3.3.10.100.090_END

--3.3.10.300.015_BEGIN

create table if not exists tab_dcn_oam_l2_sub_if_status
(
	id nvarchar2(64) not null,
	logic_switch_id nvarchar2(64),
	logic_port_id nvarchar2(256),
	logic_port_name nvarchar2(256),
	device_id nvarchar2(64),
	device_ip nvarchar2(256),
	device_name nvarchar2(256),
	if_name nvarchar2(256),
	status int,
	constraint pk_dcn_oam_l2_sub_if_status primary key (id)
);
alter table tab_dcn_oam_l2_sub_if_status owner to ossdbuser;
--3.3.10.300.015_END

--3.3.10.300.029_BEGIN

create table if not exists  tab_dcn_oam_path_detector_device_status
(
	id                nvarchar2(64)     primary key not null,
	device_ip         nvarchar2(64),
	device_name       nvarchar2(255),
	ipv4_status       nvarchar2(64),
    ipv6_status       nvarchar2(64),
    ipv4_dscp         INTEGER,
    ipv6_dscp         INTEGER
);
ALTER TABLE public.tab_dcn_oam_path_detector_device_status OWNER TO ossdbuser;


create table if not exists  tab_dcn_oam_alarm_acl
(
	id                nvarchar2(64)     not null,
	service_id         nvarchar2(64)    not null,
	service_type          nvarchar2(32)    ,
	service_name          nvarchar2(32)    ,
	apply_type           nvarchar2(32)     ,
    interface_name           nvarchar2(32)     ,
    policy_name           nvarchar2(64)     ,
    direction           nvarchar2(32)     ,
    timestamp           timestamp default current_timestamp     ,
    fail_reason           nvarchar2(128)     ,
	constraint tab_dcn_oam_alarm_acl_key primary key (id)
);
alter table  tab_dcn_oam_alarm_acl OWNER TO ossdbuser;

--3.3.10.300.029_END

--3.3.10.300.030_BEGIN

create table if not exists TAB_DCN_OAM_INTERFACE_SAMPLING
(
  id nvarchar2(64) primary key not null,
  device_ip nvarchar2(128),
  device_id nvarchar2(128),
  interface_name nvarchar2(128)
);
ALTER TABLE public.TAB_DCN_OAM_INTERFACE_SAMPLING OWNER TO ossdbuser;

--3.3.10.300.030_END

--3.3.10.300.036_BEGIN
update tab_dcn_oam_emergency_plan_atom_template set template_name = 'Hrp switch', description = 'Hrp switch' where id = '00000000-1111-0000-0000-000000000001';
update tab_dcn_oam_emergency_plan_atom_template set template_name = 'Switch Reboot', description = 'Switch Reboot' where id = '00000000-1111-0000-0000-000000000002';
update tab_dcn_oam_emergency_plan_atom_template set template_name = 'Port shutdown', description = 'Port shutdown' where id = '00000000-1111-0000-0000-000000000003';
update tab_dcn_oam_emergency_plan_compound_template set template_name = 'Hrp switch', description = 'Hrp switch' where id = '00000000-2222-0000-0000-000000000001';
update tab_dcn_oam_emergency_plan_compound_template set template_name = 'Switch Reboot', description = 'Switch Reboot' where id = '00000000-2222-0000-0000-000000000002';
update tab_dcn_oam_emergency_plan_compound_template set template_name = 'Port shutdown', description = 'Port shutdown' where id = '00000000-2222-0000-0000-000000000003';
update tab_dcn_oam_emergency_plan_template_relation set atom_template_name = 'Hrp switch' where id = '00000000-2222-0000-2222-000000000001';
update tab_dcn_oam_emergency_plan_template_relation set atom_template_name = 'Switch Reboot' where id = '00000000-2222-0000-2222-000000000002';
update tab_dcn_oam_emergency_plan_template_relation set atom_template_name = 'Port shutdown' where id = '00000000-2222-0000-2222-000000000003';
--3.3.10.300.036_END

--3.19.0.0.025_BEGIN

create table if not exists tab_dcn_app_quick_privilege
(
  user_id UUID primary key,
  user_name varchar(255),
  role varchar(255),
  app_privilege jsonb,
  quick_privilege jsonb
);
alter table tab_dcn_app_quick_privilege OWNER TO ossdbuser;

--3.19.0.0.025_END

--3.19.0.0.050_BEGIN

create table if not exists tab_dcn_oam_acl_number
(
	id                nvarchar2(64)     not null,
    device_ip nvarchar2(128),
    device_id nvarchar2(128),
    acl_number integer,
    rule_feature nvarchar2(1024),
    rule_name nvarchar2(256),
	create_time timestamp with time zone,
	update_time timestamp with time zone,
    constraint tab_dcn_oam_acl_number_key primary key (id)
);
alter table  tab_dcn_oam_acl_number OWNER TO ossdbuser;

create table if not exists tab_dcn_oam_traffic_analyse_host
(
	id                nvarchar2(64)     not null,
    device_ip nvarchar2(128),
    device_id nvarchar2(128),
    protocol_type nvarchar2(128),
    family_type nvarchar2(128),
    ip nvarchar2(256),
	port integer,
	vrf_name nvarchar2(256),
	create_time timestamp with time zone,
	update_time timestamp with time zone,
    constraint tab_dcn_oam_traffic_analyse_host_key primary key (id)
);
alter table  tab_dcn_oam_traffic_analyse_host OWNER TO ossdbuser;
--3.19.0.0.050_END

--3.19.0.0.100_BEGIN
select alter_columns('ADD', 'tab_dcn_topo_escape_link', 'link_type', 'integer');
update tab_dcn_topo_escape_link set link_type = 5 where link_type is null;
--3.19.0.0.100_END

--3.19.0.0.137_BEGIN
select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'access_type', 'nvarchar2(32) null');
select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'dst_access_type', 'nvarchar2(32) null');
select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'src_inner_vlan', 'integer null');
select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'dst_inner_vlan', 'integer null');
select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'src_outer_vlan', 'integer null');
select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'dst_outer_vlan', 'integer null');

select alter_columns('ADD', 'tab_dcn_oam_detection_path_task', 'access_type', 'nvarchar2(32) null');
select alter_columns('ADD', 'tab_dcn_oam_detection_path_task', 'dst_access_type', 'nvarchar2(32) null');
select alter_columns('ADD', 'tab_dcn_oam_detection_path_task', 'src_inner_vlan', 'integer null');
select alter_columns('ADD', 'tab_dcn_oam_detection_path_task', 'dst_inner_vlan', 'integer null');
select alter_columns('ADD', 'tab_dcn_oam_detection_path_task', 'src_outer_vlan', 'integer null');
select alter_columns('ADD', 'tab_dcn_oam_detection_path_task', 'dst_outer_vlan', 'integer null');

update tab_dcn_oam_detection_path_task set access_type = 2 where detect_type='SINGLE' and src_vlan>0;
update tab_dcn_oam_detection_path_task set access_type = 1 where detect_type='SINGLE'and src_vlan<=0;

update tab_dcn_oam_detection_path_task set dst_access_type = 2 where detect_type='SINGLE' and dst_vlan>0;
update tab_dcn_oam_detection_path_task set dst_access_type = 1 where detect_type='SINGLE'and dst_vlan<=0;

update tab_dcn_oam_detection_path_task set DST_ACCESS_TYPE = 4 where detect_type='SINGLE' and DST_ACCESS_TYPE=0;


update tab_dcn_oam_detection_path_task set access_type = 2 where detect_type='SINGLE' and src_vlan>0;
update tab_dcn_oam_detection_path_task set access_type = 1 where detect_type='SINGLE'and src_vlan<=0;

update tab_dcn_oam_detection_path_task set dst_access_type = 2 where detect_type='SINGLE' and dst_vlan>0;
update tab_dcn_oam_detection_path_task set dst_access_type = 1 where detect_type='SINGLE'and dst_vlan<=0;

update tab_dcn_oam_detection_path_task set DST_ACCESS_TYPE = 4 where detect_type='SINGLE' and DST_ACCESS_TYPE=0;
--3.19.0.0.137_END

--3.19.0.100.030_BEGIN
create table if not exists tab_dcn_oam_l3vni_status
(
	id                nvarchar2(64)     not null,
	device_ip         nvarchar2(128)    not null,
	vni              integer,
	dest_vtep_ips     varchar(128)[],
	status           nvarchar2(32)     not null,
	constraint pk_dcn_oam_l3vni_status primary key (id)
);
alter table tab_dcn_oam_l3vni_status owner to ossdbuser;
drop index if exists idx_dcn_oam_l3vni_status_device_ip;
create index idx_dcn_oam_l3vni_status_device_ip on tab_dcn_oam_l3vni_status (device_ip);


create table if not exists tab_dcn_oam_dci_status
(
	id                nvarchar2(64)     not null,
	device_ip         nvarchar2(128)    not null,
	src_vtep          nvarchar2(128)    not null,
	dst_vtep          nvarchar2(128)    not null,
	vni              integer,
	type             nvarchar2(32)     not null,
	status           nvarchar2(32)     not null,
	constraint pk_dcn_oam_dci_status primary key (id)
);
alter table tab_dcn_oam_dci_status owner to ossdbuser;
drop index if exists idx_dcn_oam_dci_status_ip_dstvtep;
create index idx_dcn_oam_dci_status_ip_dstvtep on tab_dcn_oam_dci_status (device_ip, dst_vtep);

select alter_columns('ADD', 'tab_dcn_oam_single_path_detection_sub_task', 'is_connection', 'bool null');
--3.19.0.100.030_END

--3.19.0.100.035_BEGIN
select alter_columns('ADD', 'tab_dcn_oam_service_vmmirror_device', 'acl_name', 'nvarchar2(128)');
select alter_columns('ADD', 'tab_dcn_oam_service_vmmirror_device', 'mqc_name', 'nvarchar2(128)');
update tab_dcn_oam_service_vmmirror_device set acl_name = 'ac_mirror'||MIRROR_PORT||OBSERVE_PORT where acl_name is null;
update tab_dcn_oam_service_vmmirror_device set mqc_name = ''||OBSERVE_INDEX||'-'||MIRROR_PORT||OBSERVE_PORT where mqc_name is null;
--3.19.0.100.035_END

--3.19.0.100.122_BEGIN
create table if not exists tab_dcn_oam_topn_usage
(
  id nvarchar2(64) primary key not null,
  fabric_id nvarchar2(128) not null,
  device_id nvarchar2(128) not null,
  device_ip nvarchar2(128),
  device_name nvarchar2(128) not null,
  resource_vnibdevpn decimal(64,4),
  resource_vrf decimal(64,4),
  resource_static_route decimal(64,4),
  resource_arp decimal(64,4),
  resource_fibv4 decimal(64,4),
  create_time  timestamp default current_timestamp
);
alter table tab_dcn_oam_topn_usage OWNER TO ossdbuser;
drop index if exists idx_dcn_oam_topn_usage_device_id;
create index idx_dcn_oam_topn_usage_device_id on tab_dcn_oam_topn_usage(device_id);
--3.19.0.100.122_END

--3.19.0.100.132_BEGIN
update tab_dcn_oam_feature_config set FEATURE_ID = UPPER(FEATURE_ID);
--3.19.0.100.132_END

--3.19.0.100.151_BEGIN
create table if not exists tab_dcn_oam_topn_usage
(
  id nvarchar2(64) primary key not null,
  fabric_id nvarchar2(128) not null,
  device_id nvarchar2(128) not null,
  device_ip nvarchar2(128),
  device_name nvarchar2(128) not null,
  resource_vnibdevpn decimal(64,4),
  resource_vrf decimal(64,4),
  resource_static_route decimal(64,4),
  resource_arp decimal(64,4),
  resource_fibv4 decimal(64,4),
  create_time  timestamp default current_timestamp
);
alter table tab_dcn_oam_topn_usage OWNER TO ossdbuser;
drop index if exists idx_dcn_oam_topn_usage_device_id;
create index idx_dcn_oam_topn_usage_device_id on tab_dcn_oam_topn_usage(device_id);

select alter_columns('ADD', 'tab_dcn_oam_service_vmmirror', 'if_index', 'bigint');
select alter_columns('add','tab_dcn_app_quick_privilege','extend_privilege','jsonb');

 create table if not exists tab_dcn_oam_device_isolation_effect
 (
 id nvarchar2(64) primary key not null,
 local_device_id  nvarchar2(64) not null,
 local_device_name nvarchar2(128) not null,
 local_device_port nvarchar2(64) not null,
 peer_device_id  nvarchar2(64) not null,
 peer_device_name nvarchar2(128) not null,
 peer_device_port nvarchar2(64) not null,
 isolation_status boolean default false
 );
 alter table tab_dcn_oam_device_isolation_effect owner TO ossdbuser;
--3.19.0.100.151_END
 
--3.19.10.0.108000_BEGIN
  delete from tab_dcn_oam_emergency_plan_action where id between '00000000-1111-0000-1111-000000000004' and '00000000-1111-0000-1111-000000000030';
  delete from tab_dcn_oam_emergency_plan_atom_template where id between '00000000-1111-0000-0000-000000000004' and '00000000-1111-0000-0000-000000000019';
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000004', 'LpuBoard PowerOff', 'LpuBoard PowerOff', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000005', 'SingleBoardReset', 'SingleBoardReset', 'DeviceTemplate', 'false');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000006', 'BgpPeerIgnore', 'BgpPeerIgnore', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000007', 'ResetArp', 'ResetArp', 'DeviceTemplate', 'false');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000008', 'FibStatus', 'FibStatus', 'DeviceTemplate', 'false');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000009', 'RestartInterface', 'RestartInterface', 'DeviceTemplate', 'false');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000011', 'VmIpIsolation', 'VmIpIsolation', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000012', 'IsolateDevice', 'IsolateDevice', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000013', 'VmIpv6Isolation', 'VmIpv6Isolation', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000014', 'HandleSynFloodAttack', 'HandleSynFloodAttack', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000015', 'HandleArpAttack', 'HandleArpAttack', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000016', 'HandleNdAttack', 'HandleNdAttack', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000017', 'FaultServicePortShutdown', 'FaultServicePortShutdown', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000018', 'OspfRouterIdReset', 'OspfRouterIdReset', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_atom_template(id, template_name, description, template_type, enable_revert) values ('00000000-1111-0000-0000-000000000019', 'OspfInterfaceIpReset', 'OspfInterfaceIpReset', 'DeviceTemplate', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000009', '00000000-1111-0000-0000-000000000007', 'ResetArp','false','false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000010', '00000000-1111-0000-0000-000000000008', 'FibStatus','false','false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000004', '00000000-1111-0000-0000-000000000004', 'LpuBoardPowerOff', 'true', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000005', '00000000-1111-0000-0000-000000000004', 'LpuBoardPowerOn', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000006', '00000000-1111-0000-0000-000000000005', 'SingleBoardReset', 'false', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000007', '00000000-1111-0000-0000-000000000006', 'BgpPeerIgnore', 'true', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000008', '00000000-1111-0000-0000-000000000006', 'UndoBgpPeerIgnore', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000011', '00000000-1111-0000-0000-000000000009', 'RestartInterface', 'false', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000013', '00000000-1111-0000-0000-000000000011', 'VmIpIsolation', 'true', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000014', '00000000-1111-0000-0000-000000000011', 'UndoVmIpIsolation', 'false', 'true');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000015', '00000000-1111-0000-0000-000000000012', 'IsolateDevice', 'true', 'false');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000016', '00000000-1111-0000-0000-000000000012', 'UndoIsolateDevice', 'false', 'true');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000017', '00000000-1111-0000-0000-000000000013', 'VmIpv6Isolation', 'true', 'false');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000018', '00000000-1111-0000-0000-000000000013', 'UndoVmIpv6Isolation', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000019', '00000000-1111-0000-0000-000000000014', 'HandleSynFloodAttack', 'true', 'false');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000020', '00000000-1111-0000-0000-000000000014', 'UndoHandleSynFloodAttack', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000021', '00000000-1111-0000-0000-000000000015', 'HandleArpAttack', 'true', 'false');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000022', '00000000-1111-0000-0000-000000000015', 'UndoHandleArpAttack', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000023', '00000000-1111-0000-0000-000000000016', 'HandleNdAttack', 'true', 'false');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000024', '00000000-1111-0000-0000-000000000016', 'UndoHandleNdAttack', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000025', '00000000-1111-0000-0000-000000000017', 'FaultServicePortShutdown', 'true', 'false');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000026', '00000000-1111-0000-0000-000000000017', 'UndoFaultServicePortShutdown', 'false', 'true');
	insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000027', '00000000-1111-0000-0000-000000000018', 'OspfRouterIdReset', 'true', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000028', '00000000-1111-0000-0000-000000000018', 'UndoOspfRouterIdReset', 'false', 'true');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000029', '00000000-1111-0000-0000-000000000019', 'OspfInterfaceIpReset', 'true', 'false');
  insert into tab_dcn_oam_emergency_plan_action(id, template_id, action_name, enable_revert, revert_action) values ('00000000-1111-0000-1111-000000000030', '00000000-1111-0000-0000-000000000019', 'UndoOspfInterfaceIpReset', 'false', 'true');
--3.19.10.0.108000_END

--3.19.10.0.109000_BEGIN
 create table if not exists tab_dcn_oam_emergency_handle_attack_history
 (
 id nvarchar2(64) primary key not null,
 issue_id  nvarchar2(64) not null,
 device_id  nvarchar2(64) not null,
 if_name nvarchar2(64) not null,
 direction nvarchar2(64) not null,
 policy_name  nvarchar2(64) not null,
 behavior_name  nvarchar2(64) not null,
 classifier_name nvarchar2(64) not null,
 acl_name nvarchar2(64),
 acl_family nvarchar2(64),
 acl_rule_name  nvarchar2(64),
 src_ip nvarchar2(64),
 arp_acl_name nvarchar2(64),
 arp_acl_family nvarchar2(64),
 arp_acl_rule_name nvarchar2(64),
 arp_src_ip nvarchar2(64),
 arp_mac nvarchar2(64),
 ipv6_acl_name nvarchar2(64),
 ipv6_acl_rule_name nvarchar2(64),
 ipv6_src_ip nvarchar2(256),
 ipv6_acl_icmp_type nvarchar2(16),
 undo boolean default true,
 is_ac_port boolean
 );
 alter table tab_dcn_oam_emergency_handle_attack_history owner TO ossdbuser;

 create table if not exists tab_dcn_oam_fault_shutdown_port
 (
 id nvarchar2(64) primary key not null,
 issue_id  nvarchar2(64) not null,
 device_id  nvarchar2(64) not null,
 if_name nvarchar2(64) not null
 );
 alter table tab_dcn_oam_fault_shutdown_port owner TO ossdbuser;

create table if not exists tab_dcn_oam_emergency_device_isolation_history
(
id nvarchar2(64) primary key not null,
device_id  nvarchar2(64) not null,
isolated boolean
);
alter table tab_dcn_oam_emergency_device_isolation_history owner TO ossdbuser;

alter table tab_dcn_oam_emergency_plan_execute_history modify (obj_name text);
--3.19.10.0.109000_END
 
--3.19.10.200.1220_BEGIN
select alter_columns('ADD', 'tab_dcn_app_quick_privilege', 'extend_privilege', 'jsonb');
--3.19.10.200.1220_END

--3.19.10.200.1270_BEGIN
create table if not exists tab_dcn_oam_back_up_task
(
       id character varying(36) not null,
       back_up_time character varying(255),
       back_up_interval character varying(50),
       be_updated boolean not null,
       task_timer_node_ip character varying(255),
       keep_alive_time character varying(255),
       week_day character varying(50)
);
alter table tab_dcn_oam_back_up_task OWNER TO ossdbuser;
--3.19.10.200.1270_END
 
--3.19.10.200.1310_BEGIN
select alter_columns('RENAME', 'tab_dcn_oam_service_vmmirror', 'if_index','ifindex');
select alter_columns('RENAME', 'tab_dcn_oam_service_vmmirror', 'remote_ip','remote_ips');
select alter_columns_to_str_array('tab_dcn_oam_service_vmmirror', 'remote_ips', 'character varying(128)[]');
--3.19.10.200.1310_END

--3.19.10.200.1620_BEGIN
select alter_columns('ADD', 'tab_dcn_oam_service_vmmirror', 'MIRROR_TYPE', 'INTEGER');
--3.19.10.200.1620_END

--3.19.10.200.1830_BEGIN
select alter_columns('ALTER', 'tab_dcn_oam_service_vmmirror', 'HOST_IP','NVARCHAR2(256)');
select alter_columns('ALTER', 'tab_dcn_oam_service_vmmirror', 'VM_IP','NVARCHAR2(256)');
--3.19.10.200.1830_END

--3.19.10.201.0090_BEGIN
alter table tab_dcn_oam_feature_config modify (config text);
--3.19.10.201.0090_END