--3.19.10.0.002_BEGIN
select alter_columns('ADD', 'tab_dcn_logic_switch','nd_l2_proxy_gw_enable','boolean');
select alter_columns('ADD', 'tab_dcn_gbp_dhcp_group', 'create_time', 'timestamp default current_timestamp');
select alter_columns('ADD', 'tab_dcn_gbp_logic_link', 'create_time', 'timestamp default current_timestamp');
select alter_columns('ADD', 'tab_dcn_external_gateway', 'create_time', 'timestamp default current_timestamp');
select alter_columns('ADD', 'tab_dcn_external_network', 'create_time', 'timestamp default current_timestamp');
select alter_columns('ADD', 'tab_dcn_svo_logic_interface', 'sub_interface_index', 'varchar(128)');
--3.19.10.0.002_END

--3.19.10.0.021_BEGIN
update tab_dcn_svo_spec_param set value = 4000 where CODE='ROUTER_SUBNET_SIZE';
update tab_dcn_svo_spec_param set value = 4000000 where CODE='MAX_LOGICPORT_NUM';

create or replace function func_upgrade_max_endport returns integer as $body$
declare
    v_num_max_endport int:=0;
begin

EXECUTE IMMEDIATE 'select count(1) from tab_dcn_svo_spec_param where CODE=''MAX_ENDPORT_NUM'' ' into v_num_max_endport;

if v_num_max_endport=0 then
    insert into tab_dcn_svo_spec_param values ('MAX_ENDPORT_NUM', 4000000);
else
    update tab_dcn_svo_spec_param set value = 4000000 where CODE='MAX_ENDPORT_NUM';
end if;
return 0;
end;$body$ language plpgsql;
/
ALTER FUNCTION func_upgrade_max_endport() OWNER TO OSSDBUSER;
select func_upgrade_max_endport();
drop function if exists func_upgrade_max_endport();

SELECT alter_columns('ALTER', 'TAB_DCN_GBP_BGP_CONFIG', 'IMPORT_NETWORK', 'CHARACTER VARYING(4096)');
SELECT alter_columns('ALTER', 'TAB_DCN_GBP_BGP_CONFIG', 'AGGREGATE_ROUTE', 'CHARACTER VARYING(4096)');
--3.19.10.0.021_END

--3.19.10.0.023_BEGIN
select alter_columns('add','tab_dcn_tenant','login_account','CHARACTER VARYING(255)');
--3.19.10.0.023_END

--3.19.10.0.050_BEGIN
select alter_columns('ADD', 'tab_dcn_svo_track_nqa','ip_version','character varying(36)');
--3.19.10.0.050_END

--3.19.10.0.055_BEGIN
delete from tab_dcn_svo_spec_param where CODE = 'ROUTER_EXT_GATEWAY_NUM';
insert into tab_dcn_svo_spec_param values ('ROUTER_EXT_GATEWAY_NUM', 64);
delete from tab_dcn_svo_spec_param where CODE = 'EXT_GATEWAY_ROUTER_NUM';
insert into tab_dcn_svo_spec_param values ('EXT_GATEWAY_ROUTER_NUM', 4000);
--3.19.10.0.055_END

--3.19.10.0.057_BEGIN
CREATE table if not exists tab_dcn_svo_dynamic_end_port(
    id varchar(36),
    name character varying(512) not null,
	description character varying(512),
	network_id varchar(36) not null,
	tenant_id varchar(36) not null,
	vlan integer,
	mac varchar(50),
	access_mode integer,
	ip_address character varying(255),
	producer integer,
	logic_switch_id varchar(36),
	vm_name character varying(255),
	create_time timestamp default CURRENT_TIMESTAMP,
	device_id varchar(36),
	device_port_name character varying(255),
	sub_interface_index integer,
	constraint pk_tab_dcn_svo_dynamic_end_port  primary key (id)
);
alter table tab_dcn_svo_dynamic_end_port OWNER TO ossdbuser;
drop index if exists idx_tab_dcn_svo_dynamic_end_port_deviceid;
create index idx_tab_dcn_svo_dynamic_end_port_deviceid on tab_dcn_svo_dynamic_end_port using btree(device_id);
--3.19.10.0.057_END

--3.19.10.0.060_BEGIN
create table if not exists tab_dcn_svo_multicast_msdp_retry_interval
(
  id character varying(36) not null,
  logic_router_id character varying(36)  not null,
  device_id character varying(36) not null,
  retry_interval integer,
  msdp_id character varying(36) not null,
  constraint pk_tab_dcn_svo_multicast_msdp_retry_interval primary key (id)
);
alter table tab_dcn_svo_multicast_msdp_retry_interval OWNER TO ossdbuser;

CREATE OR REPLACE FUNCTION func_upgrade_msdp_retry_interval() RETURNS INTEGER AS $body$
BEGIN
 DBMS_OUTPUT.PUT_LINE('begin to func_upgrade_msdp_retry_interval');
 FOR msdp IN select id, logic_router_id,peer_ip,in_line,outbound_interface_id,outbound_interface_type,retry_interval,holdtime_interval,keep_alive_interval,auth_type,pwd_type,pwd,vpc_id,tenant_id,producer from tab_dcn_svo_multicast_msdp LOOP
  if msdp.in_line is false then
   if exists(select 1 from tab_dcn_svo_multicast_msdp_source_ip source_ip where source_ip.msdp_id = msdp.id) then 
    for msdp_source_ip in select id,MSDP_ID,DEVICE_ID,LOOPBACK_IP,DEVICE_GROUP_ID,FABRIC_ID from tab_dcn_svo_multicast_msdp_source_ip source_ip where source_ip.msdp_id = msdp.id loop
     insert into tab_dcn_svo_multicast_msdp_retry_interval
      (ID, logic_router_id, device_id, retry_interval,msdp_id)
     values
      (randUuid()::UUID, msdp.logic_router_id, msdp_source_ip.device_id, msdp.retry_interval,msdp.id);
    end loop;
   end if;
  end if;
  
  if msdp.in_line is true and msdp.outbound_interface_type = 'LogicInterface' then
   if exists ( select 1 from tab_dcn_svo_interface_deviceport where logic_interface_id = msdp.outbound_interface_id::UUID) then
    for connect_interface in select id,fabric_id,device_group_id, device_id,port_name,logic_interface_id from tab_dcn_svo_interface_deviceport where logic_interface_id = msdp.outbound_interface_id::UUID loop
     insert into tab_dcn_svo_multicast_msdp_retry_interval
      (ID, logic_router_id, device_id, retry_interval,msdp_id)
     values
      (randUuid()::UUID , msdp.logic_router_id, connect_interface.device_id, msdp.retry_interval,msdp.id);
    end loop;
   end if;
  end if;
  
  if msdp.in_line is true and msdp.outbound_interface_type = 'ExternalNetwork' then
   if exists ( select 1 from tab_dcn_external_network ext_net where ext_net.id = msdp.outbound_interface_id::UUID) then
    for external_network in select id,name,network_type,description,externalgateway_id,app_id,tenant_id,public_router_id,staticroute_ids,bgp_ids,producer,read_only,is_deployed,is_centralized,is_share_vrf from tab_dcn_external_network ext_net where ext_net.id = msdp.outbound_interface_id::UUID loop
     if exists ( select 1 from tab_dcn_svo_logic_interface lg_int where lg_int.logic_router_id = external_network.externalGateway_id and lg_int.associate_type = 'External') then
      for logic_interface in select id from tab_dcn_svo_logic_interface lg_int where lg_int.logic_router_id = external_network.externalGateway_id and lg_int.associate_type = 'External' loop
       if exists (select 1 from tab_dcn_svo_connect_interface_deploy int_dep where int_dep.logic_interface_id = logic_interface.id::varchar) then 
         for interface_deploy in select logic_interface_id from tab_dcn_svo_connect_interface_deploy int_dep where int_dep.logic_interface_id = logic_interface.id::varchar loop 
          if exists ( select 1 from tab_dcn_svo_interface_deviceport int_dev where int_dev.logic_interface_id = interface_deploy.logic_interface_id::UUID) then
			for interface_deviceport in select id,fabric_id,device_group_id, device_id,port_name,logic_interface_id from tab_dcn_svo_interface_deviceport int_dev where int_dev.logic_interface_id = interface_deploy.logic_interface_id::UUID loop
			 insert into tab_dcn_svo_multicast_msdp_retry_interval
			  (ID, logic_router_id, device_id, retry_interval,msdp_id)
			 values
			  (randUuid()::UUID , msdp.logic_router_id, interface_deviceport.device_id, msdp.retry_interval,msdp.id);
            end loop;
          end if;
         end loop;
        end if;
       end loop;
     end if;
   end loop;
  end if;
 end if;
end loop;
RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION func_upgrade_msdp_retry_interval() OWNER TO ossdbuser;
select func_upgrade_msdp_retry_interval();
drop function if exists func_upgrade_msdp_retry_interval;
--3.19.10.0.060_END

--3.19.10.0.101100_BEGIN
CREATE OR REPLACE FUNCTION update_route_priority_config() RETURNS INTEGER AS $body$
	DECLARE
        record_switch tab_dcn_logic_switch%ROWTYPE;
		record_router_switch_link tab_dcn_gbp_logic_link%ROWTYPE;
		record_router_extnet_link tab_dcn_gbp_logic_link%ROWTYPE;
        v_switch_id varchar;
		v_router_id varchar;
		v_extnet_id varchar;
        v_switch_extnet_id varchar;
		b_has_60 boolean;
		b_has_120 boolean;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to update_route_priority_config');
		b_has_60 = false;
		b_has_120 = false;
        FOR record_switch in select PK_DCN_ID from tab_dcn_logic_switch LOOP
			v_switch_id = record_switch.pk_dcn_id;
			FOR record_router_switch_link in select id,type,local_id,peer_id from tab_dcn_gbp_logic_link where peer_id = v_switch_id and type = 2 LOOP
				v_router_id = record_router_switch_link.local_id;
				FOR record_router_extnet_link in select id,type,local_id,peer_id from tab_dcn_gbp_logic_link where local_id = v_router_id and type = 1 LOOP
					v_extnet_id = record_router_extnet_link.peer_id;
					v_switch_extnet_id = v_switch_id || v_extnet_id;
					DBMS_OUTPUT.PUT_LINE('switch extnet id'|| v_switch_extnet_id);
					if exists ( select 1 from tab_dcn_gbp_routes_config where route_id = v_switch_extnet_id and priority = 60 ) then
						b_has_60 = true;
					end if;
					if exists ( select 1 from tab_dcn_gbp_routes_config where route_id = v_switch_extnet_id and priority = 120 ) then
						b_has_120 = true;
					end if;
				end loop;
			end loop;
        end loop;
		if b_has_60 = true and b_has_120 = false then
			DBMS_OUTPUT.PUT_LINE('all back routes priority is 60');
			update tab_dcn_svo_spec_param set value = 60 where code = 'EXTGW_SYSTEM_DEFAULT_PRIORITY';
		end if;
		if b_has_60 = false and b_has_120 = true then
			DBMS_OUTPUT.PUT_LINE('all back routes priority is 120');
			update tab_dcn_svo_spec_param set value = 120 where code = 'EXTGW_SYSTEM_DEFAULT_PRIORITY';
		end if;
 RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION update_route_priority_config() OWNER TO OSSDBUSER;
select update_route_priority_config();
drop function if exists update_route_priority_config;
--3.19.10.0.101100_END

--3.19.10.0.103000_BEGIN
create table if not exists tab_dcn_svo_dynamic_awareness
(
  id character varying(128) not null,
  fabric_id character varying(128),  
  interval integer,  
  enable integer,
  constraint pk_tab_dcn_svo_dynamic_awareness primary key (id)
);
alter table tab_dcn_svo_dynamic_awareness OWNER TO ossdbuser;

create table if not exists tab_dcn_svo_device_detect_time
(
  id character varying(128) not null,
  fabric_id character varying(128),
  device_id character varying(128),
  device_name character varying(256),
  enable integer,
  detect_time integer,
  constraint pk_tab_dcn_svo_device_detect_time primary key (id)
);
alter table tab_dcn_svo_device_detect_time OWNER TO ossdbuser;
--3.19.10.0.103000_END

--3.19.10.0.121000_BEGIN
create table if not exists tab_dcn_svo_host_cluster  (
 
   id nvarchar2(128) not null,
   name nvarchar2(255),
   fabric_id nvarchar2(36),
   producer nvarchar2(36),
   create_time timestamp default current_timestamp,
   update_time timestamp with time zone,
   constraint pk_dcn_svo_host_cluster  primary key (id)
);
alter table tab_dcn_svo_host_cluster OWNER TO ossdbuser;
create table if not exists tab_dcn_svo_host_cluster_member  (
 
   id nvarchar2(128) not null,
   host_cluster_id nvarchar2(128),
   device_id nvarchar2(128),
   device_name nvarchar2(255),
   device_port_id nvarchar2(128),
   device_port_name nvarchar2(255),
   create_time timestamp default current_timestamp,
   update_time timestamp with time zone,
   constraint pk_dcn_svo_host_cluster_member primary key (id)
);
alter table tab_dcn_svo_host_cluster_member OWNER TO ossdbuser;
create table if not exists tab_dcn_logic_port_pre_config  (
 
   id nvarchar2(128) not null,
   host_cluster_id nvarchar2(128)  not null,
   logic_switch_id nvarchar2(36)  not null,
   vlan integer,
   producer nvarchar2(36),
   constraint pk_dcn_logic_port_pre_config primary key (id)
);
alter table tab_dcn_logic_port_pre_config OWNER TO ossdbuser;
select alter_columns('add','tab_dcn_logic_port','vmm_pre_config','boolean');
select alter_columns('add','tab_dcn_svo_host_cluster','fabric_id','nvarchar2(36)');
--3.19.10.0.121000_END

--3.19.10.0.150000_BEGIN
CREATE OR REPLACE FUNCTION reset_route_config_track_type() RETURNS INTEGER AS $body$
    begin
        DBMS_OUTPUT.PUT_LINE('begin to reset_route_config_track_type');
        if exists (select 1 from tab_dcn_gbp_routes_config where trim(end_port_id) is not null) then
            FOR route_config in select id,route_id,end_port_track_name from tab_dcn_gbp_routes_config where trim(end_port_id) is not null LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal end port route.route id:'|| route_config.route_id);
				if trim(route_config.end_port_track_name) is not null then 
					update tab_dcn_gbp_routes_config set track_type = 'AutoTrack' where id = route_config.id;
				else
					update tab_dcn_gbp_routes_config set track_type = 'None' where id = route_config.id;
				end if;

            END LOOP;
        end if;
 RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION reset_route_config_track_type() OWNER TO ossdbuser;
select reset_route_config_track_type();
drop function if exists reset_route_config_track_type;
--3.19.10.0.150000_END

--3.19.10.0.151000_BEGIN
SELECT alter_columns('ALTER', 'tab_dcn_gbp_logic_link', 'id', 'CHARACTER VARYING(128)');
SELECT alter_columns('ALTER', 'tab_dcn_gbp_deploy_port', 'LOGIC_LINK_ID', 'CHARACTER VARYING(128)');
delete from tab_dcn_svo_spec_param where CODE = 'EXTGW_DES_STR_MAX_LENGTH';
insert into tab_dcn_svo_spec_param values ('EXTGW_DES_STR_MAX_LENGTH', 242);
--3.19.10.0.151000_END

--3.19.10.0.153000_BEGIN
CREATE OR REPLACE FUNCTION release_vrf_name_resource() RETURNS INTEGER AS $body$
	DECLARE
         vrf_name_pool_id varchar := 'logic-router-name';
         vrf_name_url varchar := 'id:logic-router-name/type:0/VniId';
    begin
        DBMS_OUTPUT.PUT_LINE('begin to release_vrf_name_resource');
		if exists (select 1 from tab_dcn_day0_resource_base where VNI_TYPE=vrf_name_pool_id) then 
			DBMS_OUTPUT.PUT_LINE('exist vrf_name_pool in day0 resource');
			delete from tab_dcn_day0_resource_base where VNI_TYPE=vrf_name_pool_id;
		end if;
		
		if exists (select 1 from tab_bp_resourcepool_block_consumer  where url=vrf_name_url) then 
			DBMS_OUTPUT.PUT_LINE('exist vrf_name_resource in resourcepool_block_consumer');
			delete from tab_bp_resourcepool_block_consumer where url=vrf_name_url;
		end if;		
		
		if exists (select 1 from tab_bp_resourcepool_block  where url=vrf_name_url) then 
			DBMS_OUTPUT.PUT_LINE('exist vrf_name_resource in resourcepool_block');
			delete from tab_bp_resourcepool_block where url=vrf_name_url;
		end if;
 RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION release_vrf_name_resource() OWNER TO OSSDBUSER;
select release_vrf_name_resource();
drop function if exists release_vrf_name_resource;
--3.19.10.0.153000_END

--3.19.10.0.156000_BEGIN
delete from tab_dcn_svo_spec_param where CODE = 'EXTGW_FABRIC_BIND_GATEWAY_MAX';
insert into tab_dcn_svo_spec_param values ('EXTGW_FABRIC_BIND_GATEWAY_MAX', 1000);
delete from tab_dcn_svo_spec_param where CODE = 'MAX_EXT_GW_NUM';
insert into tab_dcn_svo_spec_param values ('MAX_EXT_GW_NUM', 2000);
--3.19.10.0.156000_END

--3.19.10.0.161000_BEGIN
select alter_columns('add','tab_dcn_logic_port_pre_config','egress_vlan','integer');

--3.19.10.0.161000_END

--3.19.10.0.163000_BEGIN
CREATE OR REPLACE FUNCTION fabric_dis_router_mode_same(fabric_ids CHARACTER VARYING[]) RETURNS boolean  AS $fabric_dis_router_mode_same$
	DECLARE
		v_dis_router_mode_same BOOLEAN;
    begin
		EXECUTE IMMEDIATE 'select count(distinct dis_logic_router_mode)=1 from tab_dcn_fabric_resm_basicinfo where id in ('''||array_to_string(fabric_ids,''',''')||''')' into v_dis_router_mode_same ; 
		DBMS_OUTPUT.PUT_LINE('the fabric:'|| array_to_string(fabric_ids,',')||' dis router mode is same:'||v_dis_router_mode_same);
		return v_dis_router_mode_same;
    end;
$fabric_dis_router_mode_same$ language plpgsql;
ALTER FUNCTION fabric_dis_router_mode_same(fabric_ids CHARACTER VARYING[]) OWNER TO OSSDBUSER; 

CREATE OR REPLACE FUNCTION fabric_micro_segment_same(fabric_ids CHARACTER VARYING[]) RETURNS boolean  AS $fabric_micro_segment_same$
	DECLARE
		v_micro_segment_same BOOLEAN;
    begin
		EXECUTE IMMEDIATE ' select count(distinct (case when micro_segment is null then false else micro_segment end))=1 from tab_dcn_fabric_resm_basicinfo where id in ('''||array_to_string(fabric_ids,''',''')||''')' into v_micro_segment_same ; 
		DBMS_OUTPUT.PUT_LINE('the fabric:'|| array_to_string(fabric_ids,',')||' micro segment is same:'||v_micro_segment_same);
		return v_micro_segment_same;
    end;
$fabric_micro_segment_same$ language plpgsql;
ALTER FUNCTION fabric_micro_segment_same(fabric_ids CHARACTER VARYING[]) OWNER TO OSSDBUSER; 

CREATE OR REPLACE FUNCTION update_cloud_platform_fabric() RETURNS INTEGER AS $body$
	begin
			DBMS_OUTPUT.PUT_LINE('begin to update_cloud_platform_fabric.');
			if exists (select 1 from tab_dcn_neutron_clouds ) then
				FOR cloud in  select name,fabric_id from tab_dcn_neutron_clouds where fabric_id is not null LOOP
					DBMS_OUTPUT.PUT_LINE('begin to update_cloud_platform_fabric.cloud_name:'||cloud.name);
					if fabric_dis_router_mode_same(cloud.fabric_id)	and fabric_micro_segment_same(cloud.fabric_id) then
						DBMS_OUTPUT.PUT_LINE('begin to tab_dcn_logic_network.cloud_name:'||cloud.name||',fabric_id:'||array_to_string(cloud.fabric_id,';'));
						update tab_dcn_logic_network set fabric_id = array_to_string(cloud.fabric_id,';') where cloud_name=cloud.name and trim(fabric_id) is null;
					end if;
				END LOOP;
			end if;
			RETURN 0;
	END;
$body$ language plpgsql;
ALTER FUNCTION update_cloud_platform_fabric() OWNER TO OSSDBUSER;
select update_cloud_platform_fabric();
drop function if exists update_cloud_platform_fabric;
drop function if exists fabric_dis_router_mode_same;
drop function if exists fabric_micro_segment_same;
--3.19.10.0.163000_END

--3.19.10.0.166000_BEGIN
create table if not exists tab_dcn_port_bind_vlan(
  id nvarchar2(36) not null,
  host_id nvarchar2(255),
  network_id nvarchar2(255),
  dev_port nvarchar2(255),
  dev_id nvarchar2(255),
  vlan integer,
  endport_id nvarchar2(72),
  host_type integer default 0,
  constraint pk_tab_dcn_port_bind_vlan primary key (id)
);
alter table tab_dcn_port_bind_vlan OWNER TO ossdbuser;
drop index if exists  idx_dcn_port_bind_vlan;
create index idx_dcn_port_bind_vlan on tab_dcn_bindport using btree (dev_port, vlan);
--3.19.10.0.166000_END

--3.19.10.100.006000_BEGIN
select alter_columns('ADD', 'tab_dcn_svo_end_port', 'init_logic_port_id', 'character varying(128)');
update tab_dcn_svo_end_port ep set init_logic_port_id=(select local_id from tab_dcn_gbp_logic_link where peer_id=ep.id)  where _type=1;
	
create table if not exists tab_dcn_end_port_migrate_port
(
  id character varying(36) not null,
  end_port_id character varying(128),
  host_id character varying(128),
  logic_port_id character varying(128),
  constraint pk_tab_dcn_end_port_migrate_port primary key (id)
);
alter table tab_dcn_end_port_migrate_port OWNER TO ossdbuser;

CREATE OR REPLACE FUNCTION migrate_end_port_next_port_to_mirate_port_table() RETURNS INTEGER AS $body$
	DECLARE
        lp_device_info tab_dcn_logic_port_device_info%ROWTYPE;
        next_logic_port tab_dcn_logic_port%ROWTYPE;
        v_device_model varchar;
        v_bind_dev_port_id varchar;
        v_host varchar;
        v_cur_link_lp_id varchar;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to migrate_end_port_next_port_to_mirate_port_table');
        FOR end_port in select id,next_logic_port_id,migrating_host_id,logic_switch_id,access_type,host_id from tab_dcn_svo_end_port where  trim(next_logic_port_id) is not null and trim(migrating_host_id) is not null LOOP
			if exists (select 1 from tab_dcn_logic_port_device_info where logic_port_id = end_port.next_logic_port_id) and exists (select 1 from tab_dcn_logic_port where pk_dcn_id= end_port.next_logic_port_id) then
				DBMS_OUTPUT.PUT_LINE('need migrate endPort:'||end_port.id);
				EXECUTE IMMEDIATE  'select id,logic_port_id,device_group_id,device_id,device_port_id,device_port_name from tab_dcn_logic_port_device_info where logic_port_id = '''||end_port.next_logic_port_id ||''' limit 1' into lp_device_info;
				EXECUTE IMMEDIATE 'select DEVICETYPE from DEVICEDESCRIPTIONENTITY where id ='''||lp_device_info.device_id||'''' into v_device_model;
				v_bind_dev_port_id =lp_device_info.device_port_id;
				if (v_device_model = 'VSWITCH') or (v_device_model = 'VDHCP') then
					DBMS_OUTPUT.PUT_LINE('the device:'||lp_device_info.device_id || ' is ovs.change v_bind_dev_port_id.');
					v_bind_dev_port_id = end_port.logic_switch_id;
				end if;
				if(end_port.access_type=3) then
					--qinq����vlan��Ϣδ¼��bindport����
					DBMS_OUTPUT.PUT_LINE('the device1232');
					insert into tab_dcn_end_port_migrate_port (id,end_port_id,host_id,logic_port_id) values (randUuid(),end_port.id,end_port.migrating_host_id,end_port.next_logic_port_id);
					select local_id from tab_dcn_gbp_logic_link where peer_id=end_port.id into v_cur_link_lp_id;
					insert into tab_dcn_end_port_migrate_port (id,end_port_id,host_id,logic_port_id) values (randUuid(),end_port.id,end_port.host_id,v_cur_link_lp_id);
					update tab_dcn_svo_end_port set next_logic_port_id = null where id =end_port.id;

				else
					select vlan_id from tab_dcn_logic_port where pk_dcn_id= end_port.next_logic_port_id into next_logic_port;
					if not exists(select 1 from tab_dcn_bindport where dev_id=lp_device_info.device_id  and dev_port =v_bind_dev_port_id and network_id::varchar= end_port.logic_switch_id and vlan=next_logic_port.vlan_id and trim(host_id) is not null) then
						continue;
					end if;
					select host_id from tab_dcn_bindport where dev_id=lp_device_info.device_id  and dev_port =v_bind_dev_port_id and network_id::varchar= end_port.logic_switch_id and vlan=next_logic_port.vlan_id and trim(host_id) is not null into v_host; 
					insert into tab_dcn_end_port_migrate_port (id,end_port_id,host_id,logic_port_id) values (randUuid(),end_port.id,v_host,end_port.next_logic_port_id);
					select local_id from tab_dcn_gbp_logic_link where peer_id=end_port.id into v_cur_link_lp_id;
					insert into tab_dcn_end_port_migrate_port (id,end_port_id,host_id,logic_port_id) values (randUuid(),end_port.id,end_port.host_id,v_cur_link_lp_id);
					update tab_dcn_svo_end_port set next_logic_port_id = null where id =end_port.id;
				end if;
			end if;
		         
        end loop;
 RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION migrate_end_port_next_port_to_mirate_port_table() OWNER TO OSSDBUSER;
select migrate_end_port_next_port_to_mirate_port_table();
drop function if exists migrate_end_port_next_port_to_mirate_port_table;
--3.19.10.100.006000_END

--3.19.10.100.016000_BEGIN
DROP FUNCTION IF EXISTS insert_subpools;
CREATE OR REPLACE FUNCTION insert_subpools(url_in text,begin_in bigint,end_in bigint, step_in integer,curr_time bigint) RETURNS boolean as $$
	declare
	i bigint:=begin_in;
	j bigint:=0;
	step bigint:=0;
	sql_str text;
	begin
	while i <= end_in 
	loop 
		if step_in <= (end_in-i) then
		begin
			step:=step_in;
		end;
		else
		begin
			step:=end_in-i+1;
		end;
		end if;
		sql_str:='insert into tab_wan_sub_resource_pool (id,url,value,state,ts) values ';
		j:=i;
		while j <= (i+step-1)
		loop
			sql_str:=sql_str||'('''||url_in||'_'||j||''','''||url_in||''','||j||',0,'||curr_time||'),';
			j:=j+1;
		end loop;
		sql_str:=substring(sql_str from 1 for char_length(sql_str)-1);
		sql_str:=sql_str||';';
		execute sql_str;
		i:=i+step;
	end loop;
	return true;
	end;
$$ language plpgsql strict;
ALTER FUNCTION insert_subpools(text,bigint,bigint,integer,bigint)
 OWNER TO ossdbuser;

CREATE OR REPLACE FUNCTION update_ovs_vlan_device_port_id_to_network_id() RETURNS INTEGER AS $body$
	DECLARE
        v_old_res_url varchar;
        v_new_res_url varchar;
        v_device_model varchar;
		v_step integer:=50;
		v_current NUMERIC;
		v_old_res_urls varchar[] := ARRAY[]::varchar[];
    begin
        DBMS_OUTPUT.PUT_LINE('begin to update_ovs_vlan_device_port_id_to_network_id');
		-- tab_dcn_bindport l2l3 vlanռ�ñ�
		FOR bind_port in select id,host_id,network_id,dev_port,dev_id,vlan,host_type from tab_dcn_bindport where dev_id=dev_port LOOP
			DBMS_OUTPUT.PUT_LINE('begin to deal bind_port:'||bind_port);
			-- �ж��Ƿ���OVS����
			if not exists (select 1 from DEVICEDESCRIPTIONENTITY where id =bind_port.dev_id) then 
				DBMS_OUTPUT.PUT_LINE('device:'||bind_port.dev_id || ' not exist.');
				continue;
			end if;
			EXECUTE IMMEDIATE 'select DEVICETYPE from DEVICEDESCRIPTIONENTITY where id ='''||bind_port.dev_id||'''' into v_device_model;
			if (v_device_model <> 'VSWITCH') and (v_device_model <> 'VDHCP') then
				DBMS_OUTPUT.PUT_LINE('device:'||bind_port.dev_id || ' is not ovs.');
				continue;
			end if;
			if exists (select 1 from tab_dcn_bindport where network_id=bind_port.network_id and DEV_ID=bind_port.dev_id and dev_port = bind_port.network_id::varchar and vlan = bind_port.vlan) then
				DBMS_OUTPUT.PUT_LINE('the bind vlan has exists.');
				continue;
			end if;
			update tab_dcn_bindport set dev_port= bind_port.network_id::varchar where id =bind_port.id;
			-- tab_dcn_port_bind_vlan  l2l3 vlanռ�ñ� 5gc�޴˱�
			update tab_dcn_port_bind_vlan set dev_port= bind_port.network_id::varchar where network_id=bind_port.network_id::varchar and DEV_ID=bind_port.dev_id and dev_port = bind_port.dev_port and vlan = bind_port.vlan;
			-- tab_dcn_day0_resource_instance ȫ��vlanʵ����
			if not exists (select 1 from  tab_dcn_day0_resource_instance where device_id::varchar =bind_port.dev_id and port_id::varchar =bind_port.network_id::varchar and RESOURCE_TYPE=1) then
				insert into tab_dcn_day0_resource_instance (id,resource_type,device_id,port_id,vrf_name) values (randUuid(), 1, bind_port.dev_id::UUID, bind_port.network_id, null);
			end if;
			delete from tab_dcn_day0_resource_instance where device_id::varchar =bind_port.dev_id and port_id::varchar =bind_port.dev_id and RESOURCE_TYPE=1;
			
			v_old_res_url = 'deviceid:'||bind_port.dev_id||'/id:'||bind_port.dev_port||'/type:0/VlanId';
			v_new_res_url = 'deviceid:'||bind_port.dev_id||'/id:'||bind_port.network_id::varchar||'/type:0/VlanId';
			DBMS_OUTPUT.PUT_LINE('v_old_res_url:'||v_old_res_url|| ' ,v_new_res_url:'||v_new_res_url);
			v_old_res_urls =array_append(v_old_res_urls,v_old_res_url);
			
			-- tab_wan_master_resource_pool vlan��Դ����
			if not exists (select 1 from tab_wan_master_resource_pool where url=v_new_res_url) then 
				insert into tab_wan_master_resource_pool (id,current,url,step,begin1,end1,threshold,recoverythreshold,alarmflag) values (randUuid(),0,v_new_res_url,0,0,0,90,50,false);
			end if;

		
			--tab_wan_segment_master_resource_pool vlan��Դ�ֶα�
			if not exists (select 1 from tab_wan_segment_master_resource_pool where url =v_old_res_url) then
				DBMS_OUTPUT.PUT_LINE('res_url:'||v_old_res_url|| ' not exist in tab_wan_segment_master_resource_pool.');
				continue;
			end if;
			FOR seg_ms_res_pool in select id,current,url,step,begin1,end1 from tab_wan_segment_master_resource_pool where url =v_old_res_url LOOP
				if not exists (select 1 from tab_wan_segment_master_resource_pool where url=v_new_res_url) then 
					v_current = seg_ms_res_pool.begin1 + v_step -1;
					if (v_current > seg_ms_res_pool.end1) then
						v_current= seg_ms_res_pool.end1;
					end if;
					DBMS_OUTPUT.PUT_LINE('seg_ms_res_pool.begin:'||seg_ms_res_pool.begin1||' ,seg_ms_res_pool.end:'||seg_ms_res_pool.end1);
					insert into tab_wan_segment_master_resource_pool (id,current,url,step,begin1,end1) 
					select randUuid(),
						   v_current,
						   v_new_res_url,
						   v_step,
						   seg_ms_res_pool.begin1,
						   seg_ms_res_pool.end1;
						-- tab_wan_sub_resource_pool vlan��Դ�ӱ�
					insert_subpools(v_new_res_url,seg_ms_res_pool.begin1,v_current,v_step,0);
				end if;
			END LOOP;
			--�˴����ܸ���v_old_res_urlɾ��tab_wan_segment_master_resource_pool������ͬnetwork����ͬdevId�ٲ�ѯʱ�鲻������
			
			--tab_wan_sub_value_consumer vlan��Դռ�ñ�
			if exists (select 1 from tab_wan_sub_value_consumer where url=v_old_res_url and value_num=bind_port.vlan and consumer='gbp-logic-port') then
				insert into tab_wan_sub_value_consumer (id,url,value_num,value_not_num,consumer,count,sub_poolid) values (randUuid(),v_new_res_url,bind_port.vlan,null,'gbp-logic-port',1,null);
				update tab_wan_sub_resource_pool set state= 1 where URL=v_new_res_url and value=bind_port.vlan;
			end if;

		END LOOP;
		
		--ɾ��ԭ����
		if(array_length(v_old_res_urls,1) >0 ) then
			FOREACH v_old_res_url IN ARRAY v_old_res_urls LOOP
				delete from tab_wan_master_resource_pool where url=v_old_res_url;
				delete from tab_wan_segment_master_resource_pool where url = v_old_res_url;
				delete from tab_wan_sub_resource_pool where url = v_old_res_url;
				delete from tab_wan_sub_value_consumer where url = v_old_res_url and CONSUMER='gbp-logic-port';
			END LOOP;
		end if;

 RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION update_ovs_vlan_device_port_id_to_network_id() OWNER TO ossdbuser;
select update_ovs_vlan_device_port_id_to_network_id();
drop function if exists update_ovs_vlan_device_port_id_to_network_id;
drop function if exists insert_subpools;

select alter_columns('alter','tab_dcn_logic_port','meta_data','text');
select alter_columns('alter','tab_dcn_svo_end_port','meta_data','text');
--3.19.10.100.016000_END

--3.19.10.200.0390_BEGIN
create table if not exists tab_dcn_svo_dci_route_policy
(
  id varchar(36),
  name character varying(512),
  policy_type character varying(36),
  config_id varchar(36),
  create_time timestamp default current_timestamp,
  update_time timestamp(0) without time zone,
  constraint pk_tab_dcn_svo_dci_route_policy primary key (id)
);
alter table tab_dcn_svo_dci_route_policy OWNER TO ossdbuser;

create table if not exists tab_dcn_svo_route_policy_config
(
  id varchar(36),
  name character varying(512),
  policy_type character varying(36),
  external_gateway_ids character varying[],
  create_time timestamp default current_timestamp,
  update_time timestamp(0) without time zone,
  constraint pk_tab_dcn_svo_route_policy_config primary key (id)
);
alter table tab_dcn_svo_route_policy_config OWNER TO ossdbuser;

create table if not exists tab_dcn_router_whitelist
(
  id uuid,
  router_id uuid,
  route_policy_ids character varying[], 
  routes character varying[],
  subnetIds character varying[],
  create_time timestamp default current_timestamp,
  productor varchar(24),
  constraint pk_tab_dcn_router_whitelist primary key (id)
);
alter table tab_dcn_router_whitelist OWNER TO ossdbuser;

select alter_columns('add','tab_dcn_gbp_bgp_config','route_policy_name','varchar(51)');
select alter_columns('add','tab_dcn_gbp_bgp_config','ebgp_peer_tag','boolean');

select alter_columns('add','tab_dcn_external_gateway','dynamic_mode','character varying(32)');
select alter_columns('add','tab_dcn_external_gateway','fabric_vpn_target','character varying(512)');

insert into tab_dcn_svo_spec_param values ('NFVI_ROUTE_POLICY_RELATED_EXT_GW_NUM', 4);
insert into tab_dcn_svo_spec_param values ('NFVI_ROUTE_POLICY_NUM', 100);

CREATE OR REPLACE FUNCTION migrate_fabric_nfvi_route_to_svo_route_policy_config() RETURNS INTEGER AS $body$
	DECLARE
		v_route_policy_config_id varchar;
		v_route_policy_id varchar;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to migrate_fabric_nfvi_route_to_svo_route_policy_config');
		
		FOR record_fabric_nfvi_rp in select id,best_effort_path_rtp,dci_export_rtp,dci_import_rtp,dci_dyeing_rtp from tab_dcn_fabric_service_nfvi_route_policy LOOP
			--����·������
			if trim(record_fabric_nfvi_rp.best_effort_path_rtp) is not null and not exists (select 1 from tab_dcn_svo_route_policy_config where policy_type='BestEffortPath') then
				if exists (select 1 from tab_dcn_fabric_service_route_policy where name =trim(record_fabric_nfvi_rp.best_effort_path_rtp)) then 
					select id from tab_dcn_fabric_service_route_policy where name =trim(record_fabric_nfvi_rp.best_effort_path_rtp) into v_route_policy_id;
					insert into tab_dcn_svo_route_policy (id,name,tenant_id) 
					select 
						fabri_route_policy.id id,
						trim(record_fabric_nfvi_rp.best_effort_path_rtp) name_p,
						'00000000-0000-0000-0000-000000000000' tenant_id
					from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.best_effort_path_rtp);
					insert into tab_dcn_svo_route_policy_config (id,name,policy_type) values (v_route_policy_id,trim(record_fabric_nfvi_rp.best_effort_path_rtp),'BestEffortPath');
				end if;
			end if;
			--DCI·�ɲ���
			if (trim(record_fabric_nfvi_rp.dci_export_rtp) is not null) or (trim(record_fabric_nfvi_rp.dci_import_rtp) is not null) or (trim(record_fabric_nfvi_rp.dci_dyeing_rtp) is not null) then
				v_route_policy_config_id= randUuid();
				if not exists (select 1 from tab_dcn_svo_route_policy_config where policy_type='Dci') then 
					insert into tab_dcn_svo_route_policy_config (id,name,policy_type) values (v_route_policy_config_id,'DefaultDCIRoutePolicy','Dci');
				end if;
				if trim(record_fabric_nfvi_rp.dci_export_rtp) is not null and not exists (select 1 from tab_dcn_svo_dci_route_policy where policy_type='DciExport') then
					select id from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.dci_export_rtp) into v_route_policy_id;
					if exists (select 1 from tab_dcn_fabric_service_route_policy where name =trim(record_fabric_nfvi_rp.dci_export_rtp)) then 
						insert into tab_dcn_svo_route_policy (id,name,tenant_id) 
						select 
							fabri_route_policy.id id,
							trim(record_fabric_nfvi_rp.dci_export_rtp) name_p,
							'00000000-0000-0000-0000-000000000000' tenant_id
						from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.dci_export_rtp);
					end if;
					insert into tab_dcn_svo_dci_route_policy (id,name,policy_type,config_id) values (v_route_policy_id,trim(record_fabric_nfvi_rp.dci_export_rtp),'DciExport',v_route_policy_config_id);
				end if;				
				if trim(record_fabric_nfvi_rp.dci_import_rtp) is not null and not exists (select 1 from tab_dcn_svo_dci_route_policy where policy_type='DciImport') then
					select id from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.dci_import_rtp) into v_route_policy_id;
					if exists (select 1 from tab_dcn_fabric_service_route_policy where name =trim(record_fabric_nfvi_rp.dci_import_rtp)) then 
						insert into tab_dcn_svo_route_policy (id,name,tenant_id) 
						select 
							fabri_route_policy.id id,
							trim(record_fabric_nfvi_rp.dci_import_rtp) name_p,
							'00000000-0000-0000-0000-000000000000' tenant_id
						from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.dci_import_rtp);
					end if;
					insert into tab_dcn_svo_dci_route_policy (id,name,policy_type,config_id) values (v_route_policy_id,trim(record_fabric_nfvi_rp.dci_import_rtp),'DciImport',v_route_policy_config_id);
				end if;	
				if trim(record_fabric_nfvi_rp.dci_dyeing_rtp) is not null and not exists (select 1 from tab_dcn_svo_dci_route_policy where policy_type='DciDyeing') then
					select id from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.dci_dyeing_rtp) into v_route_policy_id;
					if exists (select 1 from tab_dcn_fabric_service_route_policy where name =trim(record_fabric_nfvi_rp.dci_dyeing_rtp)) then 
						insert into tab_dcn_svo_route_policy (id,name,tenant_id) 
						select 
							fabri_route_policy.id id,
							trim(record_fabric_nfvi_rp.dci_dyeing_rtp) name_p,
							'00000000-0000-0000-0000-000000000000' tenant_id
						from tab_dcn_fabric_service_route_policy fabri_route_policy where name =trim(record_fabric_nfvi_rp.dci_dyeing_rtp);
					end if;
					insert into tab_dcn_svo_dci_route_policy (id,name,policy_type,config_id) values (v_route_policy_id,trim(record_fabric_nfvi_rp.dci_dyeing_rtp),'DciDyeing',v_route_policy_config_id);
				end if;
			end if;			
		END LOOP;
		
 RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION migrate_fabric_nfvi_route_to_svo_route_policy_config() OWNER TO ossdbuser;
select migrate_fabric_nfvi_route_to_svo_route_policy_config();
drop function if exists migrate_fabric_nfvi_route_to_svo_route_policy_config;
--3.19.10.200.0390_END

--3.19.10.200.1050_BEGIN
delete from tab_dcn_svo_spec_param where code ='EXTGW_CASCADE_UPDATE_ROUTER_LIMIT';
delete from tab_dcn_svo_spec_param where code ='SERVICE_IP_NUM_MAX_LIMIT';
insert into tab_dcn_svo_spec_param values ('EXTGW_CASCADE_UPDATE_ROUTER_LIMIT', 10);
insert into tab_dcn_svo_spec_param values ('SERVICE_IP_NUM_MAX_LIMIT', 256);
--3.19.10.200.1050_END

--3.19.10.200.1080_BEGIN
select alter_columns('add','tab_dcn_svo_route_policy_config','ip_version','character varying(36)');

CREATE OR REPLACE FUNCTION add_oam_link_ref_endport() RETURNS INTEGER AS $body$
DECLARE
IS_HARDWARE varchar2;
begin
        if exists (select 1 from tab_dcn_svo_end_port where trim(host_id) is not null and VNIC_TYPE <> 2) then
            FOR end_port in select id,host_id from tab_dcn_svo_end_port where trim(host_id) is not null and VNIC_TYPE <> 2 LOOP
                DBMS_OUTPUT.PUT_LINE('begin to deal end port  id:'|| end_port.id);
				
				FOR lp_device_info in select id,logic_port_id,device_group_id,device_id,device_port_id,device_port_name from tab_dcn_logic_port_device_info device where device.logic_port_id = (select logic_link.local_id from tab_dcn_gbp_logic_link logic_link  where logic_link.peer_id = end_port.id) LOOP
					DBMS_OUTPUT.PUT_LINE('begin to deal lp_device_info  id:'|| lp_device_info.id);
					
				if exists (select 1  from tab_dcn_fabric_resm_node fabric_device where id = lp_device_info.device_group_id) then
				  select fabric_device.IS_HARDWARE  from tab_dcn_fabric_resm_node fabric_device where id = lp_device_info.device_group_id into IS_HARDWARE;
					DBMS_OUTPUT.PUT_LINE('begin to:');
					if IS_HARDWARE <> '7' then		
						FOR  oam_link in select id,leftresourceid,leftltpid,leftltpname,rightresourceid,rightltpid,rightltpname from LinkEntity oam_link where RIGHTNODENAME = end_port.host_id and LINKTYPE = 'HOST' and LEFTRESOURCEID = lp_device_info.device_id and LEFTLTPID = lp_device_info.device_port_id LOOP
							bulk_upgrade_link_ref(oam_link.id,'endport-up-link_'||end_port.id,'l2l3app',oam_link.LEFTRESOURCEID,oam_link.LEFTLTPID,oam_link.LEFTLTPNAME ,oam_link.RIGHTRESOURCEID,oam_link.RIGHTLTPID ,oam_link.RIGHTLTPNAME);
						end loop;
					end if;
				end if;		
				END LOOP;	
            END LOOP;
        end if;
		
		 RETURN 0;
END;
$body$ language plpgsql;
ALTER FUNCTION add_oam_link_ref_endport() OWNER TO OSSDBUSER;
--select add_oam_link_ref_endport();
drop function if exists add_oam_link_ref_endport;
--3.19.10.200.1080_END

--3.19.10.200.1290_BEGIN
select alter_columns('add','tab_dcn_external_gateway_affected_router','old_fabric_vpn_target','character varying(512)');
--3.19.10.200.1290_END

--3.19.10.200.1700_BEGIN
select alter_columns('add','tab_dcn_router_whitelist','deploy_status','boolean');
--3.19.10.200.1700_END

--3.19.10.200.1780_BEGIN
CREATE OR REPLACE FUNCTION get_device_fabrics(v_cluster_id varchar) RETURNS varchar[] AS $body$
	declare
		v_all_fabrics varchar[] =ARRAY[]::varchar[];
		v_device_fabric varchar;
	begin
		for cluster_mem in select id,host_cluster_id,device_id from tab_dcn_svo_host_cluster_member where host_cluster_id = v_cluster_id loop
			if exists (select 1 from tab_dcn_fabric_device_resm_manage where id =cluster_mem.device_id) then
				select fabric_id from tab_dcn_fabric_device_resm_manage where id =cluster_mem.device_id into v_device_fabric;
			else 
				v_device_fabric = 'none';
			end if;
			if v_device_fabric=any (v_all_fabrics) then
			--<>���������жϣ��ʴ˴�ʹ��if/else�ж�
			else
				v_all_fabrics=array_append(v_all_fabrics, v_device_fabric);
			end if;
		end loop;
		DBMS_OUTPUT.PUT_LINE('v_all_fabrics:'||array_to_string(v_all_fabrics,','));
		return v_all_fabrics;
	END;
$body$ language plpgsql;

CREATE OR REPLACE FUNCTION update_host_cluster_fabric() RETURNS INTEGER AS $body$
	declare
		new_host_cluster_id varchar;
		new_cluster_name varchar;
		cluster_fabric_id varchar;
		v_cluster_fabrics varchar[];
		v_cluster_fabric_num integer;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to update_host_cluster_fabric');
		if not exists (select 1 from tab_dcn_svo_host_cluster where trim(fabric_id) is null) then
			return 0;
		end if;
		DBMS_OUTPUT.PUT_LINE('start to update_host_cluster_fabric ');
		
		drop table if exists tab_dcn_svo_host_cluster_temp;
		create table tab_dcn_svo_host_cluster_temp  (
		   id nvarchar2(128) not null,
		   name nvarchar2(255),
		   fabric_id nvarchar2(36),
		   producer nvarchar2(36),
		   create_time timestamp default current_timestamp,
		   update_time timestamp with time zone
		);
		alter table tab_dcn_svo_host_cluster_temp add constraint pk_dcn_svo_host_cluster_temp primary key (id);
		
		drop table if exists tab_dcn_svo_host_cluster_member_temp;
		create table tab_dcn_svo_host_cluster_member_temp  (
			id nvarchar2(128) not null,
			host_cluster_id nvarchar2(128),
			device_id nvarchar2(128),
			device_name nvarchar2(255),
			device_port_id nvarchar2(128),
			device_port_name nvarchar2(255),
			create_time timestamp default current_timestamp,
			update_time timestamp with time zone
		);
		alter table tab_dcn_svo_host_cluster_member_temp add constraint pk_dcn_svo_host_cluster_member_temp primary key (id);
		
		drop table if exists tab_dcn_logic_port_pre_config_temp;
		create table tab_dcn_logic_port_pre_config_temp  (
			id nvarchar2(128) not null,
			host_cluster_id nvarchar2(128)  not null,
			logic_switch_id nvarchar2(36)  not null,
			vlan integer,
			egress_vlan integer,
			producer nvarchar2(36)
		);
		alter table tab_dcn_logic_port_pre_config_temp add constraint pk_dcn_logic_port_pre_config_temp primary key (id);
		
		drop table if exists tab_dcn_svo_vmm_host_cluster_temp;
		create table tab_dcn_svo_vmm_host_cluster_temp  (
			id nvarchar2(128) not null,
			port_group_id nvarchar2(128)  not null,
			host_cluster_id nvarchar2(128)  not null,
			host_cluster_name nvarchar2(255) 
		);
		alter table tab_dcn_svo_vmm_host_cluster_temp add constraint pk_dcn_svo_vmm_host_cluster_temp primary key (id);
		
		for host_cluster in select id,name,producer from tab_dcn_svo_host_cluster loop
			v_cluster_fabrics =get_device_fabrics(host_cluster.id);
			DBMS_OUTPUT.PUT_LINE('host cluster:'||host_cluster.id||',fabrics:'|| array_to_string(v_cluster_fabrics,','));
			
			FOREACH cluster_fabric_id in ARRAY v_cluster_fabrics loop
				new_host_cluster_id =randUuid(); 
				DBMS_OUTPUT.PUT_LINE('new_host_cluster_id:'||new_host_cluster_id||' ,fabric:'||cluster_fabric_id);
				if(cluster_fabric_id ='none') then
					--����fabric����
					new_cluster_name = host_cluster.name || '_NoFabric';
					--tab_dcn_svo_host_cluster_temp
					insert into tab_dcn_svo_host_cluster_temp (id, name, fabric_id, producer) 
					values
					(new_host_cluster_id ,new_cluster_name, null, host_cluster.producer);
					--tab_dcn_svo_host_cluster_member_temp
					for cluster_mem in select id,host_cluster_id,device_id,device_name,device_port_id,device_port_name from tab_dcn_svo_host_cluster_member where host_cluster_id = host_cluster.id loop
						if not exists (select 1 from tab_dcn_fabric_device_resm_manage where id=cluster_mem.device_id) then 
							insert into tab_dcn_svo_host_cluster_member_temp (id,HOST_CLUSTER_ID,DEVICE_ID,DEVICE_NAME,DEVICE_PORT_ID,DEVICE_PORT_NAME)
							values 
							(randUuid(),new_host_cluster_id,cluster_mem.device_id,cluster_mem.device_name,cluster_mem.device_port_id,cluster_mem.device_port_name);
						end if;
					end loop;

				else
					--��fabric��Ϣ
					new_cluster_name = host_cluster.name || '_'|| (select name from tab_dcn_fabric_resm_basicinfo where id=cluster_fabric_id);
					--tab_dcn_svo_host_cluster_temp
					insert into tab_dcn_svo_host_cluster_temp (id, name, fabric_id, producer) 
					values (new_host_cluster_id ,new_cluster_name, cluster_fabric_id, host_cluster.producer);
					--tab_dcn_svo_host_cluster_member_temp
					for cluster_mem in select id,host_cluster_id,device_id,device_name,device_port_id,device_port_name from tab_dcn_svo_host_cluster_member where host_cluster_id = host_cluster.id loop
						if exists (select 1 from tab_dcn_fabric_device_resm_manage where id=cluster_mem.device_id and fabric_id = cluster_fabric_id) then 
							insert into tab_dcn_svo_host_cluster_member_temp (id,HOST_CLUSTER_ID,DEVICE_ID,DEVICE_NAME,DEVICE_PORT_ID,DEVICE_PORT_NAME)
							values (randUuid(),new_host_cluster_id,cluster_mem.device_id,cluster_mem.device_name,cluster_mem.device_port_id,cluster_mem.device_port_name);
						end if;
					end loop;
				
				end if;
				--tab_dcn_logic_port_pre_config_temp
				for lp_pre in select id,host_cluster_id,logic_switch_id,vlan,egress_vlan,producer from TAB_DCN_LOGIC_PORT_PRE_CONFIG where host_cluster_id = host_cluster.id loop
					insert into tab_dcn_logic_port_pre_config_temp (id,host_cluster_id,logic_switch_id,vlan, egress_vlan, producer) 
					values (randUuid(),new_host_cluster_id,lp_pre.logic_switch_id,lp_pre.vlan,lp_pre.egress_vlan,lp_pre.producer);
				end loop;
				--tab_dcn_svo_vmm_host_cluster_temp
				for vmm in select id,port_group_id,host_cluster_id,host_cluster_name from tab_dcn_svo_vmm_host_cluster where host_cluster_id = host_cluster.id loop
					insert into tab_dcn_svo_vmm_host_cluster_temp (id,port_group_id,host_cluster_id,host_cluster_name) 
					values (randUuid(),vmm.port_group_id,new_host_cluster_id,new_cluster_name);
				end loop;
			end loop;
		end loop;
		--ɾ��ԭ��temp��������
		drop table if exists tab_dcn_svo_host_cluster;
		ALTER TABLE tab_dcn_svo_host_cluster_temp RENAME TO tab_dcn_svo_host_cluster;
		ALTER INDEX pk_dcn_svo_host_cluster_temp RENAME TO pk_dcn_svo_host_cluster;
		--
		drop table if exists tab_dcn_svo_host_cluster_member;
		ALTER TABLE tab_dcn_svo_host_cluster_member_temp RENAME TO tab_dcn_svo_host_cluster_member;
		ALTER INDEX pk_dcn_svo_host_cluster_member_temp RENAME TO pk_dcn_svo_host_cluster_member;
		--
		drop table if exists tab_dcn_logic_port_pre_config;
		ALTER TABLE tab_dcn_logic_port_pre_config_temp RENAME TO tab_dcn_logic_port_pre_config;
		ALTER INDEX pk_dcn_logic_port_pre_config_temp RENAME TO pk_dcn_logic_port_pre_config;
		--
		drop table if exists tab_dcn_svo_vmm_host_cluster;
		ALTER TABLE tab_dcn_svo_vmm_host_cluster_temp RENAME TO tab_dcn_svo_vmm_host_cluster;
		ALTER INDEX pk_dcn_svo_vmm_host_cluster_temp RENAME TO pk_dcn_svo_vmm_host_cluster;
		
 RETURN 0;
END;
$body$ language plpgsql;
select update_host_cluster_fabric();
drop function if exists update_host_cluster_fabric; 
drop function if exists get_device_fabrics(varchar); 
--3.19.10.200.1780_END

--3.19.10.201.0060_BEGIN
CREATE OR REPLACE FUNCTION append_logic_port_name_index_to_unqiue() RETURNS INTEGER AS $body$
	DECLARE
        v_lp_id varchar;
		v_step integer:=0;
    begin
        DBMS_OUTPUT.PUT_LINE('begin to append_logic_port_name_index_to_unqiue');
		if exists (select 1 from tab_dcn_logic_port where create_type is null and (trim(producer) is null or producer not like 'component%') group by app_id,name having  array_length(array_agg(pk_dcn_id),1)>1 ) then
			for lp in (select array_agg(pk_dcn_id) as lp_ids, name, app_id from tab_dcn_logic_port where create_type is null and (trim(producer) is null or producer not like 'component%') group by app_id,name having  array_length(array_agg(pk_dcn_id),1)>1) loop
				DBMS_OUTPUT.PUT_LINE('the vpc :'||lp.app_id || ' has same name logic port');
				v_step :=1;
				FOREACH v_lp_id IN ARRAY lp.lp_ids loop
					update tab_dcn_logic_port set name = name||'_'||v_step where pk_dcn_id = v_lp_id;
					v_step := v_step+1;
				end loop;
			end loop;
		end if;
 RETURN 0;
END;
$body$ language plpgsql;
select append_logic_port_name_index_to_unqiue();
drop function if exists append_logic_port_name_index_to_unqiue;
--3.19.10.201.0060_END

--3.19.10.201.0070_BEGIN
select alter_columns('add','tab_dcn_logic_switch','deploy_status','character varying(64)');
update tab_dcn_logic_switch set deploy_status='Done' where trim(deploy_status) is null;

delete from tab_dcn_svo_spec_param where code ='PORT_NUM_CALL_TASK';
insert into tab_dcn_svo_spec_param values ('PORT_NUM_CALL_TASK', 50);

delete from tab_dcn_svo_spec_param where CODE = 'IPV4_MANUAL_ROUTE_LIMIT';
insert into tab_dcn_svo_spec_param values ('IPV4_MANUAL_ROUTE_LIMIT', 2000);
delete from tab_dcn_svo_spec_param where CODE = 'IPV6_MANUAL_ROUTE_LIMIT';
insert into tab_dcn_svo_spec_param values ('IPV6_MANUAL_ROUTE_LIMIT', 2000);

create or replace function get_diff_result(arr_1 varchar[],arr_2 varchar[]) returns varchar[] as $body$
declare
    v_result varchar[]= ARRAY[]::varchar[];
    v_temp varchar;
begin
    FOREACH  v_temp in ARRAY arr_1 LOOP
         DBMS_OUTPUT.PUT_LINE('v_temp:'||v_temp);
        if (v_temp =any(arr_2)) then
            --= ����<>����Ч
        else
            v_result =array_append(v_result,v_temp);
        end if;
    END LOOP;
    return v_result;   
end;$body$ language plpgsql;

create or replace function fix_dhcp_port_subnet_info() returns integer as $body$
  declare
    arr_vmport_subnets varchar[]= ARRAY[]::varchar[];
    arr_dhcpport_subnets varchar[]= ARRAY[]::varchar[];
    arr_deal_subnets varchar[]= ARRAY[]::varchar[];
    record_end_port tab_dcn_svo_end_port%ROWTYPE;
    v_fixiplist varchar;
    v_fixipv6list varchar;
    vmport_subnet varchar;
	begin
        DBMS_OUTPUT.PUT_LINE('begin to fix_dhcp_port_subnet_info');
        if not exists (select 1 from TAB_DCN_NEUTRON_CLOUDS where lower(DHCP_SERVER_PROVIDER)='ce1800v') then
            DBMS_OUTPUT.PUT_LINE('not ce1800v dhcp scene.');
            return 0;
        end if;
        if not exists (select 1 from  tab_dcn_svo_end_port where trim(host_id) is not null) then
            DBMS_OUTPUT.PUT_LINE('not ce1800v dhcp scene.');
            return 0;
        end if;
        
        for ls_host in select logic_switch_id,host_id from tab_dcn_svo_end_port group by logic_switch_id,host_id having trim(host_id) is not null loop
            DBMS_OUTPUT.PUT_LINE('begin to deal logic_switch:'|| ls_host.logic_switch_id ||' host_id:'|| ls_host.host_id);
            arr_vmport_subnets = ARRAY[]::varchar[];
            arr_dhcpport_subnets = ARRAY[]::varchar[];

            if not exists (select 1 from  tab_dcn_svo_end_port_ip ip left join tab_dcn_svo_end_port ep on ip.endport_id = ep.id where  ep.host_id=ls_host.host_id and (ep.device_owner like 'compute:%' or  ep.device_owner like 'trunk:subport%') and  ep.logic_switch_id = ls_host.logic_switch_id) then
                DBMS_OUTPUT.PUT_LINE('the logic switch '|| ls_host.logic_switch_id ||' vm port has no subnet.');
                continue;
            end if;

            select array_agg(distinct subnet_id) from tab_dcn_svo_end_port_ip ip left join tab_dcn_svo_end_port ep on ip.endport_id = ep.id where ep.host_id=ls_host.host_id and (ep.device_owner like 'compute:%' or  ep.device_owner like 'trunk:subport%') and  ep.logic_switch_id = ls_host.logic_switch_id into arr_vmport_subnets;

            if not exists (select 1 from  tab_dcn_svo_end_port_ip ip left join tab_dcn_svo_end_port ep on ip.endport_id = ep.id where ep.host_id=ls_host.host_id and lower(ep.device_owner)='network:dhcp' and  ep.logic_switch_id = ls_host.logic_switch_id) then
                DBMS_OUTPUT.PUT_LINE('the logic switch '|| ls_host.logic_switch_id ||' dhcp port has no subnet.');
                continue;
            end if;

            select array_agg(distinct subnet_id) from tab_dcn_svo_end_port_ip ip left join tab_dcn_svo_end_port ep on ip.endport_id = ep.id where ep.host_id=ls_host.host_id and lower(ep.device_owner)='network:dhcp' and  ep.logic_switch_id = ls_host.logic_switch_id into arr_dhcpport_subnets;

            if array_length(arr_dhcpport_subnets,1) > array_length(arr_vmport_subnets,1) then
                DBMS_OUTPUT.PUT_LINE('the logic switch '|| ls_host.logic_switch_id ||' dhcp port subnet info is more than the vm port subnet.');
                arr_deal_subnets = get_diff_result(arr_dhcpport_subnets,arr_vmport_subnets);
                DBMS_OUTPUT.PUT_LINE('the logic_switch:'|| ls_host.logic_switch_id ||',the host_id:'|| ls_host.host_id || 'subnet:'|| array_to_string(arr_deal_subnets,',') ||' need delete.');
                --��ȡʵ������dhcp port
                for end_port in select distinct ep.id,ep.meta_data  from  tab_dcn_svo_end_port_ip ip left join tab_dcn_svo_end_port ep on ip.endport_id = ep.id where ep.host_id=ls_host.host_id and lower(ep.device_owner)='network:dhcp' and  ep.logic_switch_id = ls_host.logic_switch_id loop
                    DBMS_OUTPUT.PUT_LINE('the end_port'|| end_port.id);
                    --ɾ��endport_ip������ 
                    delete from tab_dcn_svo_end_port_ip where endport_id = end_port.id and subnet_id =any(arr_deal_subnets);
                    --����IPV4 fixIp
                    if not exists (select 1 from  tab_dcn_svo_end_port_ip where endport_id=end_port.id and ip_address not like '%:%') then
                        v_fixiplist ='{"fixiplist":[]}';
                    else
                        v_fixiplist = '{"fixiplist":'|| (select replace(array_to_json(array_agg(e))::text,'VMIP','vmip')  from (select ip_address as vmip from tab_dcn_svo_end_port_ip where endport_id=end_port.id and ip_address not like '%:%')e)||'}';
                    end if;                    
                    --����IPV6 fixIp
                    if not exists (select 1 from  tab_dcn_svo_end_port_ip where endport_id=end_port.id and ip_address like '%:%') then
                        v_fixipv6list ='{"fixipv6list":[]}';
                    else
                        v_fixipv6list = '{"fixipv6list":'|| (select replace(array_to_json(array_agg(e))::text,'VMIP','vmip')  from (select ip_address as vmip from tab_dcn_svo_end_port_ip where endport_id=end_port.id and ip_address like '%:%')e)||'}';
                    end if;
                    DBMS_OUTPUT.PUT_LINE('the fixiplist:'|| v_fixiplist ||',the v_fixipv6list:'|| v_fixipv6list);
                    
                    --����meta_data
                    update tab_dcn_svo_end_port set meta_data= meta_data::jsonb || v_fixiplist::jsonb|| v_fixipv6list::jsonb where id=  end_port.id;
                    --ɾ��tab_dcn_svo_dhcp_server_info
                    delete from tab_dcn_svo_dhcp_server_info where logicswitch_id=ls_host.logic_switch_id and DHCP_HOST_ID=ls_host.host_id and subnet_id::varchar=any(arr_deal_subnets);
                end loop;
            end if;
        end loop;
       
		return 0;
	end;
$body$ language plpgsql;
select fix_dhcp_port_subnet_info();
drop function if exists fix_dhcp_port_subnet_info;
drop function if exists get_diff_result;
--3.19.10.201.0070_END

--3.19.10.201.0090_BEGIN
select alter_columns('alter','tab_dcn_svo_dhcp_server_info','ip_address','varchar(128)');
select alter_columns('alter','tab_dcn_svo_ip_mac_binding_info','ip_address','varchar(128)');
--3.19.10.201.0090_END

--3.19.10.202.0020_BEGIN
select alter_columns('add','tab_dcn_gbp_logic_router_subnet','external_access_mode','integer');

create or replace function set_external_access_mode() returns text as $body$
declare
    v_ext_conn_id varchar;
    v_ext_net_id varchar;
    v_cnt integer;
begin
    DBMS_OUTPUT.PUT_LINE('begin set_external_access_mode'); 
    
    update tab_dcn_gbp_logic_router_subnet l2l3_subnet set l2l3_subnet.external_access_mode = 0 from 
        tab_dcn_neutron_subnet neutron_subnet where neutron_subnet.id = l2l3_subnet.id::UUID and neutron_subnet.IP_VERSION = 'ipv4' and neutron_subnet.external_access_mode = 0;
        
    update tab_dcn_gbp_logic_router_subnet l2l3_subnet set l2l3_subnet.external_access_mode = 1 from 
        tab_dcn_neutron_subnet neutron_subnet where neutron_subnet.id = l2l3_subnet.id::UUID and neutron_subnet.IP_VERSION = 'ipv4' and 
        (neutron_subnet.external_access_mode = 1 or neutron_subnet.external_access_mode is null);
        
    update tab_dcn_gbp_logic_router_subnet l2l3_subnet set l2l3_subnet.external_access_mode = 1 from 
        tab_dcn_neutron_subnet neutron_subnet where neutron_subnet.id = l2l3_subnet.id::UUID and neutron_subnet.IP_VERSION = 'ipv6';
    
    for router_info in select router.uuid as router_id, router.EXTERNAL_NETWORK_ID, gw.id as gw_id from tab_dcn_neutron_router router, tab_dcn_neutron_network network, tab_dcn_external_gateway gw where 
        router.EXTERNAL_NETWORK_ID is not null and network.id = router.EXTERNAL_NETWORK_ID and gw.type = 4 and network.name like gw.name||'%' and 
        (router.ENABLE_SNAT is null or router.ENABLE_SNAT='false') loop
    
        DBMS_OUTPUT.PUT_LINE('router id:'||router_info.router_id::varchar||' gw id:'||router_info.gw_id::varchar);

        select EXTERNAL_NETWORK_ID, id as ext_conn_id from tab_dcn_sfco_ext_conn where ROUTER_ID::UUID = router_info.router_id and EXTERNAL_GATEWAY_ID::UUID = router_info.gw_id 
            union all select null,null limit 1 into v_ext_net_id, v_ext_conn_id;
        if v_ext_net_id is null then
            DBMS_OUTPUT.PUT_LINE('    external network not found!');
            continue;
        end if;
        
        for subnet_info in select subnet.cidr, l2l3_subnet.LOGIC_SWITCH_ID, subnet.id, subnet.external_access_mode from TAB_DCN_NEUTRON_INTERFACES router_if, tab_dcn_neutron_subnet subnet, 
            tab_dcn_gbp_logic_router_subnet l2l3_subnet where router_if.ROUTER_ID = router_info.router_id and subnet.id = router_if.SUBNET_ID and subnet.id = l2l3_subnet.id::UUID loop
            
            DBMS_OUTPUT.PUT_LINE('    subnet cidr:'||subnet_info.cidr);
            select count(snat) from tab_dcn_neutron_snat snat, tab_dcn_neutron_snat_orignal_cidrs snat_cidr where snat.ROUTER_ID = router_info.router_id 
                and snat.SNAT_NETWORK_ID = router_info.EXTERNAL_NETWORK_ID and snat_cidr.SNAT_ID = snat.uuid and snat_cidr.cidr = subnet_info.cidr into v_cnt;
            if v_cnt > 0 then
                DBMS_OUTPUT.PUT_LINE('    elastic snat exists!');
                continue;
            end if;
            
            select count(*) from tab_dcn_fabric_service_staticroute static_route, tab_dcn_fabric_service_route service_route where service_route.LOGIC_ROUTER_ID = router_info.gw_id::varchar
                and static_route.route_id = service_route.id and static_route.IPV4_DESTINATION_CIDR = subnet_info.cidr into v_cnt;
            if v_cnt > 0 then
                if subnet_info.external_access_mode = 0 then
                    DBMS_OUTPUT.PUT_LINE('    change external_access_mode from 0 to 1, subnet id:'||subnet_info.id::varchar);
                    update tab_dcn_neutron_subnet set external_access_mode = 1 where id = subnet_info.id;
                    update tab_dcn_gbp_logic_router_subnet set external_access_mode = 1 where id = subnet_info.id::varchar;
                end if;
            end if;
        end loop;
    end loop;
    DBMS_OUTPUT.PUT_LINE('end set_external_access_mode'); 
    return 'success';
end;
$body$ language plpgsql;

ALTER FUNCTION set_external_access_mode() OWNER TO ossdbuser;
select set_external_access_mode();
drop function if exists set_external_access_mode();
--3.19.10.202.0020_END
