--3.19.0.0.015_BEGIN
select alter_columns('alter','tab_dcn_ovs_router_interface_info','id','character varying(128)');
select alter_columns('alter','tab_dcn_ovs_logic_router_info','id','character varying(128)');
--3.19.0.0.015_END

--3.19.0.0.070_BEGIN
create table if not exists tab_dcn_ovs_l3_ip_mac_route_info
(
  path_id int,
  ip_len_mask int,
  vm_ip character varying(64),
  vm_mac character varying(32),
  mac_len_mask int,
  l2_vni bigint,
  l3_vni bigint,
  vtep_ip character varying(64),
  l3_vni_mac character varying(32),
  gateway_mac character varying(32)
);
alter table tab_dcn_ovs_l3_ip_mac_route_info drop constraint if exists pk_dcn_ovs_l3_ip_mac_route_info ;
alter table tab_dcn_ovs_l3_ip_mac_route_info add constraint pk_dcn_ovs_l3_ip_mac_route_info primary key (ip_len_mask,vm_ip,l3_vni,path_id);

alter table tab_dcn_ovs_l3_ip_mac_route_info owner to ossdbuser;
drop index if exists idx_vmmac_tab_dcn_ovs_l3_ip_mac_route_info;
create index idx_vmmac_tab_dcn_ovs_l3_ip_mac_route_info on tab_dcn_ovs_l3_ip_mac_route_info(vm_mac);
drop index if exists idx_vmip_tab_dcn_ovs_l3_ip_mac_route_info;
create index idx_vmip_tab_dcn_ovs_l3_ip_mac_route_info on tab_dcn_ovs_l3_ip_mac_route_info(vm_ip);

create or replace function dcn_upgrade_tab_dcn_ovs_l3_ip_mac_route_info() returns integer as $body$
  declare
    exist_count int := 0;
	begin
		FOR record_coms IN (select router_id,path_id,l2_rd,tag_id,mac_len_mask,vm_mac,ip_len_mask,vm_ip,l2_vni,l3_vni,vtep_ip,l2_rt,l3_vni_mac,tunnel_type,gateway_mac from tab_dcn_ovs_vm_remote_router_info where l3_vni > 0) LOOP
      EXECUTE IMMEDIATE  'select count(*) from tab_dcn_ovs_l3_ip_mac_route_info where ' ||
              'vm_ip='''||record_coms.vm_ip||''' and l3_vni='''||record_coms.l3_vni||''' and ' ||
              'ip_len_mask='''||record_coms.ip_len_mask||''' and path_id='''||record_coms.path_id||'''' into exist_count;
      if exist_count=0 then
        insert into tab_dcn_ovs_l3_ip_mac_route_info(path_id, ip_len_mask, vm_ip, l3_vni, vm_mac, mac_len_mask, l2_vni, vtep_ip, l3_vni_mac, gateway_mac)
          values(record_coms.path_id, record_coms.ip_len_mask, record_coms.vm_ip, record_coms.l3_vni, record_coms.vm_mac,
          record_coms.mac_len_mask, record_coms.l2_vni, record_coms.vtep_ip, record_coms.l3_vni_mac, record_coms.gateway_mac);
      end if ;
		end loop;
		return 0;
	end;
$body$ language plpgsql;
ALTER FUNCTION dcn_upgrade_tab_dcn_ovs_l3_ip_mac_route_info() OWNER TO ossdbuser;

select dcn_upgrade_tab_dcn_ovs_l3_ip_mac_route_info();
drop function if exists dcn_upgrade_tab_dcn_ovs_l3_ip_mac_route_info;

delete from tab_dcn_ovs_vm_remote_router_info where l3_vni > 0;

create or replace function dcn_merge_tab_dcn_ovs_vm_remote_router_info() returns integer as $body$
  declare
    pre_l2vni bigint := -1;
    pre_vmmac varchar(32) := '';
  begin
    FOR record_coms IN (select router_id,path_id,l2_rd,tag_id,mac_len_mask,vm_mac,ip_len_mask,vm_ip,l2_vni,l3_vni,vtep_ip,l2_rt,l3_vni_mac,tunnel_type,gateway_mac from tab_dcn_ovs_vm_remote_router_info order by l2_vni, vm_mac) LOOP
      if pre_l2vni = record_coms.l2_vni and pre_vmmac = record_coms.vm_mac then
        delete from tab_dcn_ovs_vm_remote_router_info where router_id = record_coms.router_id;
      end if;
      pre_l2vni = record_coms.l2_vni;
      pre_vmmac = record_coms.vm_mac;
    end loop;
    return 0;
  end;
$body$ language plpgsql;
ALTER FUNCTION dcn_merge_tab_dcn_ovs_vm_remote_router_info() OWNER TO ossdbuser;

select dcn_merge_tab_dcn_ovs_vm_remote_router_info();
drop function if exists dcn_merge_tab_dcn_ovs_vm_remote_router_info;

alter table tab_dcn_ovs_vm_remote_router_info drop constraint if exists pk_dcn_ovs_vm_remote_router_info ;
alter table tab_dcn_ovs_vm_remote_router_info add constraint pk_dcn_ovs_vm_remote_router_info primary key (l2_vni, vm_mac);
alter table tab_dcn_ovs_vm_remote_router_info OWNER TO ossdbuser;

drop index if exists tab_dcn_ovs_vm_remote_router_info_remote_router_index;
drop index if exists tab_dcn_ovs_vm_remote_router_info_l3vni_index;

drop index if exists tab_dcn_ovs_vm_remote_router_info_ip_index;
create index tab_dcn_ovs_vm_remote_router_info_ip_index on tab_dcn_ovs_vm_remote_router_info(vm_ip);
drop index if exists tab_dcn_ovs_vm_remote_router_info_mac_index;
create index tab_dcn_ovs_vm_remote_router_info_mac_index on tab_dcn_ovs_vm_remote_router_info(vm_mac);

create or replace function dcn_merge_tab_dcn_ovs_ip_prefix_route_info() returns integer as $body$
  declare
    pre_l3vni bigint := -1;
    pre_pathid int := -1;
    pre_prefix varchar(64) := '';
    pre_mask int := -1;
  begin
    FOR record_coms IN (select router_id,path_id,l3_rd,tag_id,ip_len_mask,ip_prefix,l3_vni,vtep_ip,l3_rt,l3_vni_mac,tunnel_type,route_type,nexthop_vni,gateway_ip,gateway_mac,nexthop_mac,ne_id,ifindex,group_id from tab_dcn_ovs_ip_prefix_route_info order by ip_prefix,l3_vni,path_id,ip_len_mask) LOOP
      if pre_l3vni = record_coms.l3_vni and pre_pathid = record_coms.path_id and pre_mask = record_coms.ip_len_mask and pre_prefix = record_coms.ip_prefix then
        delete from tab_dcn_ovs_ip_prefix_route_info where router_id = record_coms.router_id and ip_prefix = record_coms.ip_prefix and l3_vni = record_coms.l3_vni;
      elseif record_coms.route_type = 'ROUTE_IPPREFIX' and record_coms.gateway_ip notnull and record_coms.gateway_ip != '0.0.0.0' and record_coms.gateway_ip != '::' then
        update tab_dcn_ovs_ip_prefix_route_info set route_type = 'ROUTE_ECMP' where router_id = record_coms.router_id and ip_prefix = record_coms.ip_prefix and l3_vni = record_coms.l3_vni;
      end if ;
      pre_l3vni = record_coms.l3_vni;
      pre_prefix = record_coms.ip_prefix;
      pre_pathid = record_coms.path_id;
      pre_mask = record_coms.ip_len_mask;
    end loop;
    return 0;
  end;
$body$ language plpgsql;
ALTER FUNCTION dcn_merge_tab_dcn_ovs_ip_prefix_route_info() OWNER TO ossdbuser;

select dcn_merge_tab_dcn_ovs_ip_prefix_route_info();
drop function if exists dcn_merge_tab_dcn_ovs_ip_prefix_route_info;

alter table tab_dcn_ovs_ip_prefix_route_info drop constraint if exists pk_dcn_ovs_ip_prefix_route_info ;
alter table tab_dcn_ovs_ip_prefix_route_info add constraint pk_dcn_ovs_ip_prefix_route_info primary key (ip_len_mask,ip_prefix,l3_vni,path_id);
alter table tab_dcn_ovs_ip_prefix_route_info owner to ossdbuser;

drop index if exists idx_tab_dcn_ovs_ip_prefix_route_info;
drop index if exists idx_prefix_tab_dcn_ovs_ip_prefix_route_info;
create index idx_prefix_tab_dcn_ovs_ip_prefix_route_info on tab_dcn_ovs_ip_prefix_route_info(ip_prefix);
drop index if exists idx_l3vni_tab_dcn_ovs_ip_prefix_route_info;
create index idx_l3vni_tab_dcn_ovs_ip_prefix_route_info on tab_dcn_ovs_ip_prefix_route_info(l3_vni);
drop index if exists idx_type_tab_dcn_ovs_ip_prefix_route_info;
create index idx_type_tab_dcn_ovs_ip_prefix_route_info on tab_dcn_ovs_ip_prefix_route_info(route_type);
--3.19.0.0.070_END

--3.19.0.100.010_BEGIN
--allow-address-pairup_time
select alter_columns('ADD', 'tab_dcn_ovs_allowed_addr_pairs', 'up_time', 'bigint default 0');
--״̬ΪupĲֳһdownΪ
create or replace function dcn_merge_tab_dcn_ovs_allowed_addr_pairs() returns integer as $body$
declare
  cur_time bigint := 0;
  cidr varchar(50) := '';
begin
  FOR floors IN (select floor(extract(epoch from((current_timestamp - timestamp '1970-01-01 00:00:00')*1000)))) LOOP
    cur_time = floors.FLOOR;
  end loop;

  FOR record_coms IN (select logic_port_id,neutron_port_uuid,ip_address,l2_vni,status,mac_address,ne_id,vm_port_id,vtep_ip,vm_mac,up_time from tab_dcn_ovs_allowed_addr_pairs where status=1) LOOP
    --״̬ΪupĲ
    if 0 = record_coms.up_time then
      if record_coms.ip_address like '%.%' then
        cidr = concat(record_coms.ip_address, '/32');
      else
        cidr = concat(record_coms.ip_address, '/128');
      end if;
      --һõģip->cidr״̬Ϊdown
      insert into tab_dcn_ovs_allowed_addr_pairs(LOGIC_PORT_ID,NEUTRON_PORT_UUID,IP_ADDRESS,L2_VNI,STATUS,MAC_ADDRESS,NE_ID,VM_PORT_ID,VTEP_IP,VM_MAC)
      values (record_coms.logic_port_id, record_coms.neutron_port_uuid, cidr, record_coms.l2_vni, 0, record_coms.mac_address, record_coms.ne_id, record_coms.vm_port_id, record_coms.vtep_ip, record_coms.vm_mac);
      --ϱup_time
      update tab_dcn_ovs_allowed_addr_pairs set up_time=cur_time where logic_port_id=record_coms.logic_port_id and ip_address=record_coms.ip_address;
    end if ;
  end loop;
  return 0;
end;
$body$ language plpgsql;
ALTER FUNCTION dcn_merge_tab_dcn_ovs_allowed_addr_pairs() OWNER TO ossdbuser;
select dcn_merge_tab_dcn_ovs_allowed_addr_pairs();
drop function if exists dcn_merge_tab_dcn_ovs_allowed_addr_pairs;
--3.19.0.100.010_END

--3.19.0.100.151_BEGIN
select alter_columns('alter','tab_dcn_ovs_vm_north_info','vm_ip','character varying(4096)');
select alter_columns('alter','tab_dcn_ovs_vm_north_info','gateway_ip','character varying(4096)');
--3.19.0.100.151_END

--3.19.10.0.150000_BEGIN
--l3_ip_mac_route pathid change to gatewayip
select alter_columns('ADD', 'tab_dcn_ovs_l3_ip_mac_route_info', 'gateway_ip', 'character varying(64)');
update tab_dcn_ovs_l3_ip_mac_route_info set gateway_ip='0.0.0.0' where vm_ip like '%.%';
update tab_dcn_ovs_l3_ip_mac_route_info set gateway_ip='::' where vm_ip like '%:%';
alter table tab_dcn_ovs_l3_ip_mac_route_info drop constraint if exists pk_dcn_ovs_l3_ip_mac_route_info ;
alter table tab_dcn_ovs_l3_ip_mac_route_info add constraint pk_dcn_ovs_l3_ip_mac_route_info primary key (ip_len_mask,vm_ip,l3_vni,gateway_ip);
alter table tab_dcn_ovs_l3_ip_mac_route_info alter PATH_ID drop not null;

--ip_prefix
select alter_columns('alter','tab_dcn_ovs_ip_prefix_route_info','gateway_ip','character varying(64)');
--set gatewayip to 0.0.0.0/::/127.0.0.1
update tab_dcn_ovs_ip_prefix_route_info set gateway_ip='127.0.0.1' where route_type='SUBNET';
update tab_dcn_ovs_ip_prefix_route_info set gateway_ip='0.0.0.0' where (gateway_ip is null or gateway_ip='') and ip_prefix like '%.%';
update tab_dcn_ovs_ip_prefix_route_info set gateway_ip='::' where (gateway_ip is null or gateway_ip='') and ip_prefix like '%:%';
update tab_dcn_ovs_ip_prefix_route_info set gateway_ip='0.0.0.0' where gateway_ip='::' and ip_prefix like '%.%';
update tab_dcn_ovs_ip_prefix_route_info set gateway_ip='::' where gateway_ip='0.0.0.0' and ip_prefix like '%:%';
--delete records if gatewayip duplicate
drop table if exists tab_dcn_ovs_temp_ip_prefix_route_info;    
create table tab_dcn_ovs_temp_ip_prefix_route_info
(
  router_id character varying(50),
  path_id int,
  l3_rd character varying(128),
  tag_id int,
  ip_len_mask int,
  ip_prefix character varying(64),
  l3_vni bigint,
  vtep_ip character varying(64),  
  l3_rt character varying(128), 
  l3_vni_mac character varying(32), 
  tunnel_type integer,
  route_type  character varying(32),
  nexthop_vni integer,
  gateway_ip character varying(64),
  gateway_mac character varying(32),
  nexthop_mac character varying(32),
  ne_id character varying(64),
  ifindex character varying(32),
  group_id character varying(32)
);

alter table tab_dcn_ovs_temp_ip_prefix_route_info drop constraint if exists pk_dcn_ovs_temp_ip_prefix_route_info;
alter table tab_dcn_ovs_temp_ip_prefix_route_info add constraint pk_dcn_ovs_temp_ip_prefix_route_info primary key (ip_len_mask,ip_prefix,l3_vni,gateway_ip);
alter table tab_dcn_ovs_temp_ip_prefix_route_info owner to ossdbuser;

create or replace function dcn_merge_tab_dcn_ovs_temp_ip_prefix_route_info() returns integer as $body$
  declare
    pre_l3vni bigint := -1;
    pre_pathid int := -1;
    pre_prefix varchar(64) := '';
    pre_mask int := -1;
  begin
    FOR record_coms1 IN (select distinct ip_prefix,l3_vni,gateway_ip,ip_len_mask from tab_dcn_ovs_ip_prefix_route_info) LOOP
	  FOR record_coms2 IN (select router_id,path_id,l3_rd,tag_id,ip_len_mask,ip_prefix,l3_vni,vtep_ip,l3_rt,l3_vni_mac,tunnel_type,route_type,nexthop_vni,gateway_ip,gateway_mac,nexthop_mac,ne_id,ifindex,group_id from tab_dcn_ovs_ip_prefix_route_info where ip_prefix=record_coms1.ip_prefix and l3_vni=record_coms1.l3_vni and gateway_ip=record_coms1.gateway_ip and ip_len_mask=record_coms1.ip_len_mask) LOOP
		pre_l3vni=record_coms2.l3_vni;
		pre_pathid=record_coms2.path_id;
		pre_prefix=record_coms2.ip_prefix;
		pre_mask=record_coms2.ip_len_mask;
	  end loop;
	  insert into tab_dcn_ovs_temp_ip_prefix_route_info select router_id,path_id,l3_rd,tag_id,ip_len_mask,ip_prefix,l3_vni,vtep_ip,l3_rt,l3_vni_mac,tunnel_type,route_type,nexthop_vni,gateway_ip,gateway_mac,nexthop_mac,ne_id,ifindex,group_id from tab_dcn_ovs_ip_prefix_route_info where l3_vni=pre_l3vni and path_id=pre_pathid and ip_prefix=pre_prefix and ip_len_mask=pre_mask;
    end loop;
    return 0;
  end;
$body$ language plpgsql;
ALTER FUNCTION dcn_merge_tab_dcn_ovs_temp_ip_prefix_route_info() OWNER TO ossdbuser;
select dcn_merge_tab_dcn_ovs_temp_ip_prefix_route_info();
drop function if exists dcn_merge_tab_dcn_ovs_temp_ip_prefix_route_info;

delete from tab_dcn_ovs_ip_prefix_route_info;
insert into tab_dcn_ovs_ip_prefix_route_info select router_id,path_id,l3_rd,tag_id,ip_len_mask,ip_prefix,l3_vni,vtep_ip,l3_rt,l3_vni_mac,tunnel_type,route_type,nexthop_vni,gateway_ip,gateway_mac,nexthop_mac,ne_id,ifindex,group_id from tab_dcn_ovs_temp_ip_prefix_route_info;
alter table tab_dcn_ovs_temp_ip_prefix_route_info drop constraint if exists pk_dcn_ovs_temp_ip_prefix_route_info;
drop table if exists tab_dcn_ovs_temp_ip_prefix_route_info;

--prefix pathid cahnge to gatewayip
alter table tab_dcn_ovs_ip_prefix_route_info drop constraint if exists pk_dcn_ovs_ip_prefix_route_info;
alter table tab_dcn_ovs_ip_prefix_route_info add constraint pk_dcn_ovs_ip_prefix_route_info primary key (ip_len_mask,ip_prefix,l3_vni,gateway_ip);
alter table tab_dcn_ovs_ip_prefix_route_info alter path_id drop not null;

drop index if exists idx_dcn_ovs_vm_north_info_neutron_port_id_and_neid;
create index idx_dcn_ovs_vm_north_info_neutron_port_id_and_neid on tab_dcn_ovs_vm_north_info(neutron_port_id,ne_id);
--3.19.10.0.150000_END

--3.19.10.200.1210_BEGIN
create table if not exists tab_dcn_ovs_route_med_info
(
  bgp_south_float_ip character varying(128),
  med bigint
);

alter table tab_dcn_ovs_route_med_info drop constraint if exists pk_tab_dcn_ovs_route_med_info ;
alter table tab_dcn_ovs_route_med_info add constraint pk_tab_dcn_ovs_route_med_info primary key (bgp_south_float_ip);
alter table tab_dcn_ovs_route_med_info owner to ossdbuser;


create table if not exists tab_dcn_ovs_disaster_recovery_port_info
(
  switch boolean not null
);

alter table tab_dcn_ovs_route_med_info owner to ossdbuser;
--3.19.10.200.1210_END
