--3.19.10.200.1050_BEGIN
CREATE OR REPLACE FUNCTION bulk_upgrade_port_ref(_portId text, _appName text, _serviceId text) RETURNS void as $$ 
    begin
		if not exists (select 1 from TAB_BP_IFM_PROVIDER_PORT_REFERENCE where id = _portId || _appName || _serviceId) then 
			insert into TAB_BP_IFM_PROVIDER_PORT_REFERENCE(id,PORTID,APPNAME,SERVICEID,TS) VALUES (_portId || _appName || _serviceId,_portId,_appName,_serviceId,now());
		end if;
    end
$$ language plpgsql strict;
ALTER FUNCTION bulk_upgrade_port_ref(text,text,text) OWNER TO ossdbuser;

select alter_columns('ADD', 'TAB_BP_L2TOPO_LINK_REFERENCE', 'PORTAPPNAME', 'VARCHAR2(64)');

CREATE OR REPLACE FUNCTION bulk_upgrade_link_ref(_linkId text, _appName text, _serviceId text, _leftResourceId text,_leftLtpId text, _leftLtpName text, _rightResourceId text, _rightLtpId text,_rightLtpName text) RETURNS void as $$ 
	declare 
        _appId text :=randUuid();
    begin
		if not exists (select 1 from TAB_BP_L2TOPO_LINK_REFERENCE where id = _linkId || _appName || _serviceId) then 
			insert into TAB_BP_L2TOPO_LINK_REFERENCE(id,LINKID,APPNAME,SERVICEID,LEFTRESOURCEID,LEFTLTPNAME,RIGHTRESOURCEID,RIGHTLTPNAME,TS,PORTAPPNAME) values(_linkId || _appName || _serviceId,_linkId,_appName,_serviceId,_leftResourceId,_leftLtpName,_rightResourceId,_rightLtpName,now(),_appId);
			bulk_upgrade_port_ref(_leftLtpId,_appId,'linkId:' || _linkId);
			bulk_upgrade_port_ref(_rightLtpId,_appId,'linkId:' || _linkId);
		end if;
    end
$$ language plpgsql strict;
ALTER FUNCTION bulk_upgrade_link_ref(text,text,text,text,text,text,text,text,text) OWNER TO ossdbuser;
----3.19.10.200.1050_END

