DECLARE
	v_count int;
	var_parentTable character varying;
	var_subTable character varying;
	var_interfaceName character varying;
	var_parentDoc character varying;
	var_jsdoc character varying;
	temp_record character varying;
	TYPE emp_cur_type IS REF CURSOR;
    emp_cv emp_cur_type;
	sql_stat  character varying(1000);
	sql_judge character varying(1000);
	sql_inster character varying(1000);
BEGIN
	var_parentTable := (select TABLE_NAME from yang_schema where YANG_PATH = 'urn_ietf_params_xml_ns_yang_ietf_interfaces_inventory_cfg_nes_ne_interfaces_interface');
	var_subTable := (select TABLE_NAME from yang_schema where YANG_PATH = 'urn_huawei_params_xml_ns_yang_huawei_interface_interface_augment');
	RAISE NOTICE 'notice: %', var_parentTable;
	RAISE NOTICE 'notice: %', var_subTable;
	sql_stat := 'select jsdoc->>''parentPath'' from '||var_subTable||' where jsdoc->>''parentPath'' like ''%Virtual-if%''';
	OPEN emp_cv FOR sql_stat;
	LOOP
        FETCH emp_cv INTO temp_record;         
			var_parentDoc :=substring(temp_record from 0  for position('interface:2018-11-15' in temp_record));
			RAISE NOTICE 'notice: %', var_parentDoc;
			var_interfaceName :=substring(temp_record from position('Virtual-if' in temp_record));
			var_interfaceName := substring(var_interfaceName from 0 for length(var_interfaceName));
			RAISE NOTICE 'var_interfaceName: %', var_interfaceName;
			sql_judge := 'select count(*) from '||var_parentTable||' where jsdoc->>''name'' like ''%'||var_interfaceName||'%'' and jsdoc->>''parentPath'' like ''%'||var_parentDoc||'%''';
			RAISE NOTICE 'sql_judge: %', sql_judge;
			execute sql_judge into v_count; 
			RAISE NOTICE 'v_count: %', v_count;
			if v_count = 0
			then
				var_jsdoc := '{"name": "'||var_interfaceName||'", "type": "hw-if:virtual-if", "parentPath":"'||var_parentDoc||'interface:2018-11-15"}';
				sql_inster := 'insert into ' ||var_parentTable||'(JSDOC)values('''||var_jsdoc||'''::jsonb)';
				RAISE NOTICE 'inster: %', sql_inster;
				EXECUTE immediate sql_inster;
			end if; 
		EXIT WHEN emp_cv%NOTFOUND;
	END LOOP;
    CLOSE emp_cv;
END;
/