--3.3.10.300.026_BEGIN
select alter_columns('ADD', 'tab_dcn_epg_entity', 'epg_segment_id', 'int');
update tab_dcn_epg_entity e set e.epg_segment_id = f.index from tab_dcn_fabric_service_epg f where e.epg_segment_id is null and e.id = f.id and e.epg_item_type != 3;
update tab_dcn_epg_entity e set e.epg_segment_id = f.index from tab_dcn_fabric_service_epg f where e.epg_segment_id is null and e.epg_item_type = 3 and f.id = e.ext_group_id;

create table if not exists tab_dcn_epg_deployed_member
(
    id                          character varying(255) not null,
    epg_id                      character varying(255) not null,
    type                        character varying(255) not null,
    member                      character varying(255),
    end_port_id                 character varying(255),
    related_id                  character varying(255),
    constraint table_epg_deployed_member_pkey primary key (id),
    constraint table_epg_deployed_member_epg_id_fkey foreign key (epg_id)
    references public.tab_dcn_epg_entity (id) match simple
    on update no action on delete cascade
);
alter table tab_dcn_epg_deployed_member owner to ossdbuser;
select alter_columns('ADD', 'tab_dcn_epg_deployed_member', 'related_id', 'character varying(255)');

delete from tab_dcn_epg_deployed_member d where (select count(*) from tab_dcn_sfc_epg_item i where d.id = i.id and d.epg_id = i.epg_id) > 0;
-- update for extnetwork epg
create or replace function update_extnetwork_epg_deployed_member() returns integer as $body$
declare
    epg_cursor refcursor;
    epg_id varchar;
    item_cidrs text;
    ext_gateway_id varchar;
    members text[];
    member varchar;
begin
    open epg_cursor for execute 'select e.id, m.cidrs, m.ext_gateway_id from tab_dcn_epg_entity e right join tab_dcn_epg_members m on e.id = m.epg_id where e.epg_item_type = 3 and e.is_ext_group = false and (select count(*) from tab_dcn_epg_deployed_member d where d.epg_id = e.id) = 0;';
	loop
		fetch epg_cursor into epg_id, item_cidrs, ext_gateway_id;
		if epg_cursor%found then
            members := cast(item_cidrs as text[]);
            if array_length(members, 1) is null then
                execute immediate format('select service_ip_pool from tab_dcn_external_gateway where id = %L', ext_gateway_id) into item_cidrs;
                members := cast(item_cidrs as text[]);
            end if;
            
            foreach member in array members
            loop
                execute immediate format('insert into tab_dcn_epg_deployed_member(id, epg_id, type, member) values (%L, %L, %L, %L)', randuuid(), epg_id, 'cidr', member);
            end loop;
        end if;
	exit when epg_cursor%notfound;
	end loop;
	close epg_cursor;
    return 0;
end;$body$ language plpgsql;
/
alter function update_extnetwork_epg_deployed_member() owner to ossdbuser;
select update_extnetwork_epg_deployed_member();

-- update for router epg
create or replace function update_router_epg_deployed_member() returns integer as $body$
declare
    epg_cursor refcursor;
    epg_id varchar;
    router_id varchar;
    members text[];
    member varchar;
begin
    open epg_cursor for execute 'select e.id, e.router_id from tab_dcn_epg_entity e right join tab_dcn_epg_members m on e.id = m.epg_id where e.epg_item_type = 0 and e.is_ext_group = false and (select count(*) from tab_dcn_epg_deployed_member d where d.epg_id = e.id) = 0;';
    
	loop
		fetch epg_cursor into epg_id, router_id;
		if epg_cursor%found then
            members := array(select cidr from tab_dcn_gbp_logic_router_subnet where logic_router_id = ''||router_id||'');
            foreach member in array members
            loop
                execute immediate format('insert into tab_dcn_epg_deployed_member(id, epg_id, type, member) values (%L, %L, %L, %L)', randuuid(), epg_id, 'cidr', member);
            end loop;
        end if;
	exit when epg_cursor%notfound;
	end loop;
	close epg_cursor;
    return 0;
end;$body$ language plpgsql;
/
alter function update_router_epg_deployed_member() owner to ossdbuser;
select update_router_epg_deployed_member();

-- update for swtich epg
create or replace function update_switch_epg_deployed_member() returns integer as $body$
declare
    epg_cursor refcursor;
    epg_id varchar;
    epg_item_id varchar;
    members text[];
    member varchar;
begin
    open epg_cursor for execute 'select e.id, m.epg_item_id from tab_dcn_epg_entity e right join tab_dcn_epg_members m on e.id = m.epg_id where e.epg_item_type = 1 and e.is_ext_group = false and (select count(*) from tab_dcn_epg_deployed_member d where d.epg_id = e.id) = 0;';
	loop
		fetch epg_cursor into epg_id, epg_item_id;
		if epg_cursor%found then
            members := array(select cidr from tab_dcn_gbp_logic_router_subnet where logic_switch_id = ''||epg_item_id||'');
            foreach member in array members
            loop
                execute immediate format('insert into tab_dcn_epg_deployed_member(id, epg_id, type, member, related_id) values (%L, %L, %L, %L, %L)', randuuid(), epg_id, 'cidr', member, epg_item_id);
            end loop;
        end if;
	exit when epg_cursor%notfound;
	end loop;
	close epg_cursor;
    return 0;
end;$body$ language plpgsql;
/
alter function update_switch_epg_deployed_member() owner to ossdbuser;
select update_switch_epg_deployed_member();

-- update for subnet epg
create or replace function update_subnet_epg_deployed_member() returns integer as $body$
declare
    epg_cursor refcursor;
    epg_id varchar;
    router_id varchar;
    epg_item_id varchar;
    parent_id varchar;
    item_cidrs text;
    members text[];
    member varchar;
begin
    open epg_cursor for execute 'select e.id, e.router_id, m.epg_item_id, m.parent_id, m.cidrs from tab_dcn_epg_entity e right join tab_dcn_epg_members m on e.id = m.epg_id where e.epg_item_type = 4 and e.is_ext_group = false and (select count(*) from tab_dcn_epg_deployed_member d where d.epg_id = e.id) = 0;';
	loop
		fetch epg_cursor into epg_id, router_id, epg_item_id, parent_id, item_cidrs;
		if epg_cursor%found then
            if epg_item_id = router_id then
                members := cast(item_cidrs as text[]);
                foreach member in array members
                loop
                    execute immediate format('insert into tab_dcn_epg_deployed_member(id, epg_id, type, member, related_id) values (%L, %L, %L, %L, %L)', randuuid(), epg_id, 'cidr', member, router_id);
                end loop;
            else
                members := array(select cidr from tab_dcn_gbp_logic_router_subnet where id = ''||epg_item_id||'');
                foreach member in array members
                loop
                    execute immediate format('insert into tab_dcn_epg_deployed_member(id, epg_id, type, member, related_id) values (%L, %L, %L, %L, %L)', randuuid(), epg_id, 'cidr', member, parent_id);
                end loop;
            end if;
        end if;
	exit when epg_cursor%notfound;
	end loop;
	close epg_cursor;
    return 0;
end;$body$ language plpgsql;
/
alter function update_subnet_epg_deployed_member() owner to ossdbuser;
select update_subnet_epg_deployed_member();

-- update for terminal epg
insert into tab_dcn_epg_deployed_member(id, epg_id, type, member, end_port_id, related_id) select randuuid(), epg_id, 'ip', ip, logic_port_id, switch_id from tab_dcn_sfco_epg_attribute_item where (select count(*) from tab_dcn_epg_deployed_member where tab_dcn_epg_deployed_member.epg_id = tab_dcn_sfco_epg_attribute_item.epg_id) = 0;

create table if not exists tab_dcn_sfc_spec
(
    id                          character varying(255) not null,
    name                        character varying(255) not null,
    spec_num                    integer,
    enable                      boolean,
    constraint tab_dcn_sfc_spec_pkey primary key (id),
    constraint tab_dcn_sfc_spec_name_key unique (name)
);
alter table tab_dcn_sfc_spec owner to ossdbuser;
insert into tab_dcn_sfc_spec (id, name, spec_num, enable) select '958d3ce1-0598-11e9-95e8-00acd5101ae9', 'SFP_SPEC', 20000, true where (select count(*) from tab_dcn_sfc_spec where name = 'SFP_SPEC') = 0;
--3.3.10.300.026_END

--3.3.10.300.065_BEGIN
select alter_columns('ALTER','tab_dcn_sfc_secom_nonat','src_cidrs','text');
select alter_columns('ALTER','tab_dcn_sfc_secom_nonat','dest_cidrs','text');
--3.3.10.300.065_END


--3.19.0.0.030_BEGIN
select alter_columns('ADD', 'tab_dcn_epg_entity', 'mode', 'int');
update tab_dcn_epg_entity set mode = 0 where epg_item_type = 3 and is_ext_group = false and ext_group_id is not null;
update tab_dcn_epg_entity a set a.mode = b.mode from tab_dcn_sfc_epg b where a.mode is null and a.id = b.id;

select alter_columns('ADD', 'tab_dcn_sfc_forward_connector', 'ip_family', 'int');
update tab_dcn_sfc_forward_connector set ip_family = 1 where ip_family = null;

select alter_columns('ADD', 'tab_dcn_sfc_forward_connector_detail', 'ip_family', 'int');
update tab_dcn_sfc_forward_connector_detail set ip_family = 1 where ip_family = null;

alter table tab_dcn_sfc_forward_connector_detail alter column src_ip type character varying(255);
alter table tab_dcn_sfc_forward_connector_detail alter column dst_ip type character varying(255);
--3.19.0.0.030_END

--3.19.0.0.087_BEGIN
create table if not exists tab_dcn_fabric_service_node_acl_rule
(
	id uuid not null,
	acl_name nvarchar2(128) not null,
	rule_id integer,
	rule_name nvarchar2(128),
	node_id uuid not null,
	protocol integer,
	source_ip_address nvarchar2(128),
	destination_ip_address nvarchar2(128),
	source_port_start integer,
	source_port_end integer,
	destination_port_start integer,
	destination_port_end integer,
	icmp_code integer,
	icmp_type integer,
	tcp_flag integer,
	tcp_established boolean,
	logging boolean,
	create_time timestamp default current_timestamp,
	constraint pk_dcn_fabric_service_node_acl_rule primary key (id)
);
alter table tab_dcn_fabric_service_node_acl_rule OWNER TO ossdbuser;
--3.19.0.0.087_END

--3.19.0.100.025_BEGIN
select alter_columns('ALTER','tab_dcn_sfc_forward_connector_detail','SRC_PORT','character varying(16)');
select alter_columns('ALTER','tab_dcn_sfc_forward_connector_detail','DST_PORT','character varying(16)');
-- ԭtab_dcn_sfc_forward_connector_detail洢portϢҪtab_dcn_fabric_service_pbrquintetˢportֶ
CREATE OR REPLACE FUNCTION func_update_forward_port_info() RETURNS INTEGER AS $body$
DECLARE
  SOURCE_PORT_START integer;
  SOURCE_PORT_END integer;
  DESTINATION_PORT_START integer;
  DESTINATION_PORT_END integer;
  SRC_PORT_RESULT varchar2;
  DST_PORT_RESULT varchar2;
BEGIN

	FOR cnn_detail IN select * from tab_dcn_sfc_forward_connector_detail where SRC_PORT is not null or DST_PORT is not null LOOP
		EXECUTE IMMEDIATE 'select SOURCE_PORT_START, SOURCE_PORT_END, DESTINATION_PORT_START, DESTINATION_PORT_END from tab_dcn_fabric_service_pbrquintet where id = '''|| cnn_detail.QUINTET_ID ||''' ' into SOURCE_PORT_START, SOURCE_PORT_END, DESTINATION_PORT_START, DESTINATION_PORT_END;
		SRC_PORT_RESULT := null;
		DST_PORT_RESULT := null;

		if SOURCE_PORT_START and SOURCE_PORT_END IS NOT NULL THEN
		  SRC_PORT_RESULT := SOURCE_PORT_START||':'||SOURCE_PORT_END;
		END if;
		if DESTINATION_PORT_START and DESTINATION_PORT_END IS NOT NULL THEN
		  DST_PORT_RESULT := DESTINATION_PORT_START||':'||DESTINATION_PORT_END;
		END if;

		UPDATE tab_dcn_sfc_forward_connector_detail SET SRC_PORT = SRC_PORT_RESULT, DST_PORT = DST_PORT_RESULT WHERE QUINTET_ID = cnn_detail.QUINTET_ID;
	END LOOP;

	RETURN 0;

END;
$body$ language plpgsql;
/
ALTER FUNCTION func_update_forward_port_info() OWNER TO ossdbuser;
select func_update_forward_port_info();
drop function if exists func_update_forward_port_info;

SELECT alter_columns('ADD', 'tab_dcn_fabric_manage_nodepbr', 'precedence', 'integer');
--3.19.0.100.025_END

--3.19.0.100.070_BEGIN

CREATE TABLE IF NOT EXISTS public.tab_dcn_sfco_spec( 
   id nvarchar2(128) not null,
   name nvarchar2(128) not null,                  
   spec int not null,
   description nvarchar2(256),
   CONSTRAINT pk_dcn_sfco_spec PRIMARY KEY (id)
);
ALTER TABLE public.tab_dcn_sfco_spec OWNER TO ossdbuser;

delete from tab_dcn_sfco_spec; 
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000001', 'MAX_LOGIC_VAS_TOTAL_NUM', 30000, 'max num logic vas can create');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000002', 'MAX_ADD_DELETE_FLOW_RULE_NUM', 256, 'max rule num when create or delete flow rule');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000003', 'MAX_EXTERNAL_LINK_NUM_VAS_CANNOT_DELETE', 10, 'need to delele external link first when number more than 10');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000004', 'MAX_EPG_TERMINAL_ATTR_MEMBER_NUM', 1000, 'max num epg terminal member ip');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000005', 'MAX_EPG_TERMINAL_ATTR_HOST_NUM', 16, 'max num epg terminal host rule');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000006', 'MAX_EPG_TERMINAL_ATTR_MAC_NUM', 32, 'max num epg terminal mac rule');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000007', 'MAX_EPG_TERMINAL_ATTR_VM_NUM', 32, 'max num epg terminal rule rule');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000008', 'MAX_EPG_TENANT_TOTAL_NUM', 4000, 'max num epg in one tenant');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000009', 'MAX_EPG_TOTAL_NUM', 48000, 'max num epg');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000010', 'MAX_SINGLE_EPG_MEMBER_NUM', 1000, 'max num member in one epg');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000011', 'MAX_SFT_TOTAL_NUM', 32, 'max num sft');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000012', 'MAX_CONTRACT_RULE_NUM', 512, 'max num contract rule');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000013', 'MAX_CONTRACT_TOTAL_NUM', 48000, 'max num contract');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000014', 'MAX_SFCAPP_TOTAL_NUM', 20000, 'max num sfcapp');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000015', 'MAX_SFC_TEMPLATE_TOTAL_NUM', 1000, 'max num sfc template');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000016', 'MAX_L3_DCI_MODIFY_SUBNET_NUM', 150, 'max num L3 dci modify subnet');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000017', 'MAX_L3_DCI_SUBNET_TOTAL_NUM', 2000, 'max total num L3 dci subnet');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000018', 'MAX_L3_DCI_TOTAL_NUM', 4000, 'max num L3 dci');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000019', 'MAX_VPC_CONNECT_MODIFY_SUBNET_NUM', 150, 'max num vpc connect modify subnet');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000020', 'MAX_VPC_CONNECT_TOTAL_NUM', 4000, 'max num vpc connect');
--3.19.0.100.070_END

--3.19.10.0.050_BEGIN
select alter_columns('ADD', 'tab_dcn_fabric_service_pbr', 'backup_si', 'int');
select alter_columns('ADD', 'tab_dcn_fabric_service_pbr', 'extra_pbr_for_bypass', 'boolean default false');

select alter_columns('ADD', 'tab_dcn_sfc_forward_connector', 'backup_si', 'nvarchar2(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sf_locator', 'share_ip', 'nvarchar2(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sf_locator', 'share_ipv6', 'nvarchar2(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sf_locator', 'fail_mode_type', 'nvarchar2(64)');

select alter_columns('ADD', 'tab_dcn_sfco_sfcapp_r_vas', 'fail_mode', 'nvarchar2(64)');
select alter_columns('ADD', 'tab_dcn_sfco_sfcapp_r_vas', 'ipv4_track_nqa_status', 'nvarchar2(64)');
select alter_columns('ADD', 'tab_dcn_sfco_sfcapp_r_vas', 'ipv6_track_nqa_status', 'nvarchar2(64)');

create table if not exists tab_dcn_sfc_forward_connector_extra (
	id						character varying(255) not null,
	ingress_port_id			character varying(255),
	spi						integer,
	si						integer,
	backup_si				integer,
	next_hop				character varying(255),
	tenant_id				character varying(255),
	host_connector_id		character varying(255),
	acl_addr_family			character varying(64),
	action					character varying(64),
	encapsulation			character varying(64),
	constraint tab_dcn_sfc_forward_connector_extra_pkey primary key (id)
);
alter table tab_dcn_sfc_forward_connector_extra OWNER TO ossdbuser;

create table if not exists tab_dcn_sfco_sfcapp_vas_share_ip (
	id						character varying(255) not null,
	sfcapp_id				character varying(255),
	router_id				character varying(255),
	vas_id					character varying(255),
	vas_ip					character varying(255),
	vas_ipv6				character varying(255),
	share_ip				character varying(255),
	share_ipv6				character varying(255),
	constraint tab_dcn_sfco_sfcapp_vas_share_ip_pkey primary key (id)
);
alter table tab_dcn_sfco_sfcapp_vas_share_ip OWNER TO ossdbuser;

select alter_columns('ADD', 'tab_dcn_sfc_scpolicy_classification', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_service_epg_param', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_service_ipepg_param', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_service_microseg', 'is_extra_item', 'boolean default false');
select alter_columns('ADD', 'tab_dcn_fabric_manage_nodeipsegment', 'is_extra_item', 'boolean default false');
update tab_dcn_sfc_scpolicy_classification set is_extra_item = false;
update tab_dcn_fabric_service_epg_param set is_extra_item = false;
update tab_dcn_fabric_service_ipepg_param set is_extra_item = false;
update tab_dcn_fabric_service_microseg set is_extra_item = false;
update tab_dcn_fabric_manage_nodeipsegment set is_extra_item = false;
CREATE OR REPLACE FUNCTION func_upgrade_contract_rule() RETURNS INTEGER AS $body$
DECLARE
	v_cnt int;
	v_mode int;
BEGIN
    FOR record_coms IN select contract_id, tenant_id from tab_dcn_sfco_contract LOOP
		if trim(record_coms.tenant_id) is null or record_coms.tenant_id = '00000000-0000-0000-0000-000000000000' then
			EXECUTE IMMEDIATE 'select count(distinct(e.mode)) from tab_dcn_epg_entity e where e.id in (select s.src_epg from tab_dcn_sfco_sfcapp s where s.contract_id = '''||record_coms.contract_id||''') and e.mode is not null' into v_cnt;
			if v_cnt = 1 then 
				EXECUTE IMMEDIATE 'select distinct(e.mode) from tab_dcn_epg_entity e where e.id in (select s.src_epg from tab_dcn_sfco_sfcapp s where s.contract_id = '''||record_coms.contract_id||''') and e.mode is not null' into v_mode;
				if v_mode = 0 then
					update tab_dcn_sfco_contract_rule set ip_type = 'any' where contract_id = record_coms.contract_id;
				end if;
			end if;
		else
			EXECUTE IMMEDIATE 'select count(distinct(mode)) from tab_dcn_epg_entity where tenant_id = '''||record_coms.tenant_id||''' and mode is not null' into v_cnt;
			if v_cnt = 1 then 
				EXECUTE IMMEDIATE 'select distinct(mode) from tab_dcn_epg_entity where tenant_id = '''||record_coms.tenant_id||''' and mode is not null' into v_mode;
				if v_mode = 0 then
					update tab_dcn_sfco_contract_rule set ip_type = 'any' where contract_id = record_coms.contract_id;
				end if;
			end if;
		end if;
    END LOOP; 
    RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION func_upgrade_contract_rule() OWNER TO ossdbuser;
select func_upgrade_contract_rule();
drop function if exists func_upgrade_contract_rule;
--3.19.10.0.050_END

--3.19.10.0.056_BEGIN
select alter_columns('ADD', 'tab_dcn_sfc_rsp_detail', 'fail_mode', 'nvarchar2(64)');

select alter_columns('ADD', 'tab_dcn_sfc_sfp_detail', 'sfg_name', 'character varying(255)');
select alter_columns('ADD', 'tab_dcn_sfc_sfp_detail', 'fail_mode', 'nvarchar2(64)');

create table if not exists tab_dcn_sfc_sfg ( 
    sfg_name character varying(255) not null,
	sf_names character varying[],
    share_ip character varying(255),
    share_ipv6 character varying(255),
	tenant_id character varying(255),
	algorithm character varying(255),
    nsh_aware boolean not null,
	constraint pk_dcn_sfc_sfg primary key (sfg_name)
);
alter table tab_dcn_sfc_sfg OWNER TO ossdbuser;
--3.19.10.0.056_END

--3.19.10.0.106000_BEGIN
select alter_columns('ADD', 'tab_dcn_sfc_forward_connector_extra', 'egress_port_id', 'character varying(255)');
--3.19.10.0.106000_END

--3.19.10.100.003000_BEGIN
CREATE TABLE IF NOT EXISTS public.tab_dcn_sfc_configuration( 
   key nvarchar2(128) not null,
   value nvarchar2(128),
   CONSTRAINT pk_dcn_sfc_configuration PRIMARY KEY (key)
);
ALTER TABLE public.tab_dcn_sfc_configuration OWNER TO ossdbuser;
insert into tab_dcn_sfc_configuration(key, value) select 'is-micro-segment-new-model','true' where not exists (select * from tab_dcn_sfc_configuration where key = 'is-micro-segment-new-model');
--3.19.10.100.003000_END

--3.19.10.100.0500_BEGIN
select alter_columns('ADD', 'tab_dcn_sfc_forward_connector_extra', 'si_is_final', 'boolean default false');
--3.19.10.100.0500_END

--3.20.0.0.0100_BEGIN
select alter_columns('ADD', 'tab_dcn_sfco_epg_attribute_item', 'vm_tags', 'character varying(255)[]');
insert into tab_dcn_sfco_spec values('70000000-0000-0000-0000-000000000021', 'MAX_EPG_TERMINAL_ATTR_TAG_NUM', 32, 'max num epg terminal tag rule');
--3.20.0.0.0100_END

select alter_columns('RENAME','TAB_DCN_FABRIC_SERVICE_IPEPG','INDEX','EPG_INDEX');
select alter_columns('RENAME','TAB_DCN_FABRIC_SERVICE_EPG','INDEX','EPG_INDEX');

select alter_columns('RENAME','tab_dcn_fabric_manage_nodeipsegment','INDEX','IPSEGMENT_INDEX');
select alter_columns('RENAME','tab_dcn_fabric_manage_classifier_rule','INDEX','RULE_INDEX');

select alter_columns('ADD', 'tab_dcn_fabric_service_pbrquintet', 'rule_order', 'int');
CREATE OR REPLACE FUNCTION func_set_rule_order() RETURNS INTEGER AS $body$
DECLARE
	scp_name nvarchar2(36);
	pbr_ nvarchar2(36);
BEGIN
    FOR record_coms IN select distinct(pbr_id) from tab_dcn_fabric_service_pbrquintet LOOP
		if (select count(*) from tab_dcn_sfc_forward_connector where CONNECTOR_ID = record_coms.pbr_id) > 0 then
			EXECUTE IMMEDIATE 'select substr(RSP_NAME, 0, 36) from tab_dcn_sfc_forward_connector where CONNECTOR_ID = '''||record_coms.pbr_id||'''' into scp_name;
			if (select count(*) from tab_dcn_sfc_scf where scf_name = scp_name) > 0 then 
				EXECUTE IMMEDIATE 'select scpolicy_name from tab_dcn_sfc_scf where scf_name = '''||scp_name||'''' into scp_name;
			end if;
			FOR record_rules IN select _PROTOCOL, SRC_IPV4_NETWORK, DEST_IPV4_NETWORK, SRC_IPV6_NETWORK, DEST_IPV6_NETWORK, SRC_MIN_PORT, SRC_MAX_PORT, DEST_MIN_PORT, DEST_MAX_PORT, _ORDER from tab_dcn_sfc_scpolicy_classification where SC_POLICY_NAME = scp_name LOOP
				update tab_dcn_fabric_service_pbrquintet set RULE_ORDER = record_rules._ORDER where PBR_ID = record_coms.pbr_id and PROTOCOL = record_rules._PROTOCOL and (SOURCE_PORT_START = record_rules.SRC_MIN_PORT or (SOURCE_PORT_START is null and record_rules.SRC_MIN_PORT is null)) and (SOURCE_PORT_END = record_rules.SRC_MAX_PORT or (SOURCE_PORT_END is null and record_rules.SRC_MAX_PORT is null)) and (DESTINATION_PORT_START = record_rules.DEST_MIN_PORT or (DESTINATION_PORT_START is null and record_rules.DEST_MIN_PORT is null)) and (DESTINATION_PORT_END = record_rules.DEST_MAX_PORT or (DESTINATION_PORT_END is null and record_rules.DEST_MAX_PORT is null)) and ((SOURCE_IP_ADDRESS = record_rules.SRC_IPV4_NETWORK and DESTINATION_IP_ADDRESS = record_rules.DEST_IPV4_NETWORK) or (SOURCE_IP_ADDRESS = record_rules.SRC_IPV6_NETWORK and DESTINATION_IP_ADDRESS = record_rules.DEST_IPV6_NETWORK));
			END LOOP; 
		end if;
    END LOOP; 
    RETURN 0;
END;
$body$ language plpgsql;
/
ALTER FUNCTION func_set_rule_order() OWNER TO ossdbuser;
select func_set_rule_order();
drop function if exists func_set_rule_order;