#!/bin/bash

CUR_PATH=$(cd "$(dirname "$0")"; pwd)
export APP_NAME=AuthService
export _APP_LOG_DIR=$CUR_PATH/logs

script_name=`basename $0`

SQL_USER_NAME=dbuser
source_db_instance_name=ncecommondb
source_db_name=authadmindb


migrate_log()
{
    local content=$*
    
    log_filename="$_APP_LOG_DIR/authService_post.log"
    
    CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
    echo "$CURTIME $$ $script_name : $content" | tee -a $log_filename
}

get_dbip_port() {
    #IP查询：先按照master的去过滤，如果没有则去掉master过滤条件，再查一遍
    dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type zenith|grep -E "ncecommondb"|grep Master`

    if [ -z "$dbinfo" ]
    then
        migrate_log "$LINENO single db instance"
        dbinfo=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type zenith|grep -E "ncecommondb"`
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=''
    else
        MACHINE_IP=`echo $dbinfo|awk '{print $6}'`
        port=`echo $dbinfo|awk '{print $7}'`
        db_master_name=`echo $dbinfo|awk '{print $3}'`
        db_slave_name=`/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance -type zenith|grep -E "ncecommondb"|grep Slave|awk '{print $3}'`
    fi
}


main(){

    echo $TENANTS_ROOT
    #1. 获取数据库的ip和port
    get_dbip_port
    migrate_log "$LINENO DB:$db_master_name ip: $MACHINE_IP status:$?"
    migrate_log "$LINENO DB port: $port"


    # get db info
    db_info=`. /opt/oss/manager/agent/bin/engr_profile.sh;python -c "import sys;sys.path.append('${CUR_PATH}/../../pyscripts/');import get_db_pass;pec=get_db_pass.epc;fmt='';pec1=pec.getLogger('db_info');pec_s=pec.StreamHandler();pec_s.setFormatter(fmt);pec1.addHandler(pec_s);pec1.critical(get_db_pass.main('${source_db_instance_name}', '${source_db_name}', 'zenith'))" 2>&1`
    result=$?
    if [[ "${result}" == "0" ]]
    then
        echo `date '+%Y-%m-%d %H:%M:%S'` [INFO] "get db_info successfully."
        result_array=(${db_info//,/ })
        adminPP=${result_array[2]}
    else
        echo `date '+%Y-%m-%d %H:%M:%S'` [ERROR] "get db_info failed."
        exit 1
    fi

    if [ -z "$adminPP" ]
    then
        migrate_log "$LINENO acquire DB passwd failed,exit"
        exit 1
    else
        migrate_log "$LINENO acquire DB passwd success"
    fi
    #3.拷贝sql
    SNB_TMP_DIR=/home/dbuser/post_bgp_auth
    if [ -d $SNB_TMP_DIR ]
    then 
        rm -rf $SNB_TMP_DIR/*
    fi
    sudo -s -u dbuser<<EOF
        SNB_TMP_DIR=/home/dbuser/post_bgp_auth
        if [ -d $SNB_TMP_DIR ]
        then
            rm -r $SNB_TMP_DIR
        fi
        mkdir -p $SNB_TMP_DIR
        echo "create SNB_TMP_DIR success"
        chmod 777 $SNB_TMP_DIR
EOF
    cp -rf $CUR_PATH/authadmindb.sql $SNB_TMP_DIR
	cp -rf $CUR_PATH/authadmindb_del_bgp.sql $SNB_TMP_DIR
    #4. 执行sql脚本
    sudo -s -u dbuser<<EOF
    export LD_LIBRARY_PATH=/opt/zenith/app/add-ons:/opt/zenith/app/lib:/opt/oss/envs/DBAgent/service/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_mysql/pyscript/mysql:/opt/oss/manager/agent/DeployAgent/dbdriver_gauss/pyscript/gauss:/opt/oss/manager/agent/DeployAgent/rtsp/python/lib:/usr/local/lib:/usr/lib:/lib
    export PATH=/opt/zenith/app/bin:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/osconfig/os/bin:/opt/oss/manager/agent/DeployAgent/rtsp/python/bin:/usr/local/bin:/usr/bin:/bin:/opt/oss/manager/agent/DeployAgent/bin:/opt/oss/manager/bin:/sbin:/usr/local/sbin:/usr/sbin:/home/ossadm/.local/bin:/home/ossadm/bin
    export GSDB_HOME=/opt/zenith/app
    /opt/zenith/app/bin/zsql $source_db_instance_name/${adminPP}@${MACHINE_IP}:${port} -c "update T_AUTH_USER set XUSER_TYPE = 'BOTH' where XUSER_TYPE = 'LOCAL';UPDATE T_AUTH_PROJECT_EX SET SOURCE='all', GROUP_ID='2' WHERE ID='01c6687e-82ea-4560-9162-878c8d2541f1';UPDATE T_AUTH_USER_EX SET VALUE_STR = '(UTC+08:00)Asia/Hong_Kong' WHERE TYPE = 'TimeInfo_TimeZone' AND VALUE_STR = '(UTC+08:00)Asia/Hong_Kong,China';UPDATE T_AUTH_USER_EX SET VALUE_STR = '(UTC+08:00)Asia/Macau' WHERE TYPE = 'TimeInfo_TimeZone' AND VALUE_STR = '(UTC+08:00)Asia/Macau,China';UPDATE T_AUTH_USER_EX SET VALUE_STR = '(UTC+08:00)Asia/Taipei' WHERE TYPE = 'TimeInfo_TimeZone' AND VALUE_STR = '(UTC+08:00)Asia/Taipei,China';"
    echo "$LINENO export_authservice status: $?"

EOF
    #判断是否为BGP场景
    if [ -f $CUR_PATH/bgp_ip.txt ]
    then
        rm -rf $CUR_PATH/bgp_ip.txt
    fi
    /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global | grep BgpService >> bgp_ip.txt
    if [ ! -s bgp_ip.txt ]
    then
        echo "no bgp environment"
        sudo -s -u dbuser<<EOF
        export LD_LIBRARY_PATH=/opt/zenith/app/add-ons:/opt/zenith/app/lib:/opt/oss/envs/DBAgent/service/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_mysql/pyscript/mysql:/opt/oss/manager/agent/DeployAgent/dbdriver_gauss/pyscript/gauss:/opt/oss/manager/agent/DeployAgent/rtsp/python/lib:/usr/local/lib:/usr/lib:/lib
        export PATH=/opt/zenith/app/bin:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/osconfig/os/bin:/opt/oss/manager/agent/DeployAgent/rtsp/python/bin:/usr/local/bin:/usr/bin:/bin:/opt/oss/manager/agent/DeployAgent/bin:/opt/oss/manager/bin:/sbin:/usr/local/sbin:/usr/sbin:/home/ossadm/.local/bin:/home/ossadm/bin
        export GSDB_HOME=/opt/zenith/app
        /opt/zenith/app/bin/zsql $source_db_instance_name/${adminPP}@${MACHINE_IP}:${port} -f $SNB_TMP_DIR/authadmindb_del_bgp.sql
        echo "$LINENO export_authservice status: $?"
EOF
    else
        echo "bgp environment"
        sudo -s -u dbuser<<EOF
        export LD_LIBRARY_PATH=/opt/zenith/app/add-ons:/opt/zenith/app/lib:/opt/oss/envs/DBAgent/service/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_zenith/pyscript/zenith:/opt/oss/manager/agent/DeployAgent/dbdriver_mysql/pyscript/mysql:/opt/oss/manager/agent/DeployAgent/dbdriver_gauss/pyscript/gauss:/opt/oss/manager/agent/DeployAgent/rtsp/python/lib:/usr/local/lib:/usr/lib:/lib
        export PATH=/opt/zenith/app/bin:/sbin:/usr/sbin:/bin:/usr/bin:/usr/local/osconfig/os/bin:/opt/oss/manager/agent/DeployAgent/rtsp/python/bin:/usr/local/bin:/usr/bin:/bin:/opt/oss/manager/agent/DeployAgent/bin:/opt/oss/manager/bin:/sbin:/usr/local/sbin:/usr/sbin:/home/ossadm/.local/bin:/home/ossadm/bin
        export GSDB_HOME=/opt/zenith/app
        /opt/zenith/app/bin/zsql $source_db_instance_name/${adminPP}@${MACHINE_IP}:${port} -f $SNB_TMP_DIR/authadmindb.sql
        echo "$LINENO export_authservice status: $?"
EOF
    fi
   
    #5. 后置处理：清理中间文件等
    rm -rf $SNB_TMP_DIR/authadmindb.sql
    sudo -u dbuser rm -rf $SNB_TMP_DIR
    migrate_log "$LINENO migrate authservice success and end"
}

main

