#!/bin/bash

CUR_PATH=$(cd "$(dirname "$0")"; pwd)

if [ -f "/opt/oss/manager/var/tenants/NCECOMMONE/containerlist.json" ]
then  
     export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCECOMMONE
elif [ -f  "/opt/oss/manager/var/tenants/NCECAMPUS/containerlist.json" ]
then
    export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCECAMPUS
else
     export TENANTS_ROOT=/opt/oss/manager/var/tenants/NCE
fi

export OSS_ROOT=/opt/oss/manager
export APP_NAME=AuthService

export _APP_LOG_DIR=$CUR_PATH/logs
if [ ! -d $_APP_LOG_DIR ]
then
    mkdir -p $_APP_LOG_DIR
    chmod 755 $_APP_LOG_DIR
fi

if [ ! -f $_APP_LOG_DIR/authService_post.log ]
then
    touch $_APP_LOG_DIR/authService_post.log
else
    echo >> $_APP_LOG_DIR/authService_post.log #һָ
fi

CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
echo "$CURTIME migrate authservice post begin" | tee -a $_APP_LOG_DIR/authService_post.log
sh $CUR_PATH/migrate_authService.sh >> $_APP_LOG_DIR/authService_post.log 2>&1
result=$?

unset TENANTS_ROOT
unset OSS_ROOT
unset APP_NAME

CURTIME=`date '+%Y-%m-%d %H:%M:%S'`
if [ $result -eq 0 ]
then
    echo "$CURTIME migrate authservice post successfully." | tee -a $_APP_LOG_DIR/authService_post.log
    echo 0 > $CUR_PATH/post_upgrade_AuthService.result
else
    echo "$CURTIME migrate authservice post exec failed,Please see the authService_post.log" | tee -a $_APP_LOG_DIR/authService_post.log
    unset _APP_LOG_DIR
    echo 1 > $CUR_PATH/post_upgrade_AuthService.result
    exit 1
fi

unset _APP_LOG_DIR

