# coding=utf-8
'''
modify_bgp_nic_usage
'''
import os
import sys
import json
import time
import subprocess
import get_ip_by_num
from utils import set_log
from utils import utils

ACTION = sys.argv[1]
QUERY_PROTCUCT_DIR = sys.argv[2]
TENANT_NAME = sys.argv[3]
NETCARD_INFO_DIR = sys.argv[4]
IPS = sys.argv[5]

NETWORK_JSON_FILE = os.path.join(QUERY_PROTCUCT_DIR, "networkinfo_%s.json" % TENANT_NAME)
PRODUCT_JSON_FILE = os.path.join(QUERY_PROTCUCT_DIR, "product_%s.json" % TENANT_NAME)
NETCARD_JSON_FILE = os.path.join(QUERY_PROTCUCT_DIR, "netcard_info.json")

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1
SLAVE_IP = get_ip_by_num.get_ip('1')


def read_product_info():
    '''
    获取信息 是否安装bgp，IPV4的bgp信息，IPV6的bgp信息，bgp网卡，是否IPV6
    :return:
    '''
    LOG.info("start read %s", PRODUCT_JSON_FILE)
    with open(PRODUCT_JSON_FILE, "rb") as _f:
        product_json = json.load(_f)
    features = product_json["productext"].get("features", "")
    is_install_bgp = "bgp_feature" in features
    bgp_south_float_ip = product_json["productext"].get("BGP_SOUTH_FLOAT_IP", "none")
    south_float_ip_v6 = product_json["productext"].get("SOUTH_FLOAT_IP_V6", "none")
    bgp_south_netcard = product_json["productext"].get("BGP_SOUTH_NETCARD", "")
    south_interface = product_json["productext"].get("SouthInterface", "none")
    if ":" in bgp_south_float_ip or ":" in south_float_ip_v6:
        is_ipv6 = True
    else:
        is_ipv6 = False
    LOG.info("is_install_bgp: %s, bgp_south_float_ip: %s, south_float_ip_v6: %s, "
             "bgp_south_netcard: %s, is_ipv6: %s, south_interface: %s"
             , is_install_bgp, bgp_south_float_ip, south_float_ip_v6, bgp_south_netcard, is_ipv6, south_interface)
    return is_install_bgp, bgp_south_float_ip, south_float_ip_v6, bgp_south_netcard, is_ipv6, south_interface


def get_mask_and_ip_by_netcard(bgp_south_netcard, is_ipv6, file_name):
    '''
    :param bgp_south_netcard:
    :param is_ipv6:
    :return:
    '''
    all_floating_ip = get_all_floating_ip()
    LOG.info("start read %s", file_name)
    netmask = ""
    nic_ip = ""
    with open(file_name, "rb") as _f:
        netcard_json = json.load(_f)
        ip_list = netcard_json.get("iplist", [])
    for ip_info in ip_list:
        if bgp_south_netcard == ip_info["nic"]:
            if is_ipv6:
                key_list = "ipv6list"
                key_net_mask = "prefix"
                key_ip = "ipv6"
            else:
                key_list = "iplist"
                key_net_mask = "netmask"
                key_ip = "ip"
            for ip_info2 in ip_info[key_list]:
                nic_ip = ip_info2[key_ip]
                if nic_ip not in all_floating_ip:
                    netmask = ip_info2[key_net_mask]
                    break
            break
    LOG.info("netmask: %s", netmask)
    return netmask, nic_ip


def get_all_floating_ip():
    '''
    获取所有浮动IP
    :return:
    '''
    all_floating_ip = []
    with open(NETWORK_JSON_FILE, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("floatingip", [])
    for info in network_json_list:
        all_floating_ip.append(info["floatingip"])
    LOG.info("all_floating_ip: %s", ",".join(all_floating_ip))
    return all_floating_ip


def main():
    '''
    主函数
    :return:
    '''
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    result = SUCCESS
    is_install_bgp, bgp_south_float_ip, south_float_ip_v6, bgp_south_netcard, is_ipv6, _ = read_product_info()
    netmask, _ = get_mask_and_ip_by_netcard(bgp_south_netcard, is_ipv6, NETCARD_JSON_FILE)
    if not netmask:
        LOG.info("netmask is empty")
        sys.exit(1)
    need_add_float_ip = True
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/IP"
    input_param = {"actionkey": "modifyFloatingIP", "startProduct": "false", "datalist": []}
    with open(NETWORK_JSON_FILE, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("floatingip", [])
    for float_ip_data in network_json_list:
        usages_str = float_ip_data.get("usage")
        if "BGP_FLOATIP" in usages_str:
            LOG.info("need change bgp_float_ip")
            need_add_float_ip = False
            for bgp_float_ip_data in float_ip_data.get("nodelist"):
                nic = bgp_float_ip_data["networkinfo"]["nic"]
                mgrip = bgp_float_ip_data["nodemgrip"]
                old_usage = float_ip_data.get("usage")
                new_usage = usages_str.replace("BGP_FLOATIP", "BGPSouthBound")
                input_param["datalist"].append({
                    "oldnodemgrip": mgrip,
                    "newnodemgrip": mgrip,
                    "networkinfo": json.dumps([{
                        "nic": nic,
                        "oldip": float_ip_data["floatingip"],
                        "newip": float_ip_data["floatingip"],
                        "oldnetmask": float_ip_data["netmask"],
                        "newnetmask": float_ip_data["netmask"],
                        "oldusage": old_usage,
                        "newusage": new_usage + ":LOCALHA"
                    }])
                })

    if need_add_float_ip and is_install_bgp:
        LOG.info("need add bgp_float_ip")
        if is_ipv6:
            bgp_float_ip = south_float_ip_v6
            nic = bgp_south_netcard
            bound = "BGPSouthBound2"
        else:
            bgp_float_ip = bgp_south_float_ip
            nic = "%s:3" % bgp_south_netcard
            bound = "BGPSouthBound"
        omp_ip = get_ip_by_num.get_ip('0')
        service_ip = get_ip_by_num.get_ip('2')
        for node_ip in [omp_ip, service_ip]:
            if node_ip:
                input_param["datalist"].append({
                    "oldnodemgrip": node_ip,
                    "newnodemgrip": node_ip,
                    "networkinfo": json.dumps([{
                        "nic": nic,
                        "oldip": "",
                        "newip": bgp_float_ip,
                        "oldnetmask": "",
                        "newnetmask": netmask,
                        "oldusage": "",
                        "newusage": "FLOATINGIP:%s:LOCALHA" % bound
                    }])
                })

    LOG.info(input_param)
    task_id = None
    for _ in range(30):
        result, result_info = utils.send_rest(_ip, port, url, mode="POST",
                                              log=LOG, body=input_param, sleep=6, retry_times=0,
                                              content="add bgp float ip")
        LOG.info(json.loads(result_info))
        if result == 0:
            task_id = json.loads(result_info).get("taskid")
            if task_id is not None:
                LOG.info("create task success, task id is %s", task_id)
                break
            time.sleep(6)

    if task_id is not None and task_id != "":
        if not query_task_res(url, task_id):
            LOG.info("execute timeout.")
            sys.exit(1)
    else:
        LOG.info("execute failed.")
        sys.exit(1)

    return result


def query_task_res(url, task_id, retry_times=180):
    '''
    查询任务进度
    :param url: 任务链接
    :param task_id: 任务ID
    :param retry_times: 重试次数，默认180次, 30min
    :return:
    '''
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    input_param = {"actionkey": "queryProgress", "datalist": [{"taskid": task_id}]}
    idx = 0
    while idx < retry_times:
        result, progress = utils.send_rest(_ip, port, url, mode="POST",
                                    log=LOG, body=input_param, sleep=0, retry_times=0,
                                    content="Check process")
        LOG.info("progress: %s, retry_times: %s", progress, idx)
        if result == 0:
            if json.loads(progress).get("progress") == 100:
                return True
        idx += 1
        time.sleep(10)
    return False


def main_add_nic():
    '''
    增加网口信息
    1、ssh到各个节点，调用欧方查询网卡信息，scp其余节点文件到本节点(shell脚本中完成)
    2、查询出bgp的信息（bgp浮动ip, bgp所在网卡，是否IPV6）
    3、根据查询出来的bgp所在网卡，查询出各个节点对应网卡的IP 和 掩码
    4、拼接参数，调用管理面接口添加网卡, IR接口
    '''
    LOG.info("start add nic")
    _ip = utils.get_local_ip()
    port = utils.get_gmt_port()
    result = SUCCESS
    # 获取bgp的信息
    is_install_bgp, bgp_south_float_ip, south_float_ip_v6, bgp_south_netcard, is_ipv6, south_interface = \
        read_product_info()
    if south_interface == bgp_south_netcard:
        LOG.info("the south_interface is the same as bgp_south_netcard, skip add nic")
        sys.exit(0)
    url = "/rest/plat/maintenanceservice/v1/commissioning/silence/nic"
    input_param = {"actionkey": "addNic", "startProduct": "false", "datalist": []}
    if is_ipv6:
        usage = "BGPSouth2"
    else:
        usage = "BGPSouth"
    for node_ip in IPS.split(","):
        file_name = os.path.join(NETCARD_INFO_DIR, "netcard_info_%s.json" % node_ip)
        if not os.path.exists(file_name):
            LOG.info("file %s dose not exists" % file_name)
            sys.exit(1)
        netmask, nic_ip = get_mask_and_ip_by_netcard(bgp_south_netcard, is_ipv6, file_name)
        if not netmask or not nic_ip:
            LOG.info("netmask or nic_ip is empty, netmask: %s, nic_ip: %s", netmask, nic_ip)
            sys.exit(1)
        input_param["datalist"].append({
            "oldnodemgrip": node_ip,
            "newnodemgrip": node_ip,
            "networkinfo": json.dumps([{
                "nic": bgp_south_netcard,
                "oldip": "",
                "newip": nic_ip,
                "oldnetmask": "",
                "newnetmask": netmask,
                "oldusage": "",
                "newusage": usage
            }])
        })
    LOG.info(input_param)
    task_id = None
    for _ in range(30):
        result, result_info = utils.send_rest(_ip, port, url, mode="POST",
                                              log=LOG, body=input_param, sleep=6, retry_times=0,
                                              content="add nic")
        LOG.info(json.loads(result_info))
        if result == 0:
            task_id = json.loads(result_info).get("taskid")
            if task_id is not None:
                LOG.info("create task success, task id is %s", task_id)
                break
            time.sleep(6)

    if task_id is not None and task_id != "":
        if not query_task_res(url, task_id, retry_times=360):
            LOG.info("execute timeout.")
            sys.exit(1)
    else:
        LOG.info("execute failed.")
        sys.exit(1)
    return result


if ACTION == "add_bgp":
    sys.exit(main())
elif ACTION == "add_nic":
    sys.exit(main_add_nic())
