# coding=utf-8
'''
check nodelist.json
'''

import sys
import json
import time
from utils import set_log
from utils import utils

NODELIST_JSON = "/opt/oss/manager/etc/sysconf/nodelists.json"
UPGRADE_OR_ROLLBACK = sys.argv[1]
BGP_OR_NORTH = sys.argv[2]

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1


def main():
    '''
    mian
    :return: result
    '''
    with open(NODELIST_JSON, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("nodeList")
    bgp_list = network_json_list.get("1")
    north_list = network_json_list.get("2")
    if UPGRADE_OR_ROLLBACK == "upgrade":
        if BGP_OR_NORTH == "bgp":
            if "BGP_FLOATIP" not in str(bgp_list):
                print("Upgrade bgp env")
                return SUCCESS
            else:
                return REQ_FAILED
        else:
            if "NORTH_FLOATIP" not in str(north_list):
                print("Upgrade north env")
                return SUCCESS
            else:
                return REQ_FAILED
    else:
        if BGP_OR_NORTH == "bgp":
            if "BGP_FLOATIP" in str(bgp_list):
                print("Rollback bgp env")
                return SUCCESS
            else:
                return REQ_FAILED
        else:
            if "NORTH_FLOATIP" in str(north_list):
                print("Rollback north env")
                return SUCCESS
            else:
                return REQ_FAILED

sys.exit(main())
