'''
check_package_status.py
'''
import sys
import os
import shutil
import time
import traceback
import subprocess
import zipfile
import json
import logging
import py_zenith
import get_db_pass
from utils import set_log

my_log = set_log.set_log(stream=True)

def get_tenant_name():
    '''
        get_tenant_name
    '''
    if os.path.join("/opt/oss/NCECOMMONE/apps/"):
        return "NCECOMMONE"
    else:
        return "NCE"


def get_package_dir(log_dir):
    '''
    :return:
    '''
    package_dir = os.path.join(log_dir, "package")
    if os.path.exists(package_dir):
        shutil.rmtree(package_dir)
    os.makedirs(package_dir)
    return package_dir


def copy_zip_file(tenant_name, package_dir):
    '''
    :param package_dir:
    :param tenant_name:
    :return:
    '''
    command = "cp -rf /opt/oss/%s/apps/DCNOpenEMService/pub/builtInPkg/*.zip %s" % (tenant_name, package_dir)
    my_log.info(command)
    result, result_str = subprocess.getstatusoutput(command)
    if result != 0:
        my_log.error("copy zip failed")
        return False
    return True


def get_package_version_dict(package_dir):
    '''
    :return:
    '''
    package_version_dict = {}
    for file_name in os.listdir(package_dir):
        if file_name.endswith(".zip") and "cisco" not in file_name:
            package_name = file_name.split(".zip")[0]
            unzip_dir = os.path.join(package_dir, package_name)
            if not os.path.exists(unzip_dir):
                os.makedirs(unzip_dir)
            with zipfile.ZipFile(os.path.join(package_dir, file_name)) as zip_object:
                zip_object.extract(os.path.join(package_name, "pkg.json"), unzip_dir)
            with open(os.path.join(unzip_dir, package_name, "pkg.json"), "rb") as _f:
                version = json.load(_f)["version"]
            package_version_dict[package_name] = version
    my_log.info(package_version_dict)
    return package_version_dict


def get_ip_and_port():
    '''
    :return:
    '''
    _ip = ""
    port = ""
    command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E dcnnwcommondb |grep Master"
    my_log.info(command)
    result, result_str = subprocess.getstatusoutput(command)
    my_log.info(result_str)
    if result == 0 and result_str:
        _ip = result_str.split()[5]
        port = result_str.split()[6]
    else:
        my_log.info("single db instance")
        command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd query-db-instance |grep -E dcnnwcommondb"
        my_log.info(command)
        result, result_str = subprocess.getstatusoutput(command)
        my_log.info(result_str)
        if result == 0 and result_str:
            _ip = result_str.split()[5]
            port = result_str.split()[6]
    return _ip, port


def check(zenith_connect, package_version_dict):
    sleep_time = 10
    total_minute = 0
    for _ in range(total_minute*60//sleep_time):
        status_ok = 0
        for package_name, version in package_version_dict.items():
            sql = "select PKG_STATUS from T_BP_COORDINATOR_PKG_INFO where PKG_NAME='%s' and PKG_VERSION='%s'" % (package_name, version)
            my_log.info(sql)
            result = zenith_connect.select(sql)
            if len(result) == 0:
                status_ok = 1
                my_log.info("can not find  PKG_NAME='%s' and PKG_VERSION='%s' in T_BP_COORDINATOR_PKG_INFO" % (package_name, version))
                break
            else:
                if result[0][0] != "ACTIVE":
                    status_ok = 1
                    my_log.info("the PKG_NAME='%s' and PKG_VERSION='%s' status is %s" % (package_name, version, result[0][0]))
                    break
        if status_ok == 0:
            my_log.info("all package are ok")
            return status_ok
        time.sleep(sleep_time)
    return 1


def main(log_dir):
    '''
    :return:
    '''
    db_instance = "dcnnwcommondb"
    db_name = "pkgcoordinatorcdb"
    zenith_connect = None
    try:
        # 获取租户
        tenant_name = get_tenant_name()
        # 获取包存放的路径
        package_dir = get_package_dir(log_dir)
        # 拷贝包的zip文件到 包存放的路径
        copy_zip_file_result = copy_zip_file(tenant_name, package_dir)
        if not copy_zip_file_result:
            return 2
        # 获取包名和版本号对应关系
        package_version_dict = get_package_version_dict(package_dir)

        # 获取数据库连接
        _ip, port = get_ip_and_port()
        password = get_db_pass.main(db_instance, db_name, "zenith", product_type="NCE").split(',')[-1]
        if not _ip or not port or not password:
            my_log.info("get ip or port or password failed")
            return 2
        zenith_connect = py_zenith.Zenith(
            host=_ip,
            username=db_name,
            password=password,
            port=str(port))

        # 开始检查
        result = check(zenith_connect, package_version_dict)
        return result
    except:
        my_log.exception("Exception log:")
        return 3
    finally:
        if zenith_connect:
            zenith_connect.close()
