'''
生成特性
'''
import os
import json

from utils import set_log


class CreateFutures:
    '''生成特性列表'''
    def __init__(self, product_json_file, is_south_ipv6, now_path, upgrade_log_path, des_path, upgrade_path):
        '''
        :param product_json_file: 存放特性的文件
        :param is_south_ipv6: 南向ipv6的值
        :param now_path: 当前路径（one_hop_plan_custom所在的路径）
        :param upgrade_log_path: 升级日志路径
        :param des_path: 特性文件需要被拷贝到的路径
        :param des_path: 升级路径
        '''
        self.log = set_log.set_log(stream=True)
        self.product_json_file = product_json_file
        self.is_south_ipv6 = is_south_ipv6
        self.now_path = now_path
        self.upgrade_log_path = upgrade_log_path
        self.des_path = des_path
        self.upgrade_path = upgrade_path
        self.feature_file_name = "feature_plan_iMasterNCE-Fabric.json"
        self.scene_baseline = os.path.join(self.now_path, "compare_service", "scene_baseline.json")
        self.flag_file = "/opt/oss/easysuite/easysuite/easysuite/plugins/" \
                         "iMasterNCE-Fabric/upgrade_online/service/scripts/" \
                         "flag_dir/is_hybrid_telecom_cloud_scenario.txt"
        self.mandatory = "Mandatory"
        self.optional = "Optional"
        self.feature_base = "base"
        # 电信云场景的基础特性
        self.feature_base_for_bgp = "base_telecom"
        self.feature_mdc = "base_mdc"
        self.uni_collector = "uniCollector-E"
        self.bgp_feature = "bgp_feature"
        self.dryrun_feature = "dryrun_feature"
        self.basesm = "basesm"
        self.digital_map_feature = "digital_map_feature"
        self.log.info(self.__dict__)

    def main(self):
        '''
        入口函数
        :return:
        '''
        installed_features = self.get_installed_features()
        des_features_dict = self.get_des_features()
        feature_add, feature_del = self.get_need_installed_features(
            installed_features, des_features_dict)
        self.write_feature_file(feature_add, feature_del)

    def write_feature_file(self, feature_add, feature_del):
        '''
        生成特性文件，并拷贝到对应目录
        :param feature_add:
        :param feature_del:
        :return:
        '''
        file_path = os.path.join(self.des_path, self.feature_file_name)
        file_path2 = os.path.join(self.upgrade_log_path, self.feature_file_name)
        content = {
            "feature": {
                "addFeatures": list(feature_add),
                "delFeatures": list(feature_del)
            }
        }

        with open(file_path, "w") as _f, open(file_path2, "w") as _f2:
            json.dump(content, _f, separators=(', ', ': '), indent="\t")
            json.dump(content, _f2, separators=(', ', ': '), indent="\t")
        self.log.info("create feature success, file_path: %s, file_path2: %s",
                      file_path, file_path2)

    def get_need_installed_features(self, installed_features, des_features_dict):
        '''
        生成目标版本【需装特性】的集合（必装特性 + 需要的选装特性）
            a、必装特性： --- 区分 mdc 和 base，生成一个【需装特性】集合
            b、选装特性：在a步骤的基础上增加【需装特性】
                --- 设计态包含【design_feature，dtagent_feature，invhistory_feature】，
                    如果源版本含有design_feature，【需装特性】加入上述特性
                --- 故障闭环包含【fault_feature、Common_DSOE_Runtime、Common_Catalog】，
                    如果源版本含有fault_feature，【需装特性】加入上述特性
                --- 自动驾驶包含【adnbasic_feature、design_feature、fault_feature、Common_DSOE_Runtime、
                    Common_Catalog、invhistory_feature、uniCollector-E、dtagent_feature】
                    如果源版本含有adnbasic_feature，【需装特性】加入上述特性
                --- 服务化包含【runbook_feature、Common_DSOE_Designer、
                    Common_DSOE_Runtime、Common_Catalog、dtagent_feature】
                    如果源版本含有runbook_feature，【需装特性】加入上述特性
                --- secomanager包含【basesm】
                    如果源版本含有basesm，【需装特性】加入上述特性
                --- bgp包含【bgp_feature】
                    如果源版本含有bgp，【需装特性】加入上述特性
                --- 数字地图包含【digital_map_feature、dataCollection_feature】
                    如果源版本含有digital_map_feature，【需装特性】加入上述特性
            c、如果南向不是ipv6，uniCollector-E 加入 【需装特性】
            d、	【新增特性】 = 【需装特性】.difference (【已装特性】)
                【删除特性】 = 【已装特性】.difference (【需装特性】)
        :return:
        '''
        installed_features_set = set(installed_features)

        scene = "base"
        # 含有base_mdc（R20C00即使安装了MDC也要安装非MDC场景处理）
        if self.feature_mdc in installed_features and "V100R020C00" not in self.upgrade_path:
            scene = "mdc"

        # 生成一个【需装特性】集合
        if scene == "mdc":
            self.log.info("mdc scene")
            need_installed_features = set(des_features_dict[self.mandatory][self.feature_mdc])
            if self.is_south_ipv6 != "ipv6" and self.digital_map_feature in installed_features:
                self.log.info("ipv4、%s scene, %s need" % (self.digital_map_feature, self.uni_collector))
                need_installed_features.add(self.uni_collector)
        else:
            self.log.info("base scene")
            need_installed_features = set(des_features_dict[self.mandatory][self.feature_base])
            if self.is_south_ipv6 != "ipv6" and not os.path.exists(self.flag_file):
                self.log.info("ipv4, %s need" % self.uni_collector)
                need_installed_features.add(self.uni_collector)

        # 选装特性处理，在上一步骤的基础上增加【需装特性】
        for feature in des_features_dict["Optional"].keys():
            if feature in installed_features_set:
                need_installed_features.update(des_features_dict[self.optional][feature])

        self.log.info("need_installed_features is: %s", need_installed_features)

        feature_add = need_installed_features.difference(installed_features_set)
        feature_del = installed_features_set.difference(need_installed_features)

        self.log.info("feature_add is: %s", feature_add)
        self.log.info("feature_del is: %s", feature_del)
        return feature_add, feature_del

    def get_optional_features_set(self, des_features_dict):
        '''
        获取选装特性集合
        :return:
        '''
        optional_features_set = set()
        for _, feature_list in des_features_dict[self.optional].items():
            optional_features_set.update(feature_list)
        return optional_features_set

    def get_installed_features(self):
        '''
        获取特性
        :return: features -> list
        '''
        with open(self.product_json_file, "rb") as _f:
            product_info = json.load(_f)
            features = product_info["productext"]["features"].strip(";").split(";")
        self.log.info("installed features features is: %s", features)
        return features

    def get_des_features(self):
        '''
        获取目标版本的需求基线
        :return:
        '''
        with open(self.scene_baseline, "rb") as _f:
            des_features_dict = json.load(_f)
        # 处理混合电信云特性，必装特性base为base_telecom, 选装特性只保留bgp_feature
        if os.path.exists(self.flag_file):
            self.log.info("hybrid telecom cloud scenario")
            des_features_dict[self.mandatory][self.feature_base].remove("base")
            des_features_dict[self.mandatory][self.feature_base].remove("dataCollection_feature")
            des_features_dict[self.mandatory][self.feature_base].append(self.feature_base_for_bgp)
            des_features_dict[self.mandatory][self.feature_base].append(self.dryrun_feature)
            del des_features_dict[self.mandatory][self.feature_mdc]
            for feature_name in list(des_features_dict[self.optional].keys()):
                if feature_name != self.bgp_feature and feature_name != self.dryrun_feature \
                        and feature_name != self.basesm:
                    del des_features_dict[self.optional][feature_name]
        self.log.info("des_features_dict is: %s", des_features_dict)
        return des_features_dict
