# coding=utf-8 （coding=utf-8告诉Python解释器要按照utf-8编码的方式读取程序，如果不加这个声明，无论代码中还是注释中有中文都会报错）
'''
create_db.py
'''

from __future__ import print_function
import subprocess
import os
from utils import set_log
import get_db_size

LOG = set_log.set_log(stream=True)


def main(action, instance_name, db_type, db_difference_file, master_instance_id, db_names_now="", old_instance_path="", containerlist_file=""):
    '''
    :param action:
    :param instance_name:
    :param db_type:
    :param db_difference_file:
    :param master_instance_id:
    :param db_names_now:
    :param old_instance_path:
    :param containerlist_file:
    :return:
    '''
    LOG.info("params is : %s", locals())
    result = 0
    if action == "add":
        db_names_old = []
        for path in os.listdir(old_instance_path):
            if os.path.isfile(os.path.join(old_instance_path, path)):
                db_names_old.append(os.path.splitext(path)[0])

        # 获取老的实例有的db_name，现在实例没有的db_name
        db_difference_list = list(set(db_names_old).difference(set(db_names_now.split(","))))
        LOG.info("db_difference_list: %s", db_difference_list)

        if db_difference_list:
            db_size_list = []
            with open("%s_%s.txt" % (db_difference_file, instance_name), "w") as _f:
                for db_name in db_difference_list:
                    _f.write("%s\n" % db_name.strip())
                    db_size = get_db_size.main(containerlist_file, instance_name, db_name, db_type)
                    if str(db_size):
                        LOG.info("%s db_size: %s", db_name, db_size)
                        db_size_list.append(str(db_size))
                    else:
                        LOG.error("%s get db_size failed", db_name)
                        return 1
            service_list = ["MyService"] * len(db_difference_list)
            command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd add-database " \
                      "-instid %s -dbnames %s -appnames %s -datasizes %s" % (master_instance_id,
                                                                             ",".join(db_difference_list),
                                                                             ",".join(service_list),
                                                                             ",".join(db_size_list))
            LOG.info(command)
            result, result_str = subprocess.getstatusoutput(command)
            LOG.info(result_str)

    elif action == "delete":
        file_name = "%s_%s.txt" % (db_difference_file, instance_name)
        LOG.info("file_name: %s", file_name)
        if os.path.exists(file_name):
            db_name_list = []
            with open(file_name, "r") as _f:
                for db_name in _f:
                    if db_name.strip():
                        db_name_list.append(db_name.strip())

            if db_name_list:
                command = "/opt/oss/manager/apps/DBAgent/bin/dbsvc_adm -cmd remove-database " \
                          "-instid %s -dbnames %s" % (master_instance_id, ",".join(db_name_list))
                LOG.info(command)
                result, result_str = subprocess.getstatusoutput(command)
                LOG.info(result_str)
        else:
            LOG.info("file_name %s does not exists", file_name)

    return result



