# coding=utf-8
'''
删除ce1800v以前错误的告警
'''
import sys
from utils import set_log
from utils import utils

LOG = set_log.set_log(stream=True)
SUCCESS = 0
REQ_FAILED = 1


def delete_alarm(alarm_id):
    '''
    根据告警id删除告警
    :param alarm_id:
    :return:
    '''
    _ip = utils.get_local_ip()
    port = utils.get_ir_port()
    input_param = []
    delete_url = "/rest/fault/v1/alarm-definitions/100000/" + alarm_id
    result, _ = utils.send_rest(_ip, port, delete_url, mode="DELETE", log=LOG,
                                body=input_param, sleep=6, retry_times=10,
                                content="delete residual alarm %s" % alarm_id)
    return result


def main():
    '''
    主函数，删除ce1800v以前错误的告警
    :return:
    '''
    alarm_list = {"15794574", "15794856", "15794573", "15794964", "15794564", "15794559",
                  "15794572", "15794847", "15794577", "15794627", "15794628", "15794626",
                  "15794665", "15795030", "15794855", "15794576", "15795041", "15795085",
                  "15795116", "15795065", "15794884", "15794695", "15795102", "15795093",
                  "15795083", "15794675", "15794767", "15794766", "15795068", "15795042",
                  "15794962", "15795109", "15795101", "15795090", "73776"}
    for alarm_id in alarm_list:
        delete_response = delete_alarm(alarm_id)
        if delete_response == REQ_FAILED:
            return REQ_FAILED

    return SUCCESS


sys.exit(main())
