# coding=utf-8
'''
deivice_role
'''
import json
import traceback
from copy import deepcopy
import py_zenith

def deal_value(value_list):
    '''
    处理value
    :param value:
    :return:
    '''
    value_list2 = []
    for device_role_name in value_list:
        if device_role_name.strip():
            value_list2.append(device_role_name.strip())
    value_list2 = list(set(value_list2))
    value_list2.sort()
    return ",".join(value_list2)


def update_old_role(_ip, port, db_name, password, sql_name):
    '''
    修正devicedescriptionentity表中老的设备角色device_role_list的值
    Border Leaf替换为Egress Gateway
    Server Leaf替换为Leaf
    :return:
    '''
    zenith_connect = None
    exec_result = 0
    try:
        zenith_connect = py_zenith.Zenith(
            host=_ip,
            username=db_name,
            password=password,
            port=port)
        sql = "select id, devicepropertylist from devicedescriptionentity"
        result = zenith_connect.select(sql)
        update_sql = []
        for row in result:
            if row[1] is not None:
                lis_original = json.loads(row[1].decode())
                lis = deepcopy(lis_original)
                for dic in lis:
                    if dic["param"] == "device_role_list":
                        is_update = False
                        value = dic["value"]
                        if "Border Leaf" in value:
                            is_update = True
                            value = value.replace("Border Leaf", "Egress Gateway")
                        if "Server Leaf" in value:
                            is_update = True
                            value = value.replace("Server Leaf", "Leaf")
                        if is_update:
                            value_list = value.split(",")
                            dic["value"] = deal_value(value_list)
                            update_sql.append("update devicedescriptionentity set devicepropertylist='%s' where id='%s';"
                                              % (json.dumps(lis, separators=(',', ":")), row[0]))
        if update_sql:
            with open(sql_name, "a+") as _f:
                for sql in update_sql:
                    _f.write("%s\n" % sql)
                _f.write("commit;\n")
    except:
        exec_result = 1
        traceback.print_exc()
    finally:
        if zenith_connect:
            zenith_connect.close()
    return exec_result


def update_or_add_role(_ip, port, db_name, password, sql_name):
    '''
    2、遍历fabric中设备select d.ID, n.NODE_TYPE, n.IS_DCI_ENABLE from tab_dcn_fabric_device_resm_manage d inner join tab_dcn_fabric_resm_node n on d.NODE_ID = n.ID;
    NODE_TYPE为5的追加Egress Gateway角色
    IS_DCI_ENABLE为TRUE的追加DCI Gateway角色
    NODE_TYPE不为5且IS_DCI_ENABLE不为TRUE的追加Leaf角色（当前设备无角色 再追加）
    注：无device_role_list时需新增，有device_role_list进行追加，设备角色排序后使用逗号分隔，例如：DCI Gateway,Egress Gateway,Leaf,Service Leaf,Spine
    :return:
    '''
    zenith_connect = None
    exec_result = 0
    try:
        zenith_connect = py_zenith.Zenith(
            host=_ip,
            username=db_name,
            password=password,
            port=port)
        sql2 = "select id, devicepropertylist from devicedescriptionentity where id in (select d.ID from tab_dcn_fabric_device_resm_manage d inner join tab_dcn_fabric_resm_node n on d.NODE_ID = n.ID)"
        result2 = zenith_connect.select(sql2)
        dic2 = {}
        for row2 in result2:
            if row2[1] is not None:
                dic2[row2[0]] = json.loads(row2[1].decode())
            else:
                dic2[row2[0]] = []

        sql = "select d.ID, n.NODE_TYPE, n.IS_DCI_ENABLE from tab_dcn_fabric_device_resm_manage d inner join tab_dcn_fabric_resm_node n on d.NODE_ID = n.ID"
        result = zenith_connect.select(sql)
        update_sql = []
        for row in result:
            need_append = []
            is_leaf = False
            if int(row[1]) == 5:
                need_append.append("Egress Gateway")
            if row[2] == "TRUE":
                need_append.append("DCI Gateway")
            if int(row[1]) != 5 and row[2] != "TRUE":
                is_leaf = True
                need_append.append("Leaf")
            if need_append:
                lis_original = dic2.get(row[0], None)
                if lis_original is not None:
                    lis = deepcopy(lis_original)
                    has_device_role_list = False
                    for dic in lis:
                        if dic["param"] == "device_role_list":
                            has_device_role_list = True
                            value_list = dic["value"].split(",")
                            # need_append不为leaf，追加角色
                            if not is_leaf:
                                value_list.extend(need_append)
                            else:
                                # need_append为leaf，当前设备角色为空，才追加
                                if not dic["value"].strip():
                                    value_list.extend(need_append)
                            dic["value"] = deal_value(value_list)
                            update_sql.append(
                                "update devicedescriptionentity set devicepropertylist='%s' where id='%s';"
                                % (json.dumps(lis, separators=(',', ":")), row[0]))
                    if not has_device_role_list:
                        need_append.sort()
                        dic = {"param": "device_role_list", "value": ",".join(need_append)}
                        lis.append(dic)
                        update_sql.append(
                            "update devicedescriptionentity set devicepropertylist='%s' where id='%s';"
                            % (json.dumps(lis, separators=(',', ":")), row[0]))
        if update_sql:
            with open(sql_name, "a+") as _f:
                for sql in update_sql:
                    _f.write("%s\n" % sql)
                _f.write("commit;\n")
    except:
        exec_result = 1
        traceback.print_exc()
    finally:
        if zenith_connect:
            zenith_connect.close()
    return exec_result


def deal_spine(_ip, port, db_name, password, sql_name):
    '''
    修正devicedescriptionentity表中老的设备角色device_role_list的值
    Border Leaf替换为Egress Gateway
    Server Leaf替换为Leaf
    :return:
    '''
    zenith_connect = None
    exec_result = 0
    try:
        zenith_connect = py_zenith.Zenith(
            host=_ip,
            username=db_name,
            password=password,
            port=port)
        sql = "select id, devicepropertylist from devicedescriptionentity where devicepropertylist like '%Spine%'"
        result = zenith_connect.select(sql)
        update_sql = []
        for row in result:
            if row[1] is not None:
                lis_original = json.loads(row[1].decode())
                lis = deepcopy(lis_original)
                for dic in lis:
                    if dic["param"] == "device_role_list":
                        is_update = False
                        value = dic["value"]
                        if '["Spine"]' in value:
                            is_update = True
                            value = value.replace('["Spine"]', 'Spine')
                        if is_update:
                            value_list = value.split(",")
                            dic["value"] = deal_value(value_list)
                            update_sql.append("update devicedescriptionentity set devicepropertylist='%s' where id='%s';"
                                              % (json.dumps(lis, separators=(',', ":")), row[0]))
        if update_sql:
            with open(sql_name, "a+") as _f:
                for sql in update_sql:
                    _f.write("%s\n" % sql)
                _f.write("commit;\n")
    except:
        exec_result = 1
        traceback.print_exc()
    finally:
        if zenith_connect:
            zenith_connect.close()
    return exec_result


