'''
get_big_table.py
'''
import sys
import os
import traceback
import py_zenith
import subprocess
from utils import set_log
from utils import common_method

my_log = set_log.set_log(stream=True)
temporary_path = common_method.get_temporary_path()

DB_NAME = sys.argv[1].lower()
PASSWORD = sys.argv[2]
IP = sys.argv[3]
PORT = sys.argv[4]
INSTANCE_NAME = sys.argv[5]
DB_TYPE = sys.argv[6]
check_result_path = "%s/check_result/check_result_summarized/check_big_table-%s_%s.txt" % (
    temporary_path, INSTANCE_NAME, DB_NAME)
WHITE_LIST = {"dcnnwpersistentdb": ["T_NOTIFY"]}


def deal_white_list(result):
    new_result = []
    need_delete_table = set()
    sql_name = "get_big_table_%s_delete.sql" % DB_NAME
    sql_path = os.path.join(os.path.dirname(__file__), sql_name)
    if os.path.exists(sql_path):
        os.remove(sql_path)
    if DB_NAME in WHITE_LIST:
        condition_list = WHITE_LIST[DB_NAME]
        for condition in condition_list:
            for row in result:
                table_name = row[0]
                if DB_TYPE == "gauss" and "." in table_name:
                    table_name = table_name.split(".")[1]
                if table_name.upper().startswith(condition):
                    need_delete_table.add(table_name)
                else:
                    if row not in new_result:
                        new_result.append(row)

    if need_delete_table:
        with open(sql_path, "w") as _f:
            for table_name in need_delete_table:
                _f.write("truncate table %s;\n" % table_name)
            if DB_TYPE == "zenith":
                _f.write("commit;")

    if os.path.exists(sql_path):
        shell_name = os.path.join(os.path.dirname(os.path.dirname(__file__)), "one_hop_pre_custom", "delete_big_table.sh")
        command = "sh %s %s %s %s %s %s %s %s" % (shell_name, IP, PORT, DB_NAME, PASSWORD, DB_TYPE, sql_path, sql_name)
        my_log.info(command.replace(PASSWORD, "*******"))
        result, result_str = subprocess.getstatusoutput(command)
        my_log.info("result: %s, result_str: %s", result, result_str)

    return new_result


def main():
    '''
    get_big_table
    :param :
    :return:
    '''
    zenith_connect = None
    try:
        size_dict = {"bytes": 1024 * 1024 * 1024, "kb": 1024 * 1024, "mb": 1024, "gb": 1}
        if DB_TYPE == "zenith":
            sql = "select SEGMENT_NAME from adm_segments \
                       where tablespace_name = '%s' and bytes/1024/1024/1024 > 10 order by bytes desc" % DB_NAME.upper()
        else:
            sql = '''SELECT nspname || '.' || relname AS "relation",pg_size_pretty(pg_relation_size(C.oid)) AS "size" FROM 
                pg_class C LEFT JOIN pg_namespace N ON (N.oid = C.relnamespace) ORDER BY pg_relation_size(C.oid) DESC'''
        zenith_connect = py_zenith.Zenith(
            host=IP,
            username=DB_NAME,
            password=PASSWORD,
            port=str(PORT),
            db_type=DB_TYPE)
        result = zenith_connect.select(sql)
        with open(check_result_path, "w") as _f:
            if DB_TYPE == "zenith":
                new_result = deal_white_list(result)
                for row in new_result:
                    _f.write(str([row[0]]))
            else:
                result2 = []
                for table_name, size_str in result:
                    size = size_str.split()[0].strip()
                    size_unit = size_str.split()[1].strip()
                    if int(size) / size_dict[size_unit.lower()] > 10:
                        result2.append((table_name, ))
                    else:
                        break
                new_result = deal_white_list(result2)
                for row in new_result:
                    _f.write(str([row[0]]))

    except:
        my_log.exception("Exception logged")
    finally:
        if zenith_connect:
            zenith_connect.close()


if __name__ == '__main__':
    main()
