'''
IR_entlinkmgmt.py
'''
import os
import sys
import time
import datetime
from util import httpclient

sys.path.append(os.path.abspath(".."))

SUCCESS = 0
REQ_FAILED = 1
REQ_NONE = 2
REQ_EXCEPTION = 3
REQ_NODEPLOY = 4
REQ_EMPTY = 5
LINK_IR = '/rest/plat/priv/v1/static-operations'


def getlocalip():
    '''getlocalip'''
    conf_path = "cat /opt/oss/manager/var/agent/managerip.conf \
               |grep localip | awk -F '=' '{print $NF}'"
    local_ip = os.popen(
        "LOCAL_IP=` %s`;echo $LOCAL_IP" % (conf_path)).read()
    local_ip.replace(' ', '')
    _ip = local_ip.replace('\n', '')
    return _ip


def getconnection():
    '''
    get IR connection
    '''
    _ip = getlocalip()
    http_connection = httpclient.CommonHttpClient(_ip, 32018, True, False)
    return http_connection


def getdcnsdata(connection):
    '''
    get common link data
    '''
    input_param = {
        "groups": [
            {
                "id": "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror",
                "inherits": [
                    "DCNService:com.huawei.sdn.acdcn.OM.and.Monitoring.image"
                ]
            }
        ],
        "operations": [
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.get:read",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.portmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.create:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.portmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.update:update",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.portmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.portmirror.delete:delete",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.portmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.get:read",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.vmmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.create:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.vmmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.vmmirror.delete:delete",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.vmmirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.create:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight.status.get:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.fabricinsight"
                ]

            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.get:read",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port"
                ]

            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port.create:delete",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.observe.port"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.get:read",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.create:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.delete:delete",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task.getid:read",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.oam.erspan.mirror.task"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.create:create",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.mirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.get:read",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.mirror"
                ]
            },
            {
                "id": "DCNService:com.huawei.sdn.acdcn.mirror.delete:delete",
                "groups": [
                    "DCNService:com.huawei.sdn.acdcn.mirror"
                ]
            }
        ]
    }
    response = connection.post(LINK_IR, input_param)
    http_status = response[0]
    retry_flag = 1
    while http_status != 200 and retry_flag <= 30:
        response = connection.post(LINK_IR, input_param)
        http_status = response[0]
        time.sleep(6)
        retry_flag = retry_flag + 1
    if http_status == 200:
        response_content = response[1]
        str_content = response_content.decode(encoding='utf-8')
        print("Successful query PortMirror links,status code:%s", http_status)
    else:
        print("Failed to call the PortMirror, status code: %s", repr(http_status))


def main():
    '''main funtion'''
    http_connection = getconnection()
    getdcnsdata(http_connection)
    return SUCCESS


sys.exit(main())
