# coding=utf-8
"""
数据迁移前置脚本
"""

import os
import zipfile
import sys
from concurrent.futures import ProcessPoolExecutor, wait
import subprocess
import multiprocessing
import stat


def starter_2_pub(source_path, file_name):
    """
    copy DatastoreStarter/DataStore.properties to DataMigrateTool/pub
    :param source_path: DatastoreStarter path
    :return:
    """
    source_file = os.path.join(source_path, file_name)
    if os.path.exists(source_file):
        target_path = os.path.join(CUR_PATH, 'pub')
        target_file = os.path.join(target_path, file_name)

        result = subprocess.Popen(("cp %s %s" % (source_file, target_path)).split())
        result.wait()
        if file_name == "DataStore.properties":
            with open(target_file, "a+") as _f:
                _f.write("\nyangPathKey= urn_huawei_yang_huawei_ac_iui_snmpsouth_statistics_"
                         "snmpsouth_packet_statistics_packet_statistics_packet_statistics_info"
                         "|instance-name,op-type")
        elif file_name == "devmDynamicMigrate.properties":
            with open(target_file, "w") as _f:
                _f.write("sourceDatabase=%s-dcnnwpersistentdb\n" % DB_TYPE)
                _f.write("targetDatabaseForNcs=zenith-dcnnepersistentdb\n")
                _f.write("targetDatabaseForEcs=zenith-dcnnepersistentdb\n")
                _f.write("NcsStandalone=false")
        os.chmod(target_file, stat.S_IWUSR | stat.S_IRUSR | stat.S_IRGRP | stat.S_IROTH)


def change_xml(xml, dir_name, source_str, target_str):
    '''
    将xml中taget_db, dource_db 的刷为相应的db
    :param xml: xml的筛选  如: .*xml
    :param dir_name:  xml所在目录
    :param source_str:  将被替换的内容
    :param target_str:  被替换成的内容
    :return:
    '''
    # 对于SourceDB, zenith数据库，含有 lockTableList的加上 源库名字
    if "SourceDB" in source_str and DB_TYPE == ZENITH:
        # grep -r(递归) -l(只显示文件) + 查询内容 + 文件/目录
        source_db = target_str.split("-")[1]
        os.system(r'find %s -name "%s" | xargs grep -r -l "%s" | tr "\n" "\0" | xargs -0 sed -i "s/%s/%s/g"'
                  % (dir_name, xml, source_str, r'lockTableList=\"',
                     r'lockTableList=\"%s.' % source_db))
    os.system(r'find %s -name "%s" | tr "\n" "\0" | xargs -0 sed -i "s/{%s}/%s/g"'
              % (dir_name, xml, source_str, target_str))


def add_config_for_common(common_path):
    '''
    :param common_path: common路径
    :return:
    '''
    if DB_TYPE == ZENITH:
        source_db = "netconfclientdb"
        dir_name = os.path.join(common_path, "NetconfClientService")
        os.system(r'find %s -name "%s" | tr "\n" "\0" | xargs -0 sed -i "s/%s/%s/g"'
                  % (dir_name, "*.xml", r'lockTableList=\"t',
                     r'lockTableList=\"%s.t' % source_db))
        pub_path = os.path.join(dir_name, "pub/sshDynamicMigrate.properties")
        if os.path.exists(pub_path):
            os.system(r'cp %s %s/pub/' % (pub_path, CUR_PATH))

def add_config(config_service):
    """
    starter
    :param config_service:各个微服务的迁移数据配置路径
    :return:创建新的配置文件目录
    """

    service_name, stater_file_name = get_starter_name(config_service)
    starter_db = get_starter_lst(config_service, service_name)

    # AOCNcsStarter 和 devicemgmtstarter等用到的db
    aoc_starter_db = "dcnnepersistentdb"
    device_starter_db = "dcnnwpersistentdb"

    # 修改名字之后
    need_del_xml_for_frameworkstarter = ["AOCFS_elementSSP.xml",
                                         "AOCFS_elementWSND.xml",
                                         "AOCFS_elementSSPundo.xml",
                                         "AOCFS_elementWSNDundo.xml",
                                         "AOCFS_aocrecord_copy.xml",
                                         "AOCFS_aocrecord_delete.xml",
                                         "AOCFrameworkStarter_serdiff.xml",
                                         "database/AOCFS_aocrecord.xml",
                                         "database/AOCFrameworkStarter_nochanged_cdb_ecs.xml",
                                         "database/AOCFrameworkStarter_sync.xml",
                                         "database/AOCFrameworkStarter_nochanged_ldb_ecs.xml",
                                         "database/AOCFrameworkStarter_syncecs.xml"]
    need_del_xml_for_devicemgmtstarter = ["database/DeviceMgmtStarter_devm.xml"]
    need_del_xml_for_ecsdevmstarter = ["database/EcsDevmStarter_devm.xml",
                                       "database/EcsIfmLinkStarter_devm.xml"]
    need_del_xml_for_ncsdevmstarter = ["database/NcsDevmStarter_devm.xml"]
    need_del_xml_for_configmgmtstarter = ["database/ConfigmgmtStarter_nochanged_hiscmd_cdb.xml",
                                          "database/ConfigmgmtStarter_cdb.xml"]
    need_del_xml_for_deviceshellstarter = ["database/DeviceShellStarter_devm.xml"]
    need_del_xml_for_resourcemgmtstarter = ["database/ResourceMgmtStarter_nochanged_nistestcdb.xml"]

    if IS_R19:
        need_del_xml_for_frameworkstarter = ["AOCFS_elementSSP.xml",
                                             "AOCFS_elementWSND.xml",
                                             "AOCFS_elementSSPundo.xml",
                                             "AOCFS_elementWSNDundo.xml",
                                             "AOCFS_aocrecord_copy.xml",
                                             "AOCFS_aocrecord_delete.xml",
                                             "database/AOCFS_aocrecord.xml"]
        need_del_xml_for_devicemgmtstarter = []
        need_del_xml_for_ecsdevmstarter = []
        need_del_xml_for_ncsdevmstarter = []
        need_del_xml_for_configmgmtstarter = []
        need_del_xml_for_deviceshellstarter = []
        need_del_xml_for_resourcemgmtstarter = []
    for starter_ser, dbs in starter_db.items():
        for d_b in dbs:
            config_name = starter_ser + '_' + d_b
            starter_name = starter_ser.split("_")[0].lower()
            # starter_service_db : starter的完整路径
            starter_dir = os.path.join(config_service, config_name)
            stater_service(starter_ser, stater_file_name, config_service, config_name)
            if starter_name == "configmgmtstarter".lower():
                for xml_name in need_del_xml_for_configmgmtstarter:
                    xml_full_name = os.path.join(starter_dir, xml_name)
                    if os.path.exists(xml_full_name):
                        os.remove(xml_full_name)
            elif starter_name == "deviceshellstarter".lower():
                for xml_name in need_del_xml_for_deviceshellstarter:
                    xml_full_name = os.path.join(starter_dir, xml_name)
                    if os.path.exists(xml_full_name):
                        os.remove(xml_full_name)
            elif starter_name == "resourcemgmtstarter".lower():
                for xml_name in need_del_xml_for_resourcemgmtstarter:
                    xml_full_name = os.path.join(starter_dir, xml_name)
                    if os.path.exists(xml_full_name):
                        os.remove(xml_full_name)
            # AOCFrameworkStarter的处理
            if starter_name == "AOCFrameworkStarter".lower():
                for xml_name in need_del_xml_for_frameworkstarter:
                    xml_full_name = os.path.join(starter_dir, xml_name)
                    if os.path.exists(xml_full_name):
                        os.remove(xml_full_name)
                # 修改source_db（source_db只处理了其中一个xml，还有其余xml在最后处理。注意if else的逻辑）
                change_xml("AOCFrameworkStarter_nochanged_cdb_hiscmd.xml", starter_dir, 'AOCFrameworkStarter-SourceDB',
                           "%s-%s" % (DB_TYPE, aoc_starter_db))
                # 修改target_db
                change_xml("*.xml", starter_dir, 'ConfigmgmtStarter-TargetDB',
                           "%s-%s" % (ZENITH, device_starter_db))
            # DatastoreStarter的处理
            elif starter_name == "DatastoreStarter".lower():
                starter_2_pub(os.path.join(config_service, config_name), "DataStore.properties")
            # 将starter中的变量转化为相应的db (tr "\n" "\0"是处理find返回结果中的空格)
            if starter_name == "AOCNcsStarter".lower():
                # 修改source_db
                change_xml("*.xml", starter_dir, 'AOCNcsStarter-SourceDB',
                           "%s-%s" % (DB_TYPE, aoc_starter_db))
                change_xml("*.xml", starter_dir, 'DeviceShellStarter-SourceDB',
                           "%s-%s" % (DB_TYPE, device_starter_db))
                # 修改target_db
                change_xml("*.xml", starter_dir, 'AOCNcsStarter-TargetDB',
                           "%s-%s" % (ZENITH, aoc_starter_db))
                change_xml("*.xml", starter_dir, 'DeviceShellStarter-TargetDB',
                           "%s-%s" % (ZENITH, device_starter_db))
            # devicemgmtstarter的处理
            elif starter_name == "devicemgmtstarter".lower():
                for xml_name in need_del_xml_for_devicemgmtstarter:
                    xml_full_name = os.path.join(starter_dir, xml_name)
                    if os.path.exists(xml_full_name):
                        os.remove(xml_full_name)
                # 带AOCFrameworkStarter的刷为ne库
                # 修改source_db
                change_xml("*.xml", starter_dir, 'AOCFrameworkStarter-SourceDB',
                           "%s-%s" % (DB_TYPE, aoc_starter_db))
                change_xml("*.xml", starter_dir, 'DeviceMgmtStarter-SourceDB',
                           "%s-%s" % (DB_TYPE, device_starter_db))
                # 修改target_db
                change_xml("*.xml", starter_dir, 'DeviceMgmtStarter-TargetDB',
                           "%s-%s" % (ZENITH, device_starter_db))

            # ecsifmlinkstarter的处理,源和目标都是ne库
            elif starter_name == "ecsifmlinkstarter".lower() \
                    or starter_name == "ecsdevmstarter".lower():
                for xml_name in need_del_xml_for_ecsdevmstarter:
                    xml_full_name = os.path.join(starter_dir, xml_name)
                    if os.path.exists(xml_full_name):
                        os.remove(xml_full_name)
                if starter_name == "ecsdevmstarter".lower():
                    change_xml("EcsDevmStarter_dynamic_devm.xml", starter_dir, '.*-SourceDB',
                               "%s-%s" % (ZENITH, device_starter_db))
                change_xml("*.xml", starter_dir, '.*-SourceDB',
                           "%s-%s" % (DB_TYPE, aoc_starter_db))
                change_xml("*.xml", starter_dir, '.*-TargetDB',
                           "%s-%s" % (ZENITH, aoc_starter_db))

            # ncsdevmstarter的处理
            elif starter_name == "ncsdevmstarter".lower():
                # 拷贝 devmDynamicMigrate.properties 到 pub
                starter_2_pub(os.path.join(config_service, config_name, "pub"),
                              "devmDynamicMigrate.properties")
                if IS_R19:
                    # R19:单表源nw，目标ne;其余都是ne
                    # 修改source_db
                    change_xml("*sin*.xml", starter_dir, '.*-SourceDB',
                               "%s-%s" % (DB_TYPE, device_starter_db))
                    # 上一句已经替换了SourceDB，不影响single的xml
                    change_xml("*.xml", starter_dir, '.*-SourceDB',
                               "%s-%s" % (DB_TYPE, aoc_starter_db))
                    # 修改target_db
                    change_xml("*.xml", starter_dir, '.*-TargetDB',
                               "%s-%s" % (ZENITH, aoc_starter_db))
                else:
                    for xml_name in need_del_xml_for_ncsdevmstarter:
                        xml_full_name = os.path.join(starter_dir, xml_name)
                        if os.path.exists(xml_full_name):
                            os.remove(xml_full_name)
                    # NcsDevmStarter_single_ncsdeviceentity.xml源nw，目标ne，其余源和目标都是ne
                    # 修改source_db
                    change_xml("NcsDevmStarter_sin_ncsentity.xml",
                               starter_dir, '.*-SourceDB',
                               "%s-%s" % (DB_TYPE, device_starter_db))
                    change_xml("*.xml", starter_dir, '.*-SourceDB',
                               "%s-%s" % (DB_TYPE, aoc_starter_db))
                    # 修改target_db
                    change_xml("*.xml", starter_dir, '.*-TargetDB',
                               "%s-%s" % (ZENITH, aoc_starter_db))
            else:
                change_xml("*.xml", starter_dir, '.*-SourceDB',
                           "%s-%s" % (DB_TYPE, d_b))
                change_xml("*.xml", starter_dir, '.*-TargetDB',
                           "%s-%s" % (ZENITH, d_b))


def stater_service(starter_ser, starter_file_name, config_service, config_name):
    """
    将stater中的内容拷贝到config_path下
    :param starter_ser: 对应的stater
    :param config_name:
    :param starter_file_name:
    :param config_service:
    :return:
    """
    if not os.path.exists(os.path.join(config_service, config_name)):
        os.mkdir(os.path.join(config_service, config_name))

    starter = starter_ser.strip().split('_')[0]
    service = os.path.join(os.path.dirname(config_service), "service")

    os.system(r'cp -arf %s %s' % (os.path.join(config_service, service, 'databaseconf'),
                                  os.path.join(config_service, config_name)))

    for starter_name in starter_file_name:
        if starter in starter_name:
            extract_file = zipfile.ZipFile(os.path.join(config_service, starter_name))
            extract_file.extractall(os.path.join(config_service, config_name))


def get_starter_lst(config_service, service_name):
    """
    get service starter list
    :param config_service: 各个微服务的迁移数据配置路径
    :param service_name:
    :return: 所有微服务所依赖的starter
    """
    starter_service_db = {}
    for service in service_name:
        starter_path = os.path.join(config_service, service, 'starter.lst')
        if os.path.exists(starter_path):
            with open(starter_path) as file_operator:
                lines = file_operator.readlines()
                for line in lines:
                    starter = line.split('=')[0]
                    dbs = line.split('=')[1]
                    starter_ser = starter + '_' + service
                    if starter not in starter_service_db.keys() and dbs is not None:
                        starter_service_db[starter_ser] = dbs.strip().split(',')
                    else:
                        starter_service_db[starter_ser].extend(dbs.strip().split(','))
    return starter_service_db


def get_starter_name(config_service):
    """
    获取所有starter
    :param config_service: starter所在路径
    :return: list of all starter name
    """
    file_name = os.listdir(config_service)
    service_name = [tmp for tmp in file_name if 'zip' not in tmp]
    starter_file_name = [tmp for tmp in file_name if 'zip' in tmp]
    return service_name, starter_file_name


def jar_to_lib(config_service, current_path):
    """
    拷贝jar包，数据库驱动，连接配置到迁移工具的lib目录下
    :param config_service:
    :param current_path:
    :return:
    """
    # 分别获取common下和starter下的目录
    migrate_lib_path = os.path.join(current_path, 'lib')
    if not os.path.exists(migrate_lib_path):
        os.mkdir(migrate_lib_path)
    if config_service:
        service_name_dict = {}
        service_name, _ = get_starter_name(config_service)
        service_name_dict[config_service] = service_name
        common_path = os.path.join(CUR_PATH, 'config', 'common')
        if not os.path.exists(common_path):
            os.makedirs(common_path)
        service_name_common, _ = get_starter_name(common_path)
        service_name_dict[common_path] = service_name_common

        conn_path = os.path.join(current_path, 'connections')
        if not os.path.exists(conn_path):
            os.mkdir(conn_path)

        # 将各个微服务的jar拷贝到迁移工具lib目录下
        for base_path, service_name_list in service_name_dict.items():
            for service in service_name_list:
                lib_path = os.path.join(base_path, service, 'lib')
                try:
                    if os.path.exists(lib_path):
                        if "SnmpAgentNBService" in lib_path:
                            os.system(r'cp -arf %s/snmpagentnbservice* %s' % (lib_path, migrate_lib_path))
                            os.system(r'cp -arf %s/fastjson* %s' % (lib_path, migrate_lib_path))
                        else:
                            os.system(r'cp -arf %s/* %s' % (lib_path, migrate_lib_path))
                except OSError as cp_error:
                    print(cp_error)


def driver_to_lib(current_path, migrate_lib_path):
    '''
    拷贝guass 和 zenith 驱动到迁移工具lib目录下
    :param current_path: 当前路径
    :param migrate_lib_path: 迁移工具lib目录
    :return:
    '''
    # 拷贝gauss, zenith驱动
    driver_gauss_path, driver_zenith_path = get_driver_file()
    if driver_gauss_path:
        file_gauss = zipfile.ZipFile(driver_gauss_path)
        file_gauss.extractall(os.path.join(current_path, 'gauss_tmp'))
        os.system(r'cp %s/lib/* %s' % (os.path.join(current_path, 'gauss_tmp'), migrate_lib_path))
        os.system(r'rm -rf %s' % os.path.join(current_path, 'gauss_tmp'))
    file_zenith = zipfile.ZipFile(driver_zenith_path)
    file_zenith.extractall(os.path.join(current_path, 'zenith_tmp'))

    os.system(r'cp %s/lib/com.huawei.gauss.jdbc.ZenithDriver* %s'
              % (os.path.join(current_path, 'zenith_tmp'), migrate_lib_path))

    os.system(r'rm -rf %s' % os.path.join(current_path, 'zenith_tmp'))


def get_driver_file():
    '''
    获取gauss和zenith的驱动文件路径
    :return:
    '''
    path = r'/opt/pub/software/repository/Custom/'
    driver_gauss_dir = os.path.join(path, "DatabaseDriver_gauss")
    driver_zenith_dir = os.path.join(path, "DatabaseDriver_zenith")
    if IS_R19:
        driver_gauss_path = get_zip_file(driver_gauss_dir)
    else:
        driver_gauss_path = ""
    driver_zenith_path = get_zip_file(driver_zenith_dir)
    return driver_gauss_path, driver_zenith_path


def get_zip_file(driver_dir):
    '''
    获取驱动文件夹下的zip文件
    :param driver_dir: gauss或者zenith的驱动目录
    :return:
    '''
    # 可能存在多个zip，取更新时间最新的那个
    driver_path_list = []
    for filename in os.listdir(driver_dir):
        if os.path.splitext(filename)[1] == ".zip":
            driver_path_one = os.path.join(driver_dir, filename)
            driver_path_list.append([driver_path_one, os.path.getmtime(driver_path_one)])
    if not driver_path_list:
        print("cannot find zip file in %s" % driver_dir)
        sys.exit(1)
    driver_path_list.sort(key=lambda _k: -_k[1])
    driver_path = driver_path_list[0][0]
    return driver_path


def migrate_data(current_path, config_path):
    """
    迁移数据
    :param current_path: 脚本执行所在路径
    :param config_path: starter 所在路径
    :return:
    """
    order_path = os.path.join(current_path, 'execute.sh')
    result = 0

    service_list = []
    # 修改为并行， 执行顺序 starter , dcn,  common, secomanager, bgp
    service_list.extend(get_migrate_list(config_path))
    service_list.append(os.path.join(current_path, 'config', 'dcn', 'service'))
    # 新增加的secomanager
    service_list.append(os.path.join(current_path, 'config', 'secomanager', 'service'))
    service_list.extend(get_migrate_list(os.path.join(current_path, 'config', 'common')))
    # 张梦 增加的BGP需要迁移的xml配置
    service_list.append(os.path.join(current_path, 'config', 'bgp'))

    backup_path = os.path.join(current_path, "backup_path")
    app_name_set = get_app_name_list()
    futures = []
    for service_path in service_list:
        if os.path.exists(service_path):
            service = os.path.split(service_path)[1]
            service_path_dir = os.path.split(service_path)[0]
            dir_name = os.path.split(service_path_dir)[1]
            if dir_name == "common" or dir_name == "secomanager":
                if dir_name == "secomanager":
                    service = "SecoManagerService"
                if service not in app_name_set:
                    print("%s not in app_name_list, jump" % service)
                    continue
            command = r'sh %s online %s %s %s 1 1 %s' % (
                order_path, DB_TYPE, backup_path, service_path, service)
            print(command)
            futures.append(POOL.submit(start_migrate_data, command, service))
    wait(futures)
    for future in futures:
        future_result = future.result()
        if future_result[0] != 0:
            print("%s failed" % future_result[1])
            result = 1
        else:
            print("%s success" % future_result[1])

    # 逃生链路迁移
    escape_link_service = "escapelink"
    escape_link_path = os.path.join(current_path, 'config', escape_link_service)
    command = r'sh %s online %s %s %s 1 1 %s' % (
        order_path, DB_TYPE, backup_path, escape_link_path, escape_link_service)
    escape_link_result, _ = start_migrate_data(command, escape_link_service)
    if escape_link_result == 0:
        print("%s success" % escape_link_service)
    else:
        print("%s failed" % escape_link_service)
        result = 1
    sys.exit(result)


def start_migrate_data(command, service):
    '''
    执行命令行，开始迁移数据
    :param command: 迁移命令行
    :param service: 服务名称
    :return: 执行结果和服务名称
    '''
    # subprocess.call实际上是subprocess的封装，等待子进行执行完成，并返回执行状态(0、1等)
    result = subprocess.call(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    return result, service


def get_app_name_list():
    '''
    获取节点上运行的service
    :return: app_name_list
    '''
    with open("/opt/upgrade/app_names.txt", "r") as app_file:
        app_name_list = app_file.read().split()
    return set(app_name_list)


def get_migrate_list(target_dir):
    '''
    :param target_dir: 目标路径
    :return: 目标路径下的dir，即所有需要数据迁移的服务
    '''
    return [os.path.join(target_dir, service_dir)
            for service_dir in os.listdir(target_dir)
            if os.path.isdir(os.path.join(target_dir, service_dir))]


if __name__ == '__main__':
    POOL = ProcessPoolExecutor(max_workers=multiprocessing.cpu_count() // 2 + 1)
    CUR_PATH = sys.argv[1]
    UPGRADE_PATH = sys.argv[2]
    ZENITH = "zenith"
    DB_TYPE = ZENITH
    if "R019" in UPGRADE_PATH:
        IS_R19 = True
        DB_TYPE = "gauss"
    else:
        IS_R19 = False

    CONFIG_PATH = os.path.join(CUR_PATH, 'config', 'dcn', 'starter')
    COMMON_PATH = os.path.join(CUR_PATH, 'config', 'common')
    add_config_for_common(COMMON_PATH)
    add_config(CONFIG_PATH)
    jar_to_lib(CONFIG_PATH, CUR_PATH)
    migrate_data(CUR_PATH, CONFIG_PATH)
