#! /usr/bin/env python
# coding=utf-8
import re
import os
import sys
import json
from utils import set_log

import uniep.utils.net.httpclient.easyhttpclient as easyhttpclient

my_log = set_log.set_log(stream=True)
NODELIST_JSON = "/opt/oss/manager/etc/sysconf/nodelists.json"
BGP_OR_NORTH_FLOAT_IP = sys.argv[1]

def main():
    try:
        #生成参数
        params = _generate_params()
        if params == {}:
            my_log.info("No need remove bgp or north float ip")
        else:
            _remove_floatip(params)
            my_log.info(params)
    except Exception as e:
        my_log.info(e)
        return 1
    return 0

def _generate_params():
    with open(NODELIST_JSON, "rb") as _f:
        network_json = json.load(_f)
        network_json_list = network_json.get("nodeList")
    nodes = []
    params = {}
    for node_num in network_json_list:
        nodes.append(node_num[0])
    if len(nodes) < 2:
        my_log.info("single node env")
        return params
    else:
        my_log.info("three nodes env")
        bgp_list = network_json_list.get("1")
        my_log.info("bgp list:")
        my_log.info(bgp_list)
        north_list = network_json_list.get("2")
        my_log.info("north list:")
        my_log.info(north_list)
        if BGP_OR_NORTH_FLOAT_IP == "BGP":
            for ipaddress_info in bgp_list.get("IPAddresses"):
                if "BGP_FLOATIP" in str(ipaddress_info["usage"]):
                    my_log.info("BGP env in second node")
                    usages = ipaddress_info.get("usage", [])
                    usage = ','.join(usages)
                    ip = ipaddress_info["IP"]
                    params = {"delete": [{"nodeId": "1", "usage": usage, "IP": ip}]}
                    break
        elif BGP_OR_NORTH_FLOAT_IP == "NORTH_FLOATIP":
            for ipaddress_info in north_list.get("IPAddresses"):
                if "NORTH_FLOATIP" in str(ipaddress_info["usage"]):
                    my_log.info("NORTH_FLOATIP in third node")
                    ip = ipaddress_info["IP"]
                    usages = ipaddress_info.get("usage", [])
                    usage = ','.join(usages)
                    params = {"delete": [{"nodeId": "2", "usage": usage, "IP": ip}]}
                    break
    return params


# 删除浮动ip
def _remove_floatip(params):
    url = "/rest/productconfiguration/v1/ips?action=delete"
    response = easyhttpclient.http_post_with_retry(url, params, printlog=False)
    my_log.info(response)
    _refresh_maintenance_ip_info()
    return 0


def _refresh_maintenance_ip_info():
    my_log.info("start refresh maintenance ip cache.")
    _refresh_ips_cache_url = "/rest/plat/omp/v1/main/sysmt/nodes/nics/ipcache/action?action=refresh"
    params = {"diffIP": ""}
    response = easyhttpclient.http_post_with_retry(_refresh_ips_cache_url, params, printlog=True)
    my_log.info(f"Refresh successfully maintenance ip cache. response is {response}")


if __name__ == '__main__':
    main()
