
# coding=utf-8
import os
import json
import subprocess
import sys
from utils import set_log
from utils import utils
from utils import common_method

LOG = set_log.set_log(stream=True)


def main():
    ip = utils.get_local_ip()
    port = utils.get_ir_port()
    try:
        delete_inactive_package()
    except Exception:
        pass
    is_success = get_package_list(ip, port)

    if is_success:
        LOG.info(f"success")
        return "ok"
    else:
        LOG.WARNING(f"包管理检查项检查失败，请联系华为工程师处理。")
        return "no"


def delete_inactive_package():
    sql = "delete from T_PKGMGR_PACKAGE_INFO where PACKAGE_STATUS='INACTIVE' and OPERATION_STATUS='UNINSTALL_SUCCESS' "
    gauss_result = common_method.CommonMethod().exec_sql(db_type="zenith", instance_name='ncecommondb', db_name='repomgrservicedb', sql=sql)


def get_package_list(ip, port):
    url = '/rest/repomgrservice/v1/packages'
    hofs_commit_command = 'sudo -s -u ossuser /opt/oss/*/apps/HOFSOsdFileAgent/bin/hfscmd commit repo/repo/'
    result, response = utils.send_rest(ip, port, url, mode="GET",
                                log=LOG, sleep=2, retry_times=5,
                                content="")
    response_data = json.loads(response)
    pkg_info_list = response_data.get('data')

    hofs_non_exist_list = []
    path_list = [pkg_info.get('packagePath') for pkg_info in pkg_info_list]
    for path in path_list:
        if not check_file_exist(path):
            hofs_non_exist_list.append(path)
    if hofs_non_exist_list:
        LOG.info("need repair")
        for path in hofs_non_exist_list:
            full_path = os.path.join('/opt/backup/hfs/', path)
            path_exist = os.path.exists(full_path)
            if not path_exist:
                return False
        exitcode, output = _exec_cmd(hofs_commit_command)
        if exitcode != 0:
            return False
    return True


def check_file_exist(path):
    hofs_exist_command = 'sudo -s -u ossuser /opt/oss/*/apps/HOFSOsdFileAgent/bin/hfscmd ls {}'.format(path)
    not_exist_info = 'No such file'

    exitcode, output = _exec_cmd(hofs_exist_command)

    if exitcode != 0 and not_exist_info in output:
        return False
    return True


def _exec_cmd(cmd):
    exitcode, output = subprocess.getstatusoutput(cmd)
    LOG.info(f"exec_cmd {cmd}, exitcode={exitcode}, output={output}")
    return exitcode, output


