# -*- coding:utf-8 -*
'''
select_node_plan_base.py
'''
import json
import os
import sys


def select_ip():
    '''
    select_ip
    :return: ip
    '''
    dir_name = "/opt/oss/NCECOMMONE/apps/DCNService/etc/sysconf/nodelist.json"
    if not os.path.isfile(dir_name):
        dir_name = "/opt/oss/NCE/apps/DCNService/etc/sysconf/nodelist.json"
    _f = open(dir_name, 'rb')
    setting = json.load(_f)
    _i = 0
    while True:
        try:
            hostname = setting['nodeList'][str(_i)]['hostname']
            if hostname == 'OMP':
                get_value(setting, _i, 'OMP')
            if hostname == 'Data_Backup':
                get_value(setting, _i, "Data_Backup")
            if hostname == 'Service1':
                get_value(setting, _i, "Service1")
                break
            else:
                _i = _i + 1
        except KeyError:
            break
    _f.close()
    return _i


def get_value(setting, _i, hostname):
    '''
    get_value
    :param setting:
    :return: bool
    '''
    for servicename in setting['nodeList'][str(_i)]['IPAddresses']:
        if 'maintenance' in servicename['usage'] or \
                u'\u201c\u201d' in servicename['usage']:
            nms_ip_str = servicename['IP']
            print(
                hostname + nms_ip_str
            )
            break


def main():
    '''
    主函数
    :return:
    '''
    num = 2
    node = select_ip()
    if node == 2:
        num = 0
    elif node == 1:
        num = 1
    return num

sys.exit(main())
