'''
start product
'''
# coding=utf-8
import sys
import json
import time
from util import common, httpclient

PRODUCT_NAME = sys.argv[1]
OPERATE_TYPE = sys.argv[2]


def main():
    '''
    main
    :return:
    '''
    retry_times = 3
    client = httpclient.CommonHttpClient(common.getLocalIP(), common.getMgmtIRPort(), True, False)
    if OPERATE_TYPE == "start":
        for _i in range(retry_times):
            result = client.post(
                '/rest/plat/omp/v1/main/monitor/products/%s/action?action-id=START' % PRODUCT_NAME,
                {"type": "app"})
            if result[0] == 202:
                print("success")
                break
            else:
                if _i == retry_times - 1:
                    print("fail")
            time.sleep(15)
    else:
        result = client.get('/rest/plat/omp/v1/main/monitor/products/' + PRODUCT_NAME + '/status')
        if result[0] == 200:
            response_json = json.loads(result[1])
            if response_json["progress"] == 100 and response_json["status"].upper() == "RUNNING":
                print("success")
            else:
                print("starting")
        else:
            print("stoped")


if __name__ == '__main__':
    main()
