# -*- coding:utf-8 -*
'''
updatenodes_NCE.py
'''
import os
import json


def get_dir_name():
    '''
    get_dir_name
    :return:
    '''
    dir_name = "/opt/oss/manager/etc/sysconf/nodelists.json"
    return dir_name


def select_ip():
    '''
    select_ip
    :return:
    '''
    nms_ip_str1 = '1'
    dir_name = get_dir_name()
    _f = open(dir_name, 'rb')
    setting = json.load(_f)
    _i = 0
    while True:
        try:
            hostname = setting['nodeList'][str(_i)]['hostname']
            if hostname == 'OMP':
                nms_ip_str0 = get_value(setting, _i)
            if hostname == 'Data_Backup':
                nms_ip_str1 = get_value(setting, _i)
            if hostname == 'Service1':
                nms_ip_str2 = get_value(setting, _i)
                break
            else:
                _i = _i + 1
        except KeyError:
            break
    _f.close()
    list1 = []
    list1.append(nms_ip_str0)
    if nms_ip_str1 != '1':
        list1.append(nms_ip_str1)
        list1.append(nms_ip_str2)
    return list1


def get_value(setting, _i):
    '''
    get_value
    :param setting:
    :return: bool
    '''
    for servicename in setting['nodeList'][str(_i)]['IPAddresses']:
        if 'maintenance' in servicename['usage']:
            ip_str = servicename['IP']
            break
    return ip_str

def main():
    '''
    主函数
    :return:
    '''
    list1 = select_ip()
    if len(list1) > 1:
        ip1 = list1[0]
        ip2 = list1[1]
        ip3 = list1[2]
        _str = ip1 + ':9094,' + ip2 + ':9094,' + ip3 + ':9094'
    else:
        ip1 = list1[0]
        _str = ip1+':9094'
    print(
        _str)
    return _str

main()
