'''
set log
'''
import logging
import os


def set_log(stream=False, filename=None, level=logging.INFO, name="default"):
    '''
    set log
    :param stream: 是否输出到屏幕
    :param filename: 是否输出到文件
    :param level: 日志级别
    :param name: 日志名称
    :return: logger
    '''
    fmt = logging.Formatter(
        '%(asctime)s– %(levelname)s–%(pathname)s–%(lineno)d: %(message)s')
    logger = logging.getLogger(name)
    logger.setLevel(level)
    if stream:
        sh_stream = logging.StreamHandler()
        sh_stream.setFormatter(fmt)
        logger.addHandler(sh_stream)
    if filename:
        sh_file = logging.FileHandler(filename, encoding="utf-8")
        sh_file.setFormatter(fmt)
        logger.addHandler(sh_file)
    return logger


if __name__ == '__main__':
    LOG = set_log(stream=True, filename=os.path.join(os.getcwd(), "log.log"))
    LOG.info("你好")
