'''
    常用函数
'''
import os
import subprocess
import time
from util.httpclient import CommonHttpClient
from util import common


def get_local_ip():
    '''
    获取本地ip地址
    :return: ip
    '''
    if hasattr(common, "getLocalIP"):
        return common.getLocalIP()
    else:
        return common.get_local_ip()


def get_ir_port():
    '''
    获取ir的端口号
    :return:
    '''
    if hasattr(common, "getIRAccessPort"):
        return common.getIRAccessPort()
    else:
        return common.get_ir_access_port()

def get_gmt_port():
    '''
    获取gmt ir的端口号
    :return:
    '''
    if hasattr(common, "getMgmtIRPort"):
        return common.getMgmtIRPort()
    else:
        return common.get_mgmt_ir_port()


def send_rest(_ip, port, url, mode, **params):
    '''
    调用平台res
    :param ip: ip地址
    :param port: 端口
    :param url: url
    :param mode: GET POST DELETE
    :params log, body, sleep, retry_times, content
    :return: 成功 0  失败 1
    '''
    http = CommonHttpClient(_ip, port, True, False)
    times = 0
    success = 0
    req_failed = 1
    body = params.get("body", None)
    while times <= params["retry_times"]:
        if mode == "GET":
            status, ret = http.get(url)
        elif mode == "POST":
            status, ret = http.post(url, body)
        elif mode == "DELETE":
            status, ret = http.delete(url, body)
        elif mode == "PUT":
            status, ret = http.put(url)
        if status == 200 or status == 204:
            result = success
            params["log"].info("%s [SUCCESS] %s %s response: %s, retry_times:%s",
                               params["content"], mode, url, status, times)
            break
        else:
            params["log"].error("%s [FAILE] %s %s response: %s, retry_times:%s",
                                params["content"], mode, url, status, times)
            times += 1
            result = req_failed
            time.sleep(params["sleep"])
    return result, ret

