# encoding=utf-8
"""
功 能：自动获取定制升级参数配置页面
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import json
import logging
import os
from copy import deepcopy
import subprocess

LOCAL_LOGGER = logging.getLogger(__name__)


def set_upgrade_item(page_list):
    """
    功能说明:解析升级方案和参数规划页面获取
    :param page_list
    """
    os_type = subprocess.getstatusoutput("cat /etc/*release | grep -i suse")[1]
    page_data = page_list[0].get('pages')
    control_sets = page_data[0].get("control_sets")
    upgrade_param_config_list = ["upgrade_param_config1", "upgrade_param_config2"]
    need_del_controls = {}
    for index1, control_set_order in enumerate(control_sets):
        controls = control_set_order.get('controls')
        if control_set_order.get("id") == "upgrade_scenario_config":
            for index2, control_order in enumerate(controls):
                if control_order.get('id') == 'upgrade_item' \
                        and control_order.get('type') == 'upgrade_checkbox_group':
                    if "suse" in os_type.lower():
                        control_order.update(
                            {'upgrade_checkbox_group.range':
                                 '{"V100R022C00SPC185": "id_upgrade_nce,id_upgrade_arbitration"}',
                             'validation_range.text_zh':
                                 '{"V100R022C00SPC185": {"id_upgrade_nce": "NCE", "id_upgrade_arbitration":"仲裁"}}',
                             'validation_range.text_en':
                                 '{"V100R022C00SPC185": {"id_upgrade_nce": "NCE", "id_upgrade_arbitration":"ARB"}}',
                             'upgrade_checkbox_group.depends':
                                 '{"V100R022C00SPC185": {"id_upgrade_arbitration": "id_upgrade_nce"}}'
                             })
                    else:
                        control_order.update(
                            {'upgrade_checkbox_group.range':
                                 '{"V100R022C00SPC185": "id_upgrade_os,id_upgrade_nce,id_upgrade_arbitration,'
                                 'id_two_hop_upgrade"}',
                             'validation_range.text_zh':
                                 '{"V100R022C00SPC185": {"id_upgrade_os": "OS", '
                                 '"id_upgrade_nce": "NCE", "id_upgrade_arbitration":"仲裁", '
                                 '"id_two_hop_upgrade": "是否连续升级两跳"}}',
                             'validation_range.text_en':
                                 '{"V100R022C00SPC185": {"id_upgrade_os": "OS", '
                                 '"id_upgrade_nce": "NCE", "id_upgrade_arbitration":"ARB", '
                                 '"id_two_hop_upgrade": "Whether to upgrade two hops consecutively"}}',
                             'upgrade_checkbox_group.depends':
                                 '{"V100R022C00SPC185": {"id_upgrade_os": "id_upgrade_nce", '
                                 '"id_upgrade_arbitration": "id_upgrade_nce"}}'
                             })
        elif control_set_order.get("id") in upgrade_param_config_list:
            control_set_order.update({'headers': "站点,节点,IP,sopuser用户密码,ossadm用户密码,root用户密码"})
            control_set_order.update({'headers_zh': "站点,节点,IP,sopuser用户密码,ossadm用户密码,root用户密码"})
            control_set_order.update(
                {'headers_en': "Site,Node,IP,sopuserUserPassword,ossadmUserPassword,rootUserPassword"})
            index_control_set = index1
            controls_copy = deepcopy(controls)
            if control_set_order.get("id") == "upgrade_param_config1":
                for dic in controls:
                    if dic.get("id") == "node_ip" or dic.get("id") == "node_ip_standby":
                        for dic2 in dic.get("controls"):
                            if dic2.get("id") == "node_omp01_ip" or dic2.get("id") == "node_standby_omp01_ip":
                                dic2.update({"visible": "true"})
                                dic2.update({"dependsAction": ""})
                                dic2.update({"type": "labelfield"})
                            elif dic2.get("id") == "node_common_service01_ip" or dic2.get("id") == "node_standby_common_service01_ip":
                                dic2.update({"visible": "true"})
                                dic2.update({"dependsAction": "arbitration_show"})
                                dic2.update({"dependsOp": "include"})
                                dic2.update({"dependsValue": "id_upgrade_arbitration"})
                                dic2.update({"type": "labelfield"})
                key = "node_ip, node_ip_standby"
                need_del_controls[key] = {
                    "upgrade_param_config": control_set_order.get("id"),
                    "node_ip": "node_ip",
                    "node_ip_standby": "node_ip_standby",
                    "node_ip_before_id": "node_info",
                    "node_ip_standby_before_id": "node_info_standby",
                    "index_control_set": index_control_set,
                    "controls_copy": controls_copy
                }
            if control_set_order.get("id") == "upgrade_param_config2":
                key = "node_nmsserver_ip, node_standby_nmsserver_ip"
                need_del_controls[key] = {
                    "upgrade_param_config": control_set_order.get("id"),
                    "node_ip": "node_nmsserver_ip",
                    "node_ip_standby": "node_standby_nmsserver_ip",
                    "node_ip_before_id": "node_nmsserver",
                    "node_ip_standby_before_id": "node_nmsserver_standby",
                    "index_control_set": index_control_set,
                    "controls_copy": controls_copy
                }
            for index2, control_order in enumerate(controls):
                if control_order.get('id') in key:
                    control_order.update({"visible": "true"})
                    control_order.update({"dependsAction": ""})
                    if need_del_controls[key].get('upgrade_param_config') == "upgrade_param_config1":
                        control_order.update({"type": "group"})
                    else:
                        control_order.update({"type": "string"})
                    node_ip = need_del_controls[key]["node_ip"]
                    node_ip_standby = need_del_controls[key]["node_ip_standby"]
                    if control_order.get('id') == node_ip:
                        need_del_controls[key]["control_order_node_nmsserver_ip"] = deepcopy(control_order)
                    elif control_order.get('id') == node_ip_standby:
                        need_del_controls[key]["control_order_node_standby_nmsserver_ip"] = deepcopy(control_order)

    for value in need_del_controls.values():
        index_control_set = value["index_control_set"]
        controls_copy = value["controls_copy"]
        node_ip_before_id = value["node_ip_before_id"]
        node_ip_standby_before_id = value["node_ip_standby_before_id"]
        control_order_node_nmsserver_ip = value["control_order_node_nmsserver_ip"]
        control_order_node_standby_nmsserver_ip = value["control_order_node_standby_nmsserver_ip"]
        controls_copy = del_controls(controls_copy, node_ip_before_id, control_order_node_nmsserver_ip)
        controls_copy = del_controls(controls_copy, node_ip_standby_before_id, control_order_node_standby_nmsserver_ip)
        control_sets[index_control_set]["controls"] = controls_copy
    return page_list


def get_ip(num):
    '''
    :param num: ip's id
    :return:
    '''
    _ip = ""
    file_name = "/opt/oss/manager/etc/sysconf/nodelists.json"
    if os.path.exists(file_name):
        with open(file_name, "rb") as node_f:
            node_info = json.load(node_f)
            for dic in node_info["nodeList"][str(num)]["IPAddresses"]:
                if "maintenance" in dic["usage"]:
                    _ip = dic["IP"]
    return _ip


def del_controls(controls_copy, need_add_after_ip, dic):
    '''
    :param controls_copy: controls_copy
    :param need_add_after_ip: 在此IP后添加dic
    :param dic: 需要被添加的dic，同时需要被删除
    :return:
    '''
    need_del_ip = dic.get("id")
    controls_copy_copy = deepcopy(controls_copy)
    for index, control_order in enumerate(controls_copy):
        if control_order.get("id") == need_add_after_ip:
            controls_copy_copy.insert(index + 1, dic)
    for index, control_order in enumerate(controls_copy_copy):
        if control_order.get("id") == need_del_ip:
            need_del_index = index
    controls_copy_copy.pop(need_del_index)
    return controls_copy_copy

def exe(upgrade_params, page_list):
    """
    功能说明:自动获取定制升级页面
    :param upgrade_params
    :param page_list
    :return 无定制直接返回page_list, 定制化失败默认返回False
    """
    LOCAL_LOGGER.info(upgrade_params)
    return set_upgrade_item(page_list)

def exe_upgrade_items(upgrade_params):
    """
    功能说明:自动获取定制升级参数
    :param upgrade_params
    :return upgrade_params
    """
    # 定制升级参数

    return upgrade_params
