'''
check omp upgrade
'''
# -*- coding:utf-8 -*-
import logging
import json
import zipfile
import os
import subprocess
import copy

from utils.log_util import EasysuiteLogger
from easysuite import settings

LOCAL_LOGGER = logging.getLogger(__name__)


def delete_omp_upgrade_config():
    '''
    delete_omp_upgrade_config
    :return:
    '''
    config_path = "/opt/oss/easysuite/easysuite/plugins/" \
                  "iMasterNCE-Fabric/upgrade_online/service/config"
    if not os.path.exists(config_path):
        config_path = "/opt/oss/easysuite/easysuite/easysuite/plugins/" \
                  "iMasterNCE-Fabric/upgrade_online/service/config"
    one_site_json = os.path.join(config_path, "upgradebusiness_onesite.json")
    dr_site_json = os.path.join(config_path, "upgradebusiness_drsite.json")
    json_list = [one_site_json, dr_site_json]
    for input_json in json_list:
        with open(input_json, 'r') as fr_input:
            json_input = json.loads(fr_input.read())
        pkgs = json_input["steps"]
        for index, pkg in enumerate(pkgs):
            if pkg["taskname"] == "upgrade" and pkg["site"] == "master":
                child_steps_master = pkgs[index]["child_steps"]
                delete_omp_upgrade(child_steps_master)
            if pkg["taskname"] == "upgrade" and pkg["site"] == "standy":
                child_steps_standy = pkgs[index]["child_steps"]
                delete_omp_upgrade(child_steps_standy)
            if pkg["taskname"] in ["rollback", "rollback_master", "rollback_standy"]:
                child_steps_rollback = pkgs[index]["child_steps"]
                delete_omp_rollback(child_steps_rollback)
        json_data_string = json.dumps(json_input, indent=4, separators=(',', ': '))
        with open(input_json, 'w') as _f:
            _f.write(json_data_string)


def delete_omp_upgrade(child_steps):
    '''
    delete_omp_upgrade
    :param child_steps:
    :return:
    '''
    child_steps_bak = copy.deepcopy(child_steps)
    for task_name in child_steps_bak:
        if task_name["name"] in ["upgrade_osmediation", "upgrade_omp",
                                 "backup_single_uniep", "update_mgr_db"]:
            child_steps.remove(task_name)


def delete_omp_rollback(child_steps):
    '''
    delete_omp_rollback
    :param child_steps:
    :return:
    '''
    child_steps_bak = copy.deepcopy(child_steps)
    for task_name in child_steps_bak:
        if task_name["name"] in ["rollback_osmediation", "rollback_omp", "rollback_mgr_db"]:
            child_steps.remove(task_name)


def query_env_omp_version():
    """
    功能描述：查询当前环境OMP版本
    :param :
    :return: 环境OMP版本号
    """
    command = """cat /opt/oss/manager/var/share/software_define.yaml |
     grep "softwareVersion" | awk -F ":" '{print $2}'"""
    _, result = subprocess.getstatusoutput(command)
    env_omp_version = result.strip()
    return env_omp_version


def query_pkg_omp_version(cpu_type):
    """
    功能描述：查询升级包中OMP版本
    :param cpu_type:cpu类型
    :return: 升级包中OMP版本号
    """
    # 先获取upgradeconfig.json中OMP版本号
    upgrade_config_json = "/opt/oss/easysuite/easysuite/plugins/" \
                          "iMasterNCE-Fabric/upgrade_online/website/data/upgradeconfig.json"
    if not os.path.exists(upgrade_config_json):
        upgrade_config_json = "/opt/oss/easysuite/easysuite/easysuite/plugins/" \
                              "iMasterNCE-Fabric/upgrade_online/website/data/upgradeconfig.json"
    with open(upgrade_config_json, 'r') as fr_input:
        json_load = json.loads(fr_input.read())
    upgrade_config_dict = json_load["upgradeconfig"][0]["packages"]
    for package in upgrade_config_dict:
        if "OMP" in package["packagename"] and cpu_type in package["cpu_type"]:
            omp_dcn_version = str(package["packagename"])
            break
    # 解压并读取yaml中OMP版本号
    pkg_omp_version = query_yaml(omp_dcn_version)
    return pkg_omp_version

def query_cpu_type():
    """
    功能描述:判断x86或者arm
    :return: cpu类型
    """
    command = "uname -p"
    result = subprocess.Popen(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
    result.wait()
    cpu_version = result.stdout.read().decode().strip()
    if cpu_version == "x86_64":
        cpu_type = "X86"
    else:
        cpu_type = "ARM"
    return cpu_type


def query_yaml(omp_dcn_version):
    """
    功能描述:解压OMP包并读取yaml中OMP版本号
    :param 读到的DCN中OMP版本号
    :return:yaml中版本号
    """
    # 解压OMP包至/opt/upgrade/omp_temp
    omp_path = os.path.join("/opt/upgrade", omp_dcn_version)
    omp_temp_path = "/opt/upgrade/omp_temp"
    if os.path.exists(omp_temp_path):
        command = "rm -rf %s" % omp_temp_path
        result = subprocess.Popen(command.split(), stdout=subprocess.PIPE, stdin=subprocess.PIPE)
        result.wait()
    os.mkdir(omp_temp_path)
    with zipfile.ZipFile(omp_path, 'r') as zipf:
        zipf.extractall(omp_temp_path)
    # 读取包中yaml
    omp_dcn_yaml_path = os.path.join(omp_temp_path, "tools/template/software_define.yaml")
    if not os.path.exists(omp_dcn_yaml_path):
        omp_dcn_yaml_path = os.path.join(omp_temp_path, "software_define.yaml")
    command = """cat %s | grep "softwareVersion"|awk -F ":" '{print $2}'""" % omp_dcn_yaml_path
    _, result = subprocess.getstatusoutput(command)
    pkg_omp_version = result.strip()
    return pkg_omp_version


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: 检查结果
    """
    src_version = str(kvs.get('upgrade_scenario_config.src_version'))
    if "V100R022C00" in src_version:
        return True
    else:
        return False


def exe(kvs):
    """ execute precheck upgrade omp """
    logger = EasysuiteLogger.get_logger(kvs, "task_check_omp_pkg")
    logger.easysuite_start("Begin to check")

    # 查询环境上OMP版本
    env_omp_version = query_env_omp_version()
    logger.easysuite_info("Env OMP version is %s" % env_omp_version)

    # 查询升级包中OMP版本
    ## 判断x86或arm
    cpu_type = query_cpu_type()
    logger.easysuite_info("CPU type is %s" % cpu_type)

    ## 读取升级包中OMP版本号
    pkg_omp_version = query_pkg_omp_version(cpu_type)
    logger.easysuite_info("pkg OMP version is %s" % pkg_omp_version)

    ## 比较OMP版本
    if env_omp_version == pkg_omp_version:
        logger.easysuite_finish("The same OMP version, skip upgrade")
        delete_omp_upgrade_config()
    else:
        logger.easysuite_finish("The OMP version is not same, skip it")
    return True
