#!/bin/bash

################################################################################
# name    :    get_param
# describe:    give param to serverinfo.json
# parameter list: null
# input      : null
# output  : 0 success 1 failure
# rerurn  : null
# invoker : paramconfig.json
################################################################################

CUR_PATH=$(cd $(dirname $0);pwd)
INSTALL_ROOT="/opt/oss"


PLUGIN_DIR=/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online
LOG_BASE_DIR=$(sh ${PLUGIN_DIR}/service/scripts/get_log_dir.sh)
FLAG_DIR=${PLUGIN_DIR}/service/scripts/flag_dir
if [[ -d ${FLAG_DIR} ]]
then
    rm -rf ${FLAG_DIR}
fi
mkdir -p ${FLAG_DIR}


#创建日志目录
DATE="`date +%Y%m%d%H%M%S`"
LOG_DIR="${LOG_BASE_DIR}/upgrade_info_common${DATE}"
mkdir -p ${LOG_DIR}

#check current user
function checkUser()
{
    cur_user=`id -un`
    [ ${cur_user} == "ossadm" ] && return 0
    echo "`date +%Y%m%d%H%M%S` [ERROR] The script must run with ossadm user."
    exit 1
}

function deal_version()
{
    local version=${1}
    local v_version=$(echo ${version} | grep -oiE 'V[0-9]+')
    local r_version=$(echo ${version} | grep -oiE 'R[0-9]+')
    local c_version_group=$(echo ${version} | grep -oiE 'C[0-9]+')
    local c_version_array=(${c_version_group// / })
    local c_version=${c_version_array[0]}
    local v_r_c_version=${v_version}${r_version}${c_version}
    # R版本转化为数字
    local r_version_number=$(echo ${r_version} | grep -oiE '[0-9]+')
    local c_version_number=$(echo ${c_version} | grep -oiE '[0-9]+')
    local r_c_version_number=$(echo ${r_version_number}${c_version_number} | awk '{print int($0)}')
    echo "${v_r_c_version},${r_c_version_number}"
}

function queryParam()
{
    echo "$(date '+%Y-%m-%d %H:%M:%S') start prepare scripts"
    bash ${PLUGIN_DIR}/service/extend/prepare_rollback_scripts.sh || exit 1

    des_version=V100R022C00SPC185

    #导入环境变量
    . "${INSTALL_ROOT}"/manager/bin/engr_profile.sh

    #查出当前环境所有信息
    "${INSTALL_ROOT}"/manager/tools/resmgr/queryproduct.sh -pn all -output ${LOG_DIR}
    if [ $? != 0 ]
    then
        echo "`date +%Y%m%d%H%M%S` [ERROR] can not find any product"
        exit 2
    fi


    #替换backup_uniep.py 替换管理面备份定制脚本，仅备份管理面db软件和数据
    des_backup_uniep_path="/opt/oss/easysuite/easysuite/easysuite/plugins/common/NCE-Common/upgrade_online/service/scripts/pyscripts"
    src_backup_uniep_path="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online/service/scripts/pyscripts"
    cp -af $src_backup_uniep_path/backup_uniep.py $des_backup_uniep_path
    chmod 550 $des_backup_uniep_path/backup_uniep.py

    # 修改easysuite脚本中升级管理面数据软件超时为一小时: 将 bash ${DB_UPGRADE} 改为 bash ${DB_UPGRADE} -timeout 60
    [[ -z $(find /opt/oss/easysuite/easysuite/ -name update_mgr_db.sh | xargs grep -ril "bash \${DB_UPGRADE} -timeout") ]] && find /opt/oss/easysuite/easysuite/ -name update_mgr_db.sh | xargs sed -i "s/bash \${DB_UPGRADE}/bash \${DB_UPGRADE} -timeout 60/g"

    src_backup_uniep_path="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online/service/scripts/pyscripts"


    #判断NCE或NCECOMMONE
    if [ -f ${LOG_DIR}/product_NCECOMMONE.json ]
    then 
        echo "`date +%Y%m%d%H%M%S` [INFO] NCECOMMONE scenario"
        local TENANT_NAME="NCECOMMONE"
    elif [   -f ${LOG_DIR}/product_NCE.json ]
    then
        echo "`date +%Y%m%d%H%M%S` NCE Scenario"
        local TENANT_NAME="NCE"
    else
        echo "`date +%Y%m%d%H%M%S` [ERROR] current scenario is not NCE or NCECOMMONE, can not support." >> ${LOG_DIR}/excute.log
        exit 2
    fi
    local product_name=$(${PYTHONHOME}/bin/python -c "import json;f=open('${LOG_DIR}/product_$TENANT_NAME.json','r');obj=json.load(f);f.close();print (obj['productname'])")
    local product_version=$(${PYTHONHOME}/bin/python -c "import json;f=open('${LOG_DIR}/product_$TENANT_NAME.json','r');obj=json.load(f);f.close();print (obj['productext']['product_version'])")
    #用于新增参数uniopornic值的获取
    local SouthInterface=$(${PYTHONHOME}/bin/python -c "import json;f=open('${LOG_DIR}/product_$TENANT_NAME.json','r');obj=json.load(f);f.close();print (obj['productext']['SouthInterface'])")

    #判断是否需要SecoManager
    local basesm=`cat ${LOG_DIR}/product_$TENANT_NAME.json |grep -w basesm`
    local is_seco_installed="FALSE"
    if [ "${basesm}X" != "X" ]; then
        is_seco_installed="TRUE"
    fi
    #判断是否需要MDC
    local mdc=`cat ${LOG_DIR}/product_$TENANT_NAME.json |grep -w MDC_DEPLOYMENT_TYPE`
    local is_mdc_not_needed="TRUE"
    if [ "${mdc}X" != "X" ]; then
        is_mdc_not_needed="FALSE"
    fi

    # 源版本处理
    local src_version_info=$(deal_version ${product_version})
    local src_version_array=(${src_version_info//,/ })
    local src_v_r_c_version=${src_version_array[0]}
    local src_r_c_version_number=${src_version_array[1]}

    # 目标版本处理
    local des_version_info=$(deal_version ${des_version})
    local des_version_array=(${des_version_info//,/ })
    local des_v_r_c_version=${des_version_array[0]}
    local des_r_c_version_number=${des_version_array[1]}

    # 产品名称的判断
    local product_name2="iMaster NCE-Fabric"
    if [[ ${src_r_c_version_number} -eq 190 ]]
    then
        local product_name2="AgileController-DCN"
    fi

    # 升级指导书名的确定
    local upgrade_software_zh="《${product_name2} ${src_v_r_c_version}-${des_version}升级指导书》。"
    local upgrade_software_en="see the 《${product_name2}  ${src_v_r_c_version} to ${des_version} Upgrade Guide》."
    if [[ ${src_r_c_version_number} -eq ${des_r_c_version_number} ]]
    then
        local upgrade_software_zh="《${product_name2} ${des_version}升级指导书》。"
        local upgrade_software_en="see the 《${product_name2} ${des_version} Upgrade Guide》."
    fi
    local i18n_path="/opt/oss/easysuite/easysuite/easysuite/plugins/iMasterNCE-Fabric/upgrade_online/website/i18n"
    sed -i "s/UPGRADE_SOFTWARE_ZH/${upgrade_software_zh}/g" $i18n_path/zh_CN.properties
    sed -i "s/UPGRADE_SOFTWARE_EN/${upgrade_software_en}/g" $i18n_path/en_US.properties



    # 参数的确定
    local sql="select * from T_DEFAULT_OPSET_OP_RELATION where OPID like '%portmirror%' "
    local instance_name="dcnnwcommondb"
    local db_name="privilegedb"
    local db_type="zenith"
    local is_bksign_needed="TRUE"
    local is_r19C00_needed="false"
    local is_r20C00_needed="false"
    local is_migrate_needed="false"
    local show_switch_kmc="true"
    local is_r19_needed="false"
    local is_secondphase="false"
    local is_import_log="true"
    if [[ ${src_r_c_version_number} -eq 1900 ]]
    then
        local sql="select * from T_AUTH_PERMISSION_GROUPS where id='DCNService:com.huawei.sdn.acdcn.portmirror' "
        local is_bksign_needed="FALSE"
        local is_r19C00_needed="true"
        local is_migrate_needed="true"
        local is_r19_needed="true"
        local db_type="gauss"
        local instance_name="ncecommondb"
        local db_name="authadmindb"
    elif [[ ${src_r_c_version_number} -eq 1910 ]]
    then
        local sql="select * from T_AUTH_PERMISSION_GROUPS where id='DCNService:com.huawei.sdn.acdcn.portmirror' "
        local is_migrate_needed="true"
        local is_r19_needed="true"
        local db_type="gauss"
        local instance_name="ncecommondb"
        local db_name="authadmindb"
    elif [[ ${src_r_c_version_number} -eq 2000 ]]
    then
        local sql="select * from T_AUTH_PERMISSION_GROUPS where id='DCNService:com.huawei.sdn.acdcn.portmirror' "
        local is_r20C00_needed="true"
        local is_migrate_needed="true"
        local instance_name="ncecommondb"
        local db_name="authadmindb"
    elif [[ ${src_r_c_version_number} -eq 2010 ]]
    then
        local is_migrate_needed="true"
        local instance_name="ncecommondb"
    fi

    # 这里是大于20.1
    if [[ ${src_r_c_version_number} -gt 2010 ]]
    then
        local is_import_log="false"
    fi

    # 这里是大于等于21.1
    if [[ ${src_r_c_version_number} -ge 2110 ]]
    then
        local show_switch_kmc="false"
        local is_secondphase="true"
    fi

    #判断节点数
    node_num=$($PYTHONHOME/bin/python get_node_number.py $TENANT_NAME)
    case $node_num in
    1)
        deployment_plan="C01"
        ;;
    3)
        deployment_plan="C03"
        ;;
    5)
        deployment_plan="C05"
        ;;
    7)
        deployment_plan="C07"
        ;;
    9)
        deployment_plan="C09"
        ;;
    *)
        local deployment_plan=""
    esac
    
    #增加MDC场景
    if [ ${is_mdc_not_needed} == "FALSE" ];then
        deployment_plan="MDC03"
    fi
    
    if [ "${deployment_plan}X" == "X" ]; then
        echo "`date +%Y%m%d%H%M%S` [ERROR] current software do not support upgrade to this version."
        exit 2
    fi
    
    #判断X86或ARM
    cpu_version=$(uname -p)
    if [ "$cpu_version" == "x86_64" ]
    then
        cpu_type="X86"
    elif [ "$cpu_version" == "aarch64" ]
    then
        cpu_type="ARM"
    else
        echo "`date +%Y%m%d%H%M%S` [ERROR] current os do not support upgrade to this version."
        exit 2
    fi

    # 判断分区是否符合在线升级的条件
    local os_upgrade_online="false"
    has_root_bak=$(lsblk | grep root_bak)
    has_var_bak=$(lsblk | grep var_bak)
    has_usr_bak=$(lsblk | grep usr_bak)
    if [[ -n ${has_root_bak} ]] && [[ -n ${has_var_bak} ]] && [[ -n ${has_usr_bak} ]]
    then
        os_upgrade_online="true"
    else
        has_swap=$(lsblk | grep swap)
        if [[ ! -z ${has_swap} ]]
        then
            is_swap_used=$(swapon -s)
            # 为空，说明没有被使用
            if [[ -z ${is_swap_used} ]]
            then
                size=$(lsblk -l -o NAME,SIZE | grep -w vg_root-swap | awk '{print $2}')
                size_num_float=$(echo ${size} | grep -oiE '[0-9]+')
                # 取整数部分
                size_num=$(echo ${size_num_float} | awk '{print $1}')
                size_unit=$(echo ${size} | grep -oiE '[a-z]+')
                if [[ ${size_num} -ge 32 ]] && [[ ${size_unit} == "G" ]]
                then
                    os_upgrade_online="true"
                fi
            fi
        fi
    fi


    # v2r10不回滚
    local is_rollback_os="true"
    is_v2r10=$(uname -r | grep v2r10)
    if [[ ! -z ${is_v2r10} ]]
    then
        is_rollback_os="false"
    fi

    # 是否安装端口镜像
    local is_portmirror_installed="FALSE"
    portmirror_installed=${FLAG_DIR}/portmirror_installed.txt
    if [[ -f ${portmirror_installed} ]]
    then
        rm -rf ${portmirror_installed}
    fi
    cd ${PLUGIN_DIR}/service/scripts/pyscripts/utils
    return_result=$(${PYTHONHOME}/bin/python -c "import common_method;print(common_method.CommonMethod().exec_sql('${db_type}', '${instance_name}', '${db_name}', sql='''$sql''', return_content=1))")
    if [[ $? == "0" ]];then
        if [[ $(echo $return_result| grep portmirror | wc -l) -gt 0 ]]
        then
            touch ${portmirror_installed}
            local is_portmirror_installed="TRUE"
        fi
    else
        echo "`date +%Y%m%d%H%M%S` [INFO] Check whether installed portmirror failed. Failed to get portmirror permissions. "
        exit 3
    fi


    #生成规划信息serverinfo*.json
    echo "{
    \"fabric_name\": \"AC-DCN\",
    \"product\": \"iMasterNCE-Fabric\",
    \"product_name\": \"${product_name}\",
    \"tenant_name\": \"${TENANT_NAME}\",
    \"product_version\": \"${product_version}\",
    \"deployment_plan\": \"$deployment_plan\",
    \"sceneid\": \"iMasterNCE-Fabric\",
    \"is_productpkg_add\": {\"${product_name}\": \"TRUE\"},
    \"is_mdc_not_needed\": {\"${product_name}\": \"${is_mdc_not_needed}\"},
    \"is_seco_installed\": {\"${product_name}\": \"${is_seco_installed}\"},
    \"is_bksign_needed\": {\"${product_name}\": \"${is_bksign_needed}\"},
    \"is_portmirror_installed\": {\"${product_name}\": \"${is_portmirror_installed}\"},
    \"offline_commone\": {\"${product_name}\": \"TRUE\"},
    \"is_r19C00_needed\": \"$is_r19C00_needed\",
    \"is_r19_needed\": \"$is_r19_needed\",
    \"is_r20C00_needed\": \"$is_r20C00_needed\",
    \"is_rollback_os\": \"$is_rollback_os\",
    \"is_import_log\": \"$is_import_log\",
    \"os_upgrade_online\": \"$os_upgrade_online\",
    \"show_switch_kmc\": \"$show_switch_kmc\",
    \"is_secondphase\": \"$is_secondphase\",
    \"is_migrate_needed\": \"$is_migrate_needed\",
    \"is_single_manager_domain\": \"true\",
    \"SouthInterface\": \"${SouthInterface}\"
}" > ${CUR_PATH}/serverinfoiMasterNCE-Fabric.json
    cp ${CUR_PATH}/serverinfoiMasterNCE-Fabric.json ${LOG_DIR}/
}


checkUser
queryParam >> ${LOG_DIR}/excute.log 2>&1
result=$?
if [ ${result} -eq 0 ]
then
    echo "`date +%Y%m%d%H%M%S` [INFO] paramcfgiMasterNCE-Fabric.sh script run successfully "
    echo 0
elif [ ${result} -eq 2 ]
then
    echo "`date +%Y%m%d%H%M%S` [ERROR] Not a Correct Scenario"
    echo 2
else
    echo "`date +%Y%m%d%H%M%S` [ERROR] paramcfgiMasterNCE-Fabric.sh script run faied!"
    echo 1
fi


