#!/bin/bash

handle_type=$1
log "handle_type is : ${handle_type}"
run_log=${MIGRATE_DATA_DIR}/logs/run.log
auth_file_back_path=${MIGRATE_DATA_DIR}/data/file/AuthService

function get_py_file()
{
    local py_file=$1
    [[ ! -f $py_file ]] && py_file="${py_file}c"
    echo ${py_file}
}

function copy_token_cert_file()
{
    sudo -u secuser sh -c "cp -r /tmp/certificatemanager ${OSS_SHARE_DIR}SMLogLicService/etc/"
    sudo -u secuser sh -c "chmod 700 ${OSS_SHARE_DIR}SMLogLicService/etc/certificatemanager"
    sudo -u secuser sh -c "chmod -R 600 ${OSS_SHARE_DIR}SMLogLicService/etc/certificatemanager/*"
}

function import_auth_file()
{
    sm_service_ip_list=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global |grep smloglicservice | awk '$3=="SMLogLicService" {print $6}')
    if [[ -z "$sm_service_ip_list" ]]
    then
        product_name=`find /opt/oss/*/apps/ -name SMLogLicService | cut -d'/' -f4`
        log "product name is ${product_name}."
        GET_SERVICE_NODE_IP=$(get_py_file ${MIGRATE_ROOT}/src/utils/get_service_nodesip.py)
        sm_service_ip_list=$(python ${GET_SERVICE_NODE_IP} ${product_name} SMLogLicService)
        if [[ -z "$sm_service_ip_list" ]]
        then
            log "sm_service_ip_list not exist."
            return
        fi
    fi
    if [[ ! -d ${auth_file_back_path}/certificatemanager ]]
    then
        log "back etc certificate manager not exist."
        return
    fi
    chmod -R 777 ${auth_file_back_path}/certificatemanager
    cp -rf ${auth_file_back_path}/certificatemanager /tmp
    chmod -R 777 /tmp/certificatemanager
    serial_num=`openssl x509 -in /tmp/certificatemanager/ca.pem -noout -serial | awk -F"=" '{print $2}'`
    log "serial_num is: ${serial_num}"
    if [[ -z ${serial_num} ]] || [[ "762560022A475EECA62B7C68AC9B3F2986" == "${serial_num}" ]] || [[ "F26A7B86F1FFF3B4" == "${serial_num}" ]]
    then
        log "etc certificate is default, no need copy."
        return
    fi
    for service_ip in ${sm_service_ip_list}
    do
        log "import_auth_file token execute ip: ${service_ip}"
        if [[ ${service_ip} == ${CURRENT_SERVER_IP} ]]
        then
            copy_token_cert_file
            continue
        fi
        scp -r -o 'StrictHostKeyChecking no' -o 'BatchMode yes' -o 'ConnectTimeout 5' /tmp/certificatemanager $(convert_ipv6 ${service_ip}):/tmp/
        ssh -o StrictHostKeyChecking=no ossadm@${service_ip} << EOF
chmod -R 777 /tmp/certificatemanager
sudo -u secuser sh -c "cp -r /tmp/certificatemanager ${OSS_SHARE_DIR}SMLogLicService/etc/"
sudo -u secuser sh -c "chmod 700 ${OSS_SHARE_DIR}SMLogLicService/etc/certificate ${OSS_SHARE_DIR}SMLogLicService/etc/certificatemanager"
sudo -u secuser sh -c "chmod -R 600 ${OSS_SHARE_DIR}SMLogLicService/etc/certificate/* ${OSS_SHARE_DIR}SMLogLicService/etc/certificatemanager/*"
rm -rf /tmp/certificatemanager
exit
EOF
    done
    rm -rf /tmp/certificatemanager
}

function copy_saml_sp_current_ip()
{
    basic_website_share=$(ls -d /opt/oss/share/*/SMLogLicWebsite 2>/dev/null | head -n1)
    if [[ ! -d ${basic_website_share}/etc/saml/certificate ]]; then
        sudo -u secuser sh -c "mkdir -p ${basic_website_share}/etc/saml/certificate"
    fi
    sudo -u secuser sh -c "cp -rfp /tmp/cert_sp/* ${basic_website_share}/etc/saml/certificate"
    sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml"
    sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml/certificate"
    sudo -u secuser sh -c "chmod -R 600 ${basic_website_share}/etc/saml/certificate/*"
    sudo -u secuser sh -c "rm -rf ${basic_website_share}/etc/saml/certificate/sp.keystore"
    sudo -u secuser sh -c "rm -rf ${basic_website_share}/etc/saml/certificate/security-config.properties"
}

function copy_saml_idp_current_ip()
{
    basic_website_share=$(ls -d /opt/oss/share/*/SMLogLicWebsite 2>/dev/null | head -n1)
    if [[ ! -d ${basic_website_share}/etc/saml/idp/certificate ]]; then
        sudo -u secuser sh -c "mkdir -p ${basic_website_share}/etc/saml/idp/certificate"
    fi
    sudo -u secuser sh -c "cp -rfp /tmp/cert_idp/* ${basic_website_share}/etc/saml/idp/certificate"
    sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml"
    sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml/idp"
    sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml/idp/certificate"
    sudo -u secuser sh -c "chmod -R 600 ${basic_website_share}/etc/saml/idp/certificate/*"
    sudo -u secuser sh -c "rm -rf ${basic_website_share}/etc/saml/idp/certificate/idp.keystore"
    sudo -u secuser sh -c "rm -rf ${basic_website_share}/etc/saml/idp/certificate/security-config.properties"
}

function convert_ipv6()
{
    tmp_ip=$1
    if [[ $tmp_ip =~ "[" ]]; then
        echo ${tmp_ip}
    elif [[ "$tmp_ip" != "${tmp_ip#*[0-9].[0-9]}" ]]; then
        echo ${tmp_ip}
    elif [[ "$tmp_ip" != "${tmp_ip#*:[0-9a-fA-F]}" ]];then
        echo "[${tmp_ip}]"
    else
        echo ${tmp_ip}
    fi
}

function import_auth_saml_file()
{
    basic_service_ip_list=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global |grep smloglicwebsite | awk '$3=="SMLogLicWebsite" {print $6}')
    if [[ -z "$basic_service_ip_list" ]]; then
        product_name=`find /opt/oss/*/apps/ -name SMLogLicWebsite | cut -d'/' -f4`
        log "product name is ${product_name}."
        GET_SERVICE_NODE_IP=$(get_py_file ${MIGRATE_ROOT}/src/utils/get_service_nodesip.py)
        basic_service_ip_list=$(python ${GET_SERVICE_NODE_IP} ${product_name} SMLogLicWebsite)
        if [[ -z "$basic_service_ip_list" ]]; then
            log "basic_service_ip_list not exist."
            return
        fi
    fi

    if [[ -d ${auth_file_back_path}/cert_sp ]] && [[ -f ${auth_file_back_path}/cert_sp/signing_cert.pem ]]; then
        log "etc saml sp cert exist."
        chmod -R 777 ${auth_file_back_path}/cert_sp
        cp -rf ${auth_file_back_path}/cert_sp /tmp
        chmod -R 777 /tmp/cert_sp
        for service_ip in ${basic_service_ip_list}
        do
            log "import_auth_saml_file sp execute ip: ${service_ip}"
            if [[ ${service_ip} == ${CURRENT_SERVER_IP} ]]; then
                copy_saml_sp_current_ip
                continue
            fi
            scp -r -o 'StrictHostKeyChecking no' -o 'BatchMode yes' -o 'ConnectTimeout 5' /tmp/cert_sp $(convert_ipv6 ${service_ip}):/tmp/
            ssh -o StrictHostKeyChecking=no ossadm@${service_ip} << EOF
chmod -R 777 /tmp/cert_sp
rm -rf /tmp/cert_sp/sp.keystore
rm -rf /tmp/cert_sp/security-config.properties
if [[ ! -d ${basic_website_share}/etc/saml/certificate ]]
then
    sudo -u secuser sh -c "mkdir -p ${basic_website_share}/etc/saml/certificate"
fi
sudo -u secuser sh -c "cp -rfp /tmp/cert_sp/* ${basic_website_share}/etc/saml/certificate"
sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml"
sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml/certificate"
sudo -u secuser sh -c "chmod -R 600 ${basic_website_share}/etc/saml/certificate/*"
rm -rf /tmp/cert_sp
exit
EOF
        done
        rm -rf /tmp/cert_sp
    fi

    if [[ -d ${auth_file_back_path}/cert_idp ]] && [[ -f ${auth_file_back_path}/cert_idp/signing_cert.pem ]]; then
        log "etc saml idp cert exist."
        chmod -R 777 ${auth_file_back_path}/cert_idp
        cp -rf ${auth_file_back_path}/cert_idp /tmp
        chmod -R 777 /tmp/cert_idp
        for service_ip in ${basic_service_ip_list}
        do
            log "import_auth_saml_file idp execute ip: ${service_ip}"
            if [[ ${service_ip} == ${CURRENT_SERVER_IP} ]]; then
                copy_saml_idp_current_ip
                continue
            fi
            scp -r -o 'StrictHostKeyChecking no' -o 'BatchMode yes' -o 'ConnectTimeout 5' /tmp/cert_idp $(convert_ipv6 ${service_ip}):/tmp/
            ssh -o StrictHostKeyChecking=no ossadm@${service_ip} << EOF
chmod -R 777 /tmp/cert_idp
rm -rf /tmp/cert_idp/idp.keystore
rm -rf /tmp/cert_idp/security-config.properties
if [[ ! -d ${basic_website_share}/etc/saml/idp/certificate ]]
then
    sudo -u secuser sh -c "mkdir -p ${basic_website_share}/etc/saml/idp/certificate"
fi
sudo -u secuser sh -c "cp -rfp /tmp/cert_idp/* ${basic_website_share}/etc/saml/idp/certificate"
sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml"
sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml/idp"
sudo -u secuser sh -c "chmod 700 ${basic_website_share}/etc/saml/idp/certificate"
sudo -u secuser sh -c "chmod -R 600 ${basic_website_share}/etc/saml/idp/certificate/*"
rm -rf /tmp/cert_idp
exit
EOF
        done
        rm -rf /tmp/cert_idp
    fi
}

function delete_ldap_file()
{
    sm_service_ip_list=$(/opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -nodeip global |grep smloglicservice | awk '$3=="SMLogLicService" {print $6}')
    if [[ -z "$sm_service_ip_list" ]]; then
        product_name=`find /opt/oss/*/apps/ -name SMLogLicService | cut -d'/' -f4`
        log "product name is ${product_name}."
        GET_SERVICE_NODE_IP=$(get_py_file ${MIGRATE_ROOT}/src/utils/get_service_nodesip.py)
        sm_service_ip_list=$(python ${GET_SERVICE_NODE_IP} ${product_name} SMLogLicService)
        if [[ -z "$sm_service_ip_list" ]]; then
            log "sm_service_ip_list not exist."
            return
        fi
    fi
    for service_ip in ${sm_service_ip_list}
    do
        log "delete_ldap_file execute ip: ${service_ip}"
        ssh -o StrictHostKeyChecking=no ossadm@${service_ip} << EOF
sudo -u secuser sh -c "rm -rf ${OSS_SHARE_DIR}SMLogLicService/etc/ssl/ssl4ldap.client.properties"
exit
EOF
    done
}

# 第一个参数为目标路径，第二个参数为源路径，将源路径下的文件拷贝到目标路径
function create_backup_cert_path() {
    if [[ ! -d $1 ]]; then
        mkdir -p $1
        chmod -R 777 $1
    fi
    cp -rfp $2/* $1
    chmod -R 777 $1
}

function backup_cert_file() {
    if [[ -d ${OSS_SHARE_DIR}AuthService/etc/certificatemanager ]]; then
        log "etc certificate manager exist."
        sudo -u ossuser sh -c "cp -rf ${OSS_SHARE_DIR}AuthService/etc/certificatemanager /tmp;chmod -R 777 /tmp/certificatemanager"
        create_backup_cert_path ${auth_file_back_path}/certificatemanager /tmp/certificatemanager
        return
    fi
    if [[ -d ${OSS_SHARE_DIR}AuthService/etc/certificate ]]; then
        log "etc certificate exist."
        sudo -u ossuser sh -c "cp -rf ${OSS_SHARE_DIR}AuthService/etc/certificate /tmp; mv /tmp/certificate /tmp/certificatemanager;chmod -R 777 /tmp/certificatemanager"
        create_backup_cert_path ${auth_file_back_path}/certificatemanager /tmp/certificatemanager
        return
    fi
    log "etc certificate and manager not exist."
}

function backup_saml_cert_file() {
    auth_service_install=$(ls -dt /opt/oss/envs/*AuthService/* 2>/dev/null | head -n1)
    log "auth_service_install is: ${auth_service_install}"
    if [[ -d ${auth_service_install}/etc/saml/idp/cert ]]; then
        if [[ ! -d "/tmp/cert_idp" ]]; then
            sudo -u ossuser sh -c "mkdir /tmp/cert_idp"
        fi
        sudo -u ossuser sh -c "cp -rf ${auth_service_install}/etc/saml/idp/cert/idp.keystore /tmp/cert_idp"
        sudo -u ossuser sh -c "cp -rf ${auth_service_install}/etc/saml/security-config.properties /tmp/cert_idp; chmod -R 777 /tmp/cert_idp"
        create_backup_cert_path ${auth_file_back_path}/cert_idp /tmp/cert_idp
    fi

    if [[ -d ${auth_service_install}/etc/saml/sp/cert ]]; then
        if [[ ! -d "/tmp/cert_sp" ]]; then
            sudo -u ossuser sh -c "mkdir /tmp/cert_sp"
        fi
        sudo -u ossuser sh -c "cp -rf ${auth_service_install}/etc/saml/sp/cert/sp.keystore /tmp/cert_sp"
        sudo -u ossuser sh -c "cp -rf ${auth_service_install}/etc/saml/security-config.properties /tmp/cert_sp; chmod -R 777 /tmp/cert_sp"
        create_backup_cert_path ${auth_file_back_path}/cert_sp /tmp/cert_sp
    fi
}

function backup_auth_setting_file() {
    if [[ -d ${OSS_SHARE_DIR}AuthService/pub ]]; then
        log "securitySettings exist."
        if [[ ! -d  ${auth_file_back_path} ]]; then
            mkdir -p ${auth_file_back_path}
            chmod -R 777 ${auth_file_back_path}
        fi
        sudo -u ossuser sh -c "cp -rf  ${OSS_SHARE_DIR}AuthService/pub/auth/custom/securitySettings.json /tmp;chmod -R 777 /tmp/securitySettings.json"
        cp -rfp /tmp/securitySettings.json ${auth_file_back_path}
        chmod -R 777 ${auth_file_back_path}/securitySettings.json
        return
    fi
    log "securitySettings not exist."
}


if [[ ${handle_type} = 'export_data' ]]
then
    auth_service_share=$(ls -d /opt/oss/share/*/AuthService 2>/dev/null | head -n1)
    if [[ ! -z "${auth_service_share}" ]]
    then
        log "auth_service_share is: ${auth_service_share}"
        export OSS_SHARE_DIR=${auth_service_share}/../
    else
        log "auth_service_share is null."
        return
    fi
    mkdir -p ${auth_file_back_path}
    chmod 777 ${auth_file_back_path}
    backup_cert_file >> ${run_log} 2>&1
    backup_saml_cert_file >> ${run_log} 2>&1
    backup_auth_setting_file >> ${run_log} 2>&1
else
    auth_service_share=$(ls -d /opt/oss/share/*/SMLogLicService 2>/dev/null | head -n1)
    if [[ ! -z "${auth_service_share}" ]]
    then
        log "auth_service_share is: ${auth_service_share}"
        export OSS_SHARE_DIR=${auth_service_share}/../
    else
        log "auth_service_share is null."
        return
    fi
    CURRENT_SERVER_IP=$(cat /opt/oss/manager/var/agent/managerip.conf|grep "localip="|head -1|awk -F '=' '{print $NF}')
    import_auth_file >> ${run_log} 2>&1
    import_auth_saml_file >> ${run_log} 2>&1
    delete_ldap_file >> ${run_log} 2>&1
fi
