#!/bin/bash

# 执行迁移项名称对应的迁移步骤
export MIGRATE_MODULE_NAME=$1
export MIGRATE_CLASS_NAME=$2
export MIGRATE_STEP=$3


function check_paramters()
{
    if [[ -z ${MIGRATE_MODULE_NAME} || -z ${MIGRATE_CLASS_NAME} || -z ${MIGRATE_STEP} ]]
    then
        echo "usage $0 module_name class_name migrate_step"
        exit 0
    fi
}

function main()
{
    check_paramters

    local cur_path=$(cd "$(dirname $0)"; pwd)
    # 迁移工具所在根目录
    [[ -z ${MIGRATE_ROOT} ]] && export MIGRATE_ROOT=$(cd "${cur_path}/../../../"; pwd)
    # 工具所在根目录
    export TOOL_ROOT=$(cd ${cur_path}/../;pwd)

    source ${TOOL_ROOT}/frame/cloudsop_utils.sh

    # 日志文件
    export LOG_FILE=$(get_log_file)
    mkdir -p $(dirname ${LOG_FILE})

    # 进度文件
    export PROGRESS_FILE=$(get_progress_file)


    log "$(python --version),execute ${MIGRATE_MODULE_NAME}.${MIGRATE_CLASS_NAME}:${MIGRATE_STEP},MIGRATE_ROOT=${MIGRATE_ROOT},TOOL_ROOT=${TOOL_ROOT}"
    tool_entry=$(get_py_file ${TOOL_ROOT}/frame/cloudsop_transfer.py)
    python ${tool_entry} ${MIGRATE_MODULE_NAME} ${MIGRATE_CLASS_NAME} ${MIGRATE_STEP} ${@:4} >> ${LOG_FILE} 2>&1
}

main $*
exit $?
