/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;

public class HttpUtil {
    public static final int ZIP_BUFFER_SIZE = 8192;
    private static final String PROTOCOL_UNSECURE = "http";
    private static final String PROTOCOL_SECURE = "https";

    private HttpUtil() {
    }

    public static String constructUrl(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments) throws UnsupportedEncodingException {
        return HttpUtil.constructUrl(space, hostname, port, webAppName, serviceAndArguments, false);
    }

    public static String constructUrl(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments, boolean isSecure) throws UnsupportedEncodingException {
        String realHostname = space.environmentSubstitute(hostname);
        if (!StringUtils.isEmpty((String)webAppName)) {
            serviceAndArguments = "/" + space.environmentSubstitute(webAppName) + serviceAndArguments;
        }
        String protocol = isSecure ? PROTOCOL_SECURE : PROTOCOL_UNSECURE;
        String retval = protocol + "://" + realHostname + HttpUtil.getPortSpecification(space, port) + serviceAndArguments;
        retval = Const.replace(retval, " ", "%20");
        return retval;
    }

    public static String getPortSpecification(VariableSpace space, String port) {
        String realPort = space.environmentSubstitute(port);
        String portSpec = ":" + realPort;
        if (Utils.isEmpty(realPort) || port.equals("80")) {
            portSpec = "";
        }
        return portSpec;
    }

    public static String decodeBase64ZippedString(String loggingString64) throws IOException {
        if (loggingString64 == null || loggingString64.isEmpty()) {
            return "";
        }
        StringWriter writer = new StringWriter();
        byte[] bytes64 = Base64.decodeBase64((byte[])loggingString64.getBytes());
        ByteArrayInputStream zip = new ByteArrayInputStream(bytes64);
        try (GZIPInputStream unzip = new GZIPInputStream((InputStream)zip, 8192);
             BufferedInputStream in = new BufferedInputStream(unzip, 8192);
             InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF-8");){
            int length;
            char[] buff = new char[8192];
            while ((length = reader.read(buff)) > 0) {
                writer.write(buff, 0, length);
            }
        }
        return writer.toString();
    }

    public static String encodeBase64ZippedString(String in) throws IOException {
        Charset charset = Charset.forName("UTF-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (Base64OutputStream base64OutputStream = new Base64OutputStream((OutputStream)baos);
             GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)base64OutputStream);){
            gzos.write(in.getBytes(charset));
        }
        return baos.toString();
    }
}

