/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.connections.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.connections.annotations.Encrypted;
import org.pentaho.di.core.encryption.Encr;

public class EncryptUtils {
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";

    private EncryptUtils() {
    }

    public static void encryptFields(Object object) {
        List<Field> fields = EncryptUtils.getFields(object);
        fields.forEach(field -> {
            String value = EncryptUtils.getValue(object, field);
            if (value != null) {
                String encrypted = Encr.encryptPasswordIfNotUsingVariables(value);
                EncryptUtils.setValue(object, field, encrypted);
            }
        });
    }

    public static void decryptFields(Object connectionDetails) {
        List<Field> fields = EncryptUtils.getFields(connectionDetails);
        fields.forEach(field -> {
            String value = EncryptUtils.getValue(connectionDetails, field);
            if (value != null) {
                String decrypted = Encr.decryptPasswordOptionallyEncrypted(value);
                EncryptUtils.setValue(connectionDetails, field, decrypted);
            }
        });
    }

    private static List<Field> getFields(Object connectionDetails) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : connectionDetails.getClass().getDeclaredFields()) {
            Annotation annotation = Arrays.stream(field.getAnnotations()).filter(annotation1 -> annotation1 instanceof Encrypted).findAny().orElse(null);
            if (annotation == null) continue;
            fields.add(field);
        }
        return fields;
    }

    public static void setValue(Object object, Field field, String value) {
        try {
            Method setMethod = object.getClass().getMethod(SET_PREFIX + StringUtils.capitalize((String)field.getName()), String.class);
            setMethod.invoke(object, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static String getValue(Object object, Field field) {
        try {
            Method getMethod = object.getClass().getMethod(GET_PREFIX + StringUtils.capitalize((String)field.getName()), new Class[0]);
            if (getMethod != null) {
                return (String)getMethod.invoke(object, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

