/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogChannelFactory;
import org.pentaho.di.core.logging.LogChannelInterfaceFactory;
import org.pentaho.di.core.logging.LoggingBuffer;
import org.pentaho.di.core.logging.LoggingPrintStream;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.MetricsRegistry;
import org.pentaho.di.core.util.EnvUtil;

public class KettleLogStore {
    public static PrintStream OriginalSystemOut = System.out;
    public static PrintStream OriginalSystemErr = System.err;
    private static KettleLogStore store;
    private LoggingBuffer appender;
    private Timer logCleanerTimer;
    private static AtomicBoolean initialized;
    private static LogChannelInterfaceFactory logChannelInterfaceFactory;

    public static LogChannelInterfaceFactory getLogChannelInterfaceFactory() {
        return logChannelInterfaceFactory;
    }

    public static void setLogChannelInterfaceFactory(LogChannelInterfaceFactory logChannelInterfaceFactory) {
        KettleLogStore.logChannelInterfaceFactory = logChannelInterfaceFactory;
    }

    private KettleLogStore(int maxSize, int maxLogTimeoutMinutes, boolean redirectStdOut, boolean redirectStdErr) {
        this.appender = new LoggingBuffer(maxSize);
        this.replaceLogCleaner(maxLogTimeoutMinutes);
        if (redirectStdOut) {
            System.setOut(new LoggingPrintStream(OriginalSystemOut));
        }
        if (redirectStdErr) {
            System.setErr(new LoggingPrintStream(OriginalSystemErr));
        }
    }

    public void replaceLogCleaner(final int maxLogTimeoutMinutes) {
        if (this.logCleanerTimer != null) {
            this.logCleanerTimer.cancel();
        }
        this.logCleanerTimer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                if (maxLogTimeoutMinutes > 0) {
                    long minTimeBoundary = new Date().getTime() - (long)(maxLogTimeoutMinutes * 60 * 1000);
                    KettleLogStore.this.appender.removeBufferLinesBefore(minTimeBoundary);
                }
            }
        };
        this.logCleanerTimer.schedule(timerTask, 10000L, 10000L);
    }

    public static void init(int maxSize, int maxLogTimeoutMinutes, boolean redirectStdOut, boolean redirectStdErr) {
        if (maxSize > 0 || maxLogTimeoutMinutes > 0) {
            KettleLogStore.init0(maxSize, maxLogTimeoutMinutes, redirectStdOut, redirectStdErr);
        } else {
            KettleLogStore.init(redirectStdOut, redirectStdErr);
        }
    }

    public static void init(int maxSize, int maxLogTimeoutMinutes) {
        KettleLogStore.init(maxSize, maxLogTimeoutMinutes, EnvUtil.getSystemProperty("KETTLE_REDIRECT_STDOUT", "N").equalsIgnoreCase("Y"), EnvUtil.getSystemProperty("KETTLE_REDIRECT_STDERR", "N").equalsIgnoreCase("Y"));
    }

    public static void init() {
        KettleLogStore.init(EnvUtil.getSystemProperty("KETTLE_REDIRECT_STDOUT", "N").equalsIgnoreCase("Y"), EnvUtil.getSystemProperty("KETTLE_REDIRECT_STDERR", "N").equalsIgnoreCase("Y"));
    }

    public static void init(boolean redirectStdOut, boolean redirectStdErr) {
        int maxSize = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOG_SIZE_IN_LINES"), 5000);
        int maxLogTimeoutMinutes = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOG_TIMEOUT_IN_MINUTES"), 1440);
        KettleLogStore.init0(maxSize, maxLogTimeoutMinutes, redirectStdOut, redirectStdErr);
    }

    private static synchronized void init0(int maxSize, int maxLogTimeoutMinutes, boolean redirectStdOut, boolean redirectStdErr) {
        if (store != null) {
            KettleLogStore.store.appender.setMaxNrLines(maxSize);
            store.replaceLogCleaner(maxLogTimeoutMinutes);
        } else {
            store = new KettleLogStore(maxSize, maxLogTimeoutMinutes, redirectStdOut, redirectStdErr);
        }
        initialized.set(true);
    }

    public static KettleLogStore getInstance() {
        if (store == null) {
            throw new RuntimeException("Central Log Store is not initialized!!!");
        }
        return store;
    }

    public static int getLastBufferLineNr() {
        return KettleLogStore.getInstance().appender.getLastBufferLineNr();
    }

    public static List<KettleLoggingEvent> getLogBufferFromTo(String parentLogChannelId, boolean includeGeneral, int from, int to) {
        return KettleLogStore.getInstance().appender.getLogBufferFromTo(parentLogChannelId, includeGeneral, from, to);
    }

    public static List<KettleLoggingEvent> getLogBufferFromTo(List<String> channelId, boolean includeGeneral, int from, int to) {
        return KettleLogStore.getInstance().appender.getLogBufferFromTo(channelId, includeGeneral, from, to);
    }

    public static LoggingBuffer getAppender() {
        return KettleLogStore.getInstance().appender;
    }

    public static void discardLines(String parentLogChannelId, boolean includeGeneralMessages) {
        LoggingRegistry registry = LoggingRegistry.getInstance();
        MetricsRegistry metricsRegistry = MetricsRegistry.getInstance();
        List<String> ids = registry.getLogChannelChildren(parentLogChannelId);
        LoggingBuffer bufferAppender = KettleLogStore.getInstance().appender;
        for (String id : ids) {
            bufferAppender.removeChannelFromBuffer(id);
            metricsRegistry.getSnapshotLists().remove(id);
            metricsRegistry.getSnapshotMaps().remove(id);
        }
        registry.removeIncludingChildren(parentLogChannelId);
        if (includeGeneralMessages) {
            bufferAppender.removeGeneralMessages();
        }
    }

    public static boolean isInitialized() {
        return initialized.get();
    }

    public void reset() {
        if (initialized.compareAndSet(true, false)) {
            this.appender = null;
            if (this.logCleanerTimer != null) {
                this.logCleanerTimer.cancel();
                this.logCleanerTimer = null;
            }
            store = null;
        }
    }

    static {
        initialized = new AtomicBoolean(false);
        logChannelInterfaceFactory = new LogChannelFactory();
    }
}

