/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row.value;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaPlugin;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@PluginMainClassType(value=ValueMetaInterface.class)
@PluginAnnotationType(value=ValueMetaPlugin.class)
public class ValueMetaPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static ValueMetaPluginType valueMetaPluginType;

    private ValueMetaPluginType() {
        super(ValueMetaPlugin.class, "VALUEMETA", "ValueMeta");
        this.populateFolders("valuemeta");
    }

    public static ValueMetaPluginType getInstance() {
        if (valueMetaPluginType == null) {
            valueMetaPluginType = new ValueMetaPluginType();
        }
        return valueMetaPluginType;
    }

    @Override
    protected String getXmlPluginFile() {
        return "kettle-valuemeta-plugins.xml";
    }

    @Override
    protected String getAlternativePluginFile() {
        return "KETTLE_VALUEMETA_PLUGINS_FILE";
    }

    @Override
    protected String getMainTag() {
        return "valuemeta-plugins";
    }

    @Override
    protected String getSubTag() {
        return "valuemeta-plugin";
    }

    @Override
    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List<FileObject> pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile(file);
                    Node pluginNode = XMLHandler.getSubNode(document, "plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename(file.getParent()), this.getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading step plugin.xml file: " + file.getName().toString(), e);
                }
            }
        }
    }

    @Override
    protected String extractCategory(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractDesc(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).description();
    }

    @Override
    protected String extractID(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).id();
    }

    @Override
    protected String extractName(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).name();
    }

    @Override
    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    @Override
    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).isSeparateClassLoaderNeeded();
    }

    @Override
    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    @Override
    protected String extractDocumentationUrl(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).documentationUrl();
    }

    @Override
    protected String extractSuggestion(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractCasesUrl(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).casesUrl();
    }

    @Override
    protected String extractForumUrl(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).forumUrl();
    }

    @Override
    protected String extractClassLoaderGroup(Annotation annotation) {
        return ((ValueMetaPlugin)annotation).classLoaderGroup();
    }
}

