/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.i18n;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.LanguageChoice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMessageUtil {
    private static final Logger log = LoggerFactory.getLogger(GlobalMessageUtil.class);
    public static final Locale FAILOVER_LOCALE = Locale.US;
    protected static final LanguageChoice langChoice = LanguageChoice.getInstance();
    protected static final ThreadLocal<Locale> threadLocales = new ThreadLocal();

    public static String formatErrorMessage(String key, String msg) {
        String s2 = key.substring(0, key.indexOf(46) + "ERROR_0000".length() + 1);
        return BaseMessages.getString("MESSUTIL.ERROR_FORMAT_MASK", s2, msg);
    }

    private static String decorateMissingKey(String key) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append('!').append(key).append('!');
        return keyBuilder.toString();
    }

    public static String getString(ResourceBundle bundle, String key) throws MissingResourceException {
        return MessageFormat.format(bundle.getString(key), new Object[0]);
    }

    public static String getErrorString(ResourceBundle bundle, String key) {
        return GlobalMessageUtil.formatErrorMessage(key, GlobalMessageUtil.getString(bundle, key));
    }

    public static String getString(ResourceBundle bundle, String key, String param1) {
        try {
            Object[] args = new Object[]{param1};
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            return GlobalMessageUtil.decorateMissingKey(key);
        }
    }

    public static String getErrorString(ResourceBundle bundle, String key, String param1) {
        return GlobalMessageUtil.formatErrorMessage(key, GlobalMessageUtil.getString(bundle, key, param1));
    }

    public static String getString(ResourceBundle bundle, String key, String param1, String param2) {
        try {
            Object[] args = new Object[]{param1, param2};
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            return GlobalMessageUtil.decorateMissingKey(key);
        }
    }

    public static String getErrorString(ResourceBundle bundle, String key, String param1, String param2) {
        return GlobalMessageUtil.formatErrorMessage(key, GlobalMessageUtil.getString(bundle, key, param1, param2));
    }

    public static String getString(ResourceBundle bundle, String key, String param1, String param2, String param3) {
        try {
            Object[] args = new Object[]{param1, param2, param3};
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            return GlobalMessageUtil.decorateMissingKey(key);
        }
    }

    public static String getErrorString(ResourceBundle bundle, String key, String param1, String param2, String param3) {
        return GlobalMessageUtil.formatErrorMessage(key, GlobalMessageUtil.getString(bundle, key, param1, param2, param3));
    }

    public static String getString(ResourceBundle bundle, String key, String param1, String param2, String param3, String param4) {
        try {
            Object[] args = new Object[]{param1, param2, param3, param4};
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            return GlobalMessageUtil.decorateMissingKey(key);
        }
    }

    public static String getString(ResourceBundle bundle, String key, String param1, String param2, String param3, String param4, String param5) {
        try {
            Object[] args = new Object[]{param1, param2, param3, param4, param5};
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            return GlobalMessageUtil.decorateMissingKey(key);
        }
    }

    public static String getString(ResourceBundle bundle, String key, String param1, String param2, String param3, String param4, String param5, String param6) {
        try {
            Object[] args = new Object[]{param1, param2, param3, param4, param5, param6};
            return MessageFormat.format(bundle.getString(key), args);
        }
        catch (Exception e) {
            return GlobalMessageUtil.decorateMissingKey(key);
        }
    }

    public static String getErrorString(ResourceBundle bundle, String key, String param1, String param2, String param3, String param4) {
        return GlobalMessageUtil.formatErrorMessage(key, GlobalMessageUtil.getString(bundle, key, param1, param2, param3, param4));
    }

    public static void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    public static Locale getLocale() {
        Locale rtn = threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        GlobalMessageUtil.setLocale(langChoice.getDefaultLocale());
        return langChoice.getDefaultLocale();
    }

    public static LinkedHashSet<Locale> getActiveLocales() {
        LinkedHashSet<Locale> activeLocales = new LinkedHashSet<Locale>();
        activeLocales.add(langChoice.getDefaultLocale());
        activeLocales.add(FAILOVER_LOCALE);
        activeLocales.add(Locale.ROOT);
        return activeLocales;
    }

    public static String calculateString(String[] pkgNames, String key, Object[] parameters, Class<?> resourceClass, String bundleName) {
        return GlobalMessageUtil.calculateString(pkgNames, key, parameters, resourceClass, bundleName, false, false);
    }

    public static String calculateString(String[] pkgNames, String key, Object[] parameters, Class<?> resourceClass, String bundleName, boolean fallbackOnRoot) {
        return GlobalMessageUtil.calculateString(pkgNames, key, parameters, resourceClass, bundleName, false, fallbackOnRoot);
    }

    public static String calculateString(String[] pkgNames, String key, Object[] parameters, Class<?> resourceClass, String bundleName, boolean logNotFoundError, boolean fallbackOnRoot) {
        LinkedHashSet<Locale> activeLocales = GlobalMessageUtil.getActiveLocales();
        for (Locale locale : activeLocales) {
            String string = GlobalMessageUtil.calculateString(pkgNames, locale, key, parameters, resourceClass, bundleName, fallbackOnRoot);
            if (GlobalMessageUtil.isMissingKey(string)) continue;
            return string;
        }
        if (logNotFoundError) {
            StringBuilder msg = new StringBuilder();
            msg.append("Message not found in the preferred and failover locale: key=[").append(key).append("], package=").append(Arrays.asList(pkgNames));
            log.error(Const.getStackTracker(new KettleException(msg.toString())));
        }
        return GlobalMessageUtil.decorateMissingKey(key);
    }

    private static String calculateString(String[] pkgNames, Locale locale, String key, Object[] parameters, Class<?> resourceClass, String bundleName, boolean fallbackOnRoot) {
        for (String packageName : pkgNames) {
            try {
                return GlobalMessageUtil.calculateString(packageName, locale, key, parameters, resourceClass, bundleName, fallbackOnRoot);
            }
            catch (MissingResourceException e) {
            }
        }
        return null;
    }

    static String calculateString(String packageName, Locale locale, String key, Object[] parameters, Class<?> resourceClass, String bundleName) {
        return GlobalMessageUtil.calculateString(packageName, locale, key, parameters, resourceClass, bundleName, true);
    }

    @VisibleForTesting
    static String calculateString(String packageName, Locale locale, String key, Object[] parameters, Class<?> resourceClass, String bundleName, boolean fallbackOnRoot) throws MissingResourceException {
        try {
            ResourceBundle bundle = GlobalMessageUtil.getBundle(locale, packageName + "." + bundleName, resourceClass, fallbackOnRoot);
            String unformattedString = bundle.getString(key);
            String string = MessageFormat.format(unformattedString, parameters);
            return string;
        }
        catch (IllegalArgumentException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Format problem with key=[").append(key).append("], locale=[").append(locale).append("], package=").append(packageName).append(" : ").append(e.toString());
            log.error(msg.toString());
            log.error(Const.getStackTracker(e));
            throw new MissingResourceException(msg.toString(), packageName, key);
        }
    }

    public static ResourceBundle getBundle(String packagePath, Class<?> resourceClass) throws MissingResourceException {
        LinkedHashSet<Locale> activeLocales = GlobalMessageUtil.getActiveLocales();
        for (Locale locale : activeLocales) {
            try {
                return GlobalMessageUtil.getBundle(locale, packagePath, resourceClass);
            }
            catch (MissingResourceException e) {
                StringBuilder msg = new StringBuilder();
                msg.append("Unable to find properties file for package '").append(packagePath).append("' and class '").append(resourceClass.getName()).append("' in the available locales: ").append(locale);
                log.warn(msg.toString());
            }
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Unable to find properties file for package '").append(packagePath).append("' and class '").append(resourceClass.getName()).append("' in the available locales: ").append(Arrays.asList(activeLocales));
        throw new MissingResourceException(msg.toString(), resourceClass.getName(), packagePath);
    }

    public static ResourceBundle getBundle(Locale locale, String packagePath, Class<?> resourceClass) {
        return GlobalMessageUtil.getBundle(locale, packagePath, resourceClass, true);
    }

    public static ResourceBundle getBundle(Locale locale, String packagePath, Class<?> resourceClass, boolean fallbackOnRoot) {
        ResourceBundle bundle;
        GlobalMessageControl control = new GlobalMessageControl(fallbackOnRoot);
        String resourceName = control.toResourceName(control.toBundleName(packagePath, locale), "properties");
        try {
            bundle = ResourceBundle.getBundle(packagePath, locale, resourceClass.getClassLoader(), new GlobalMessageControl(fallbackOnRoot));
        }
        catch (MissingResourceException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Unable to find properties file '").append(resourceName).append("': ").append(e.toString());
            throw new MissingResourceException(msg.toString(), resourceClass.getName(), packagePath);
        }
        return bundle;
    }

    protected static String getLocaleString(Locale locale) {
        StringBuilder localeString = new StringBuilder();
        if (locale != null && !StringUtils.isBlank((String)locale.getLanguage())) {
            if (!StringUtils.isBlank((String)locale.getCountry())) {
                localeString.append(locale.getLanguage().toLowerCase()).append('_').append(locale.getCountry().toUpperCase());
            } else {
                localeString.append(locale.getLanguage().toLowerCase());
            }
        }
        return localeString.toString();
    }

    protected static boolean isMissingKey(String string) {
        return string == null || string.trim().startsWith("!") && string.trim().endsWith("!") && !string.trim().equals("!");
    }

    static class GlobalMessageControl
    extends ResourceBundle.Control {
        private boolean fallbackOnRoot;

        GlobalMessageControl(boolean fallbackOnRoot) {
            this.fallbackOnRoot = fallbackOnRoot;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return null;
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> locales = super.getCandidateLocales(baseName, locale);
            if (!this.fallbackOnRoot && !locale.equals(Locale.ROOT)) {
                locales.remove(Locale.ROOT);
            }
            return locales;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            PropertyResourceBundle bundle;
            String resourceName = this.toResourceName(this.toBundleName(baseName, locale), "properties");
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream == null) {
                stream = ClassLoader.getSystemResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8.name()));
                }
                finally {
                    stream.close();
                }
            } else {
                StringBuilder msg = new StringBuilder();
                msg.append("Unable to find properties file '").append(resourceName).append("'");
                throw new MissingResourceException(msg.toString(), loader.getClass().getName(), baseName);
            }
            return bundle;
        }
    }
}

