/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.gvt.GraphicsNode;
import org.pentaho.di.core.SwingUniversalImage;
import org.pentaho.di.core.svg.SvgImage;

public class SwingUniversalImageSvg
extends SwingUniversalImage {
    private final GraphicsNode svgGraphicsNode;
    private final Dimension2D svgGraphicsSize;

    public SwingUniversalImageSvg(SvgImage svg) {
        UserAgentAdapter userAgentAdapter = new UserAgentAdapter();
        DocumentLoader documentLoader = new DocumentLoader((UserAgent)userAgentAdapter);
        BridgeContext ctx = new BridgeContext((UserAgent)userAgentAdapter, documentLoader);
        GVTBuilder builder = new GVTBuilder();
        this.svgGraphicsNode = builder.build(ctx, svg.getDocument());
        this.svgGraphicsSize = ctx.getDocumentSize();
    }

    @Override
    public boolean isBitmap() {
        return false;
    }

    @Override
    protected void renderSimple(BufferedImage area) {
        Graphics2D gc = SwingUniversalImageSvg.createGraphics(area);
        this.render(gc, area.getWidth() / 2, area.getHeight() / 2, area.getWidth(), area.getHeight(), 0.0);
        gc.dispose();
    }

    @Override
    protected void render(Graphics2D gc, int centerX, int centerY, int width, int height, double angleRadians) {
        SwingUniversalImageSvg.render(gc, this.svgGraphicsNode, this.svgGraphicsSize, centerX, centerY, width, height, angleRadians);
    }

    public static void render(Graphics2D gc, GraphicsNode svgGraphicsNode, Dimension2D svgGraphicsSize, int centerX, int centerY, int width, int height, double angleRadians) {
        double scaleX = (double)width / svgGraphicsSize.getWidth();
        double scaleY = (double)height / svgGraphicsSize.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        if (centerX != 0 || centerY != 0) {
            affineTransform.translate(centerX, centerY);
        }
        affineTransform.scale(scaleX, scaleY);
        if (angleRadians != 0.0) {
            affineTransform.rotate(angleRadians);
        }
        affineTransform.translate(-svgGraphicsSize.getWidth() / 2.0, -svgGraphicsSize.getHeight() / 2.0);
        svgGraphicsNode.setTransform(affineTransform);
        svgGraphicsNode.paint(gc);
    }
}

